/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vltno.timeloop.LoopCommands;
import com.vltno.timeloop.LoopTypes;
import com.vltno.timeloop.TimeLoop;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7225;

public class TogglesCommands {
    public static void register(LiteralArgumentBuilder<class_2168> settingsCommandBuilder) {
        LiteralArgumentBuilder togglesNode = class_2170.method_9247((String)"toggles");
        togglesNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trackTimeOfDay").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Track time of day is set to: " + TimeLoop.trackTimeOfDay)), false);
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::trackTimeOfDay)));
        togglesNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trackItems").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Track items is set to: " + TimeLoop.trackItems)), false);
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::trackItems)));
        togglesNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trackInventory").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Track inventory is set to: " + TimeLoop.trackInventory)), false);
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::trackInventory)));
        togglesNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"displayTimeInTicks").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Display time in ticks is set to: " + TimeLoop.displayTimeInTicks)), false);
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::displayTimeInTicks)));
        togglesNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"showLoopInfo").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Show loop info is set to: " + TimeLoop.showLoopInfo)), false);
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::showLoopInfo)));
        togglesNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trackChat").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Track chat is set to: " + TimeLoop.trackChat)), false);
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::trackChat)));
        togglesNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"hurtLoopedPlayers").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Hurt looped players is set to: " + TimeLoop.hurtLoopedPlayers)), false);
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::hurtLoopedPlayers)));
        settingsCommandBuilder.then((ArgumentBuilder)togglesNode);
    }

    private static int trackTimeOfDay(CommandContext<class_2168> context) {
        boolean newTrackTimeOfDay;
        class_2168 source = (class_2168)context.getSource();
        TimeLoop.trackTimeOfDay = newTrackTimeOfDay = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.trackTimeOfDay = newTrackTimeOfDay;
        TimeLoop.config.save();
        source.method_9226(() -> class_2561.method_43470((String)("Track time of day is set to: " + newTrackTimeOfDay)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Track time of day set to {}", (Object)newTrackTimeOfDay);
        return 1;
    }

    private static int trackItems(CommandContext<class_2168> context) {
        boolean newTrackItems;
        class_2168 source = (class_2168)context.getSource();
        TimeLoop.trackItems = newTrackItems = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.trackItems = newTrackItems;
        TimeLoop.config.save();
        TimeLoop.updateEntitiesToTrack(newTrackItems);
        source.method_9226(() -> class_2561.method_43470((String)("Track items is set to: " + newTrackItems)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Track items set to {}", (Object)newTrackItems);
        return 1;
    }

    private static int trackInventory(CommandContext<class_2168> context) {
        boolean newTrackInventory;
        class_2168 source = (class_2168)context.getSource();
        TimeLoop.trackInventory = newTrackInventory = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.trackInventory = newTrackInventory;
        TimeLoop.config.save();
        TimeLoop.loopSceneManager.forEachRecordingPlayer(playerData -> {
            String playerName = playerData.getName();
            class_3222 player = TimeLoop.server.method_3760().method_14566(playerName);
            class_5455.class_6890 provider = TimeLoop.server.method_30611();
            class_2487 invTag = TimeLoop.saveFullInventory((class_1657)player, (class_7225.class_7874)provider);
            playerData.setInventoryTag(invTag);
        });
        source.method_9226(() -> class_2561.method_43470((String)("Track inventory is set to: " + newTrackInventory)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Track inventory set to {}", (Object)newTrackInventory);
        return 1;
    }

    private static int displayTimeInTicks(CommandContext<class_2168> context) {
        boolean newDisplayTimeInTicks;
        class_2168 source = (class_2168)context.getSource();
        TimeLoop.displayTimeInTicks = newDisplayTimeInTicks = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.displayTimeInTicks = newDisplayTimeInTicks;
        TimeLoop.config.save();
        source.method_9226(() -> class_2561.method_43470((String)("Display time in ticks is set to: " + newDisplayTimeInTicks)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Display time in ticks set to {}", (Object)newDisplayTimeInTicks);
        return 1;
    }

    private static int showLoopInfo(CommandContext<class_2168> context) {
        boolean newShowLoopInfo;
        class_2168 source = (class_2168)context.getSource();
        TimeLoop.showLoopInfo = newShowLoopInfo = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.showLoopInfo = newShowLoopInfo;
        TimeLoop.config.save();
        if (TimeLoop.loopBossBar != null) {
            if (newShowLoopInfo) {
                TimeLoop.loopBossBar.visible(TimeLoop.loopType != null && (TimeLoop.loopType.equals((Object)LoopTypes.TICKS) || TimeLoop.loopType.equals((Object)LoopTypes.TIME_OF_DAY)));
            } else {
                TimeLoop.loopBossBar.visible(false);
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)("Show loop info is set to: " + newShowLoopInfo)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Show loop info set to {}", (Object)newShowLoopInfo);
        return 1;
    }

    private static int trackChat(CommandContext<class_2168> context) {
        boolean newTrackChat;
        class_2168 source = (class_2168)context.getSource();
        TimeLoop.trackChat = newTrackChat = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.trackChat = newTrackChat;
        TimeLoop.config.save();
        TimeLoop.executeCommand("mocap settings recording chat_recording " + newTrackChat);
        source.method_9226(() -> class_2561.method_43470((String)("Track chat is set to: " + newTrackChat)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Track chat set to {}", (Object)newTrackChat);
        return 1;
    }

    private static int hurtLoopedPlayers(CommandContext<class_2168> context) {
        boolean newHurtLoopedPlayers;
        class_2168 source = (class_2168)context.getSource();
        TimeLoop.hurtLoopedPlayers = newHurtLoopedPlayers = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.hurtLoopedPlayers = newHurtLoopedPlayers;
        TimeLoop.config.save();
        TimeLoop.executeCommand("mocap settings playback invulnerable_playback " + !newHurtLoopedPlayers);
        source.method_9226(() -> class_2561.method_43470((String)("Hurt looped players is set to: " + newHurtLoopedPlayers)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Hurt looped players set to {}", (Object)newHurtLoopedPlayers);
        return 1;
    }
}

