/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.vltno.timeloop.LoopBossBar;
import com.vltno.timeloop.LoopSceneManager;
import com.vltno.timeloop.LoopTypes;
import com.vltno.timeloop.RewindTypes;
import com.vltno.timeloop.TimeLoopConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeLoop {
    public static final Logger LOOP_LOGGER = LoggerFactory.getLogger((String)"TimeLoop");
    public static MinecraftServer server;
    public static class_3218 serverLevel;
    public static LoopBossBar loopBossBar;
    public static int loopIteration;
    public static int loopLengthTicks;
    public static long startTimeOfDay;
    public static long timeSetting;
    public static boolean trackTimeOfDay;
    public static boolean isLooping;
    public static int maxLoops;
    public static int tickCounter;
    public static int ticksLeft;
    public static boolean showLoopInfo;
    public static boolean displayTimeInTicks;
    public static boolean trackItems;
    public static LoopTypes loopType;
    public static boolean trackChat;
    public static boolean hurtLoopedPlayers;
    public static RewindTypes rewindType;
    public static boolean trackInventory;
    public static TimeLoopConfig config;
    public static LoopSceneManager loopSceneManager;
    public static Path worldFolder;
    public static boolean isDedicatedServer;

    public static void init(boolean isDedicatedServer) {
        TimeLoop.isDedicatedServer = isDedicatedServer;
        loopBossBar = new LoopBossBar();
        LOOP_LOGGER.info("Initializing TimeLoop mod (Common)");
    }

    public static void executeCommand(String command) {
        if (server == null) {
            LOOP_LOGGER.error("Attempted to execute command while server is null: {}", (Object)command);
        }
        server.execute(() -> {
            try {
                class_2170 commands = server.method_3734();
                class_2168 commandSource = server.method_3739();
                LOOP_LOGGER.info("Executing command: {}", (Object)command);
                commands.method_9235().execute(command, (Object)commandSource);
                LOOP_LOGGER.info("Command executed successfully: {}", (Object)command);
            }
            catch (CommandSyntaxException e) {
                LOOP_LOGGER.error("Failed to execute command '{}' due to syntax error: {}", (Object)command, (Object)e.getMessage());
            }
            catch (Exception e) {
                LOOP_LOGGER.error("An unexpected error occurred while executing command '{}': {}", new Object[]{command, e.getMessage(), e});
            }
        });
    }

    public static void runLoopIteration() {
        if (loopIteration + 1 >= maxLoops) {
            TimeLoop.stopLoop();
        }
        LOOP_LOGGER.info("Starting iteration {} of loop", (Object)loopIteration);
        TimeLoop.saveRecordings();
        TimeLoop.removeOldSceneEntries();
        TimeLoop.startRecordings();
        if (trackTimeOfDay) {
            serverLevel.method_29199(startTimeOfDay);
        }
        TimeLoop.executeCommand("mocap playback stop_all including_others");
        loopSceneManager.forEachRecordingPlayer(playerData -> {
            String playerName = playerData.getName();
            String playerNickname = playerData.getNickname();
            String playerSkin = playerData.getSkin();
            class_243 startPosition = playerData.getStartPosition();
            class_243 joinPosition = playerData.getJoinPosition();
            class_2487 inventoryTag = playerData.getInventoryTag();
            class_3222 player = server.method_3760().method_14566(playerName);
            class_5455.class_6890 provider = server.method_30611();
            if (trackInventory) {
                TimeLoop.loadFullInventory((class_1657)player, inventoryTag, (class_7225.class_7874)provider);
            }
            switch (rewindType) {
                case START_POSITION: {
                    if (startPosition == null) {
                        LOOP_LOGGER.error("Player {} has no start position yet. Defaulting to join position.", (Object)playerName);
                        player.method_5859(joinPosition.field_1352, joinPosition.field_1351, joinPosition.field_1350);
                        return;
                    }
                    player.method_5859(startPosition.field_1352, startPosition.field_1351, startPosition.field_1350);
                    break;
                }
                case JOIN_POSITION: {
                    if (joinPosition == null) {
                        LOOP_LOGGER.error("Player {} has no join position yet. (somehow??)", (Object)playerName);
                        return;
                    }
                    player.method_5859(joinPosition.field_1352, joinPosition.field_1351, joinPosition.field_1350);
                    break;
                }
                case SPAWN_POSITION: {
                    class_2338 spawnPosition = server.method_30002().method_43126();
                    if (spawnPosition == null) {
                        LOOP_LOGGER.error("Server has no spawn position yet. (somehow??)");
                        return;
                    }
                    player.method_5859((double)spawnPosition.method_10263(), (double)spawnPosition.method_10264(), (double)spawnPosition.method_10260());
                }
            }
            String playerSceneName = loopSceneManager.getPlayerSceneName(playerName);
            TimeLoop.executeCommand(String.format("mocap playback start .%s %s skin_from_player %s", playerSceneName, playerNickname, playerSkin));
        });
        TimeLoop.config.loopIteration = ++loopIteration;
        config.save();
        LOOP_LOGGER.info("Completed loop iteration {}", (Object)(loopIteration - 1));
    }

    public static void startLoop() {
        if (isLooping) {
            LOOP_LOGGER.info("Attempted to start already running recording loop");
            return;
        }
        if (showLoopInfo) {
            loopBossBar.visible(loopType.equals((Object)LoopTypes.TICKS) || loopType.equals((Object)LoopTypes.TIME_OF_DAY));
        }
        loopSceneManager.forEachRecordingPlayer(playerData -> {
            String playerName = playerData.getName();
            class_3222 player = server.method_3760().method_14566(playerName);
            class_5455.class_6890 provider = server.method_30611();
            class_2487 invTag = TimeLoop.saveFullInventory((class_1657)player, (class_7225.class_7874)provider);
            playerData.setInventoryTag(invTag);
            playerData.setStartPosition(server.method_3760().method_14566(playerName).method_19538());
        });
        isLooping = true;
        TimeLoop.config.isLooping = true;
        tickCounter = 0;
        ticksLeft = loopLengthTicks;
        LOOP_LOGGER.info("Starting Loop");
        TimeLoop.startRecordings();
    }

    public static void startRecordings() {
        loopSceneManager.forEachRecordingPlayer(playerData -> {
            String playerName = playerData.getName();
            TimeLoop.executeCommand(String.format("mocap recording start %s", playerName));
        });
    }

    public static void saveRecordings() {
        loopSceneManager.forEachRecordingPlayer(playerData -> {
            String playerName = playerData.getName();
            String recordingName = playerName + "_" + System.currentTimeMillis();
            String playerSceneName = loopSceneManager.getPlayerSceneName(playerName);
            LOOP_LOGGER.info("Processing recording for player: {}", (Object)playerName);
            TimeLoop.executeCommand(String.format("mocap recording stop -+mc.%s.1", playerName));
            TimeLoop.executeCommand(String.format("mocap recording save %s -+mc.%s.1", recordingName.toLowerCase(), playerName));
            if (TimeLoop.recordingFileExists(recordingName)) {
                TimeLoop.executeCommand(String.format("mocap scenes add_to %s %s", playerSceneName, recordingName.toLowerCase()));
            }
        });
    }

    public static void stopLoop() {
        if (isLooping) {
            LOOP_LOGGER.info("Stopping loop");
            isLooping = false;
            TimeLoop.config.isLooping = false;
            loopBossBar.visible(false);
            TimeLoop.saveRecordings();
            loopSceneManager.saveRecordingPlayers();
            TimeLoop.executeCommand("mocap playback stop_all including_others");
            tickCounter = 0;
            ticksLeft = loopLengthTicks;
            LOOP_LOGGER.info("Loop stopped!");
        }
    }

    private static boolean recordingFileExists(String recordingName) {
        Path recordingDir = worldFolder.resolve("mocap_files").resolve("recordings");
        Path recordingFile = recordingDir.resolve(recordingName.toLowerCase() + ".mcmocap_rec");
        boolean exists = recordingFile.toFile().exists();
        if (!exists) {
            LOOP_LOGGER.error("Expected recording file does not exist: {}", (Object)recordingFile.toAbsolutePath());
        }
        return exists;
    }

    public static void modifyPlayerAttributes(String targetPlayerName, String newPlayerNickname, String newSkin) {
        String playerSceneName = loopSceneManager.getPlayerSceneName(targetPlayerName);
        TimeLoop.executeCommand(String.format("mocap scenes modify .%s %s player_skin skin_from_player %s", playerSceneName, newPlayerNickname, newSkin));
        loopSceneManager.forEachRecordingPlayer(playerData -> {
            if (playerData.getName().equals(targetPlayerName)) {
                playerData.setNickname(newPlayerNickname);
                playerData.setSkin(newSkin);
                LOOP_LOGGER.info("Modified loop attributes for player '{}' -> '{}' with skin '{}'", new Object[]{targetPlayerName, newPlayerNickname, newSkin});
            }
        });
    }

    public static void updateEntitiesToTrack(boolean items) {
        String entitiesToTrack = "@vehicles" + (items ? ";@items" : "");
        TimeLoop.executeCommand(String.format("mocap settings recording track_entities %s", entitiesToTrack));
        TimeLoop.executeCommand(String.format("mocap settings playback play_entities %s", entitiesToTrack));
    }

    public static void updateInfoBar(int time, int timeLeft) {
        if (showLoopInfo && isLooping) {
            if (displayTimeInTicks) {
                loopBossBar.setBossBarName("Time Left: " + timeLeft);
            } else {
                loopBossBar.setBossBarName("Time Left: " + TimeLoop.convertTicksToTime(timeLeft));
            }
            loopBossBar.setBossBarPercentage(time, timeLeft);
        }
    }

    private static void removeOldSceneEntries() {
        if (isLooping && maxLoops > 1) {
            Path sceneDir = worldFolder.resolve("mocap_files").resolve("scenes");
            ArrayList sceneFiles = new ArrayList();
            loopSceneManager.forEachRecordingPlayer(playerData -> {
                String playerSceneName = loopSceneManager.getPlayerSceneName(playerData.getName());
                if (playerSceneName != null && !playerSceneName.isBlank()) {
                    sceneFiles.add(sceneDir.resolve(playerSceneName + ".mcmocap_scene"));
                } else {
                    LOOP_LOGGER.warn("Invalid playerSceneName encountered: {}", (Object)playerSceneName);
                }
            });
            if (sceneFiles.isEmpty()) {
                LOOP_LOGGER.warn("No scene files found to process.");
            }
            for (Path sceneFile : sceneFiles) {
                if (sceneFile.toFile().exists()) {
                    try {
                        JsonParser parser = new JsonParser();
                        String jsonContent = new String(Files.readAllBytes(sceneFile));
                        JsonObject jsonObject = parser.parse(jsonContent).getAsJsonObject();
                        JsonArray subScenes = jsonObject.getAsJsonArray("subscenes");
                        if (subScenes.size() <= maxLoops) continue;
                        int entriesToRemove = subScenes.size() - maxLoops;
                        JsonArray newSubScenes = new JsonArray();
                        for (int i = entriesToRemove; i < subScenes.size(); ++i) {
                            newSubScenes.add(subScenes.get(i));
                        }
                        jsonObject.add("subScenes", (JsonElement)newSubScenes);
                        Files.write(sceneFile, jsonObject.toString().getBytes(), new OpenOption[0]);
                        LOOP_LOGGER.info("Removed old scene entries for file: {}", (Object)sceneFile);
                    }
                    catch (IOException e) {
                        LOOP_LOGGER.error("Failed to process scene file: {}", (Object)sceneFile, (Object)e);
                    }
                    continue;
                }
                LOOP_LOGGER.error("Scene file does not exist: {}", (Object)sceneFile);
            }
        }
    }

    public static String convertTicksToTime(int ticksLeft) {
        int timeLeft = ticksLeft / 20;
        int hours = timeLeft / 3600;
        int minutes = timeLeft % 3600 / 60;
        int seconds = timeLeft % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public static class_2487 saveFullInventory(class_1657 player, class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        class_2499 main = new class_2499();
        for (Object stack : player.method_31548().field_7547) {
            main.add(stack.method_7960() ? new class_2487() : stack.method_57376(provider, (class_2520)new class_2487()));
        }
        tag.method_10566("main", (class_2520)main);
        class_2499 armor = new class_2499();
        for (class_1799 stack : player.method_31548().field_7548) {
            armor.add(stack.method_7960() ? new class_2487() : stack.method_57376(provider, (class_2520)new class_2487()));
        }
        tag.method_10566("armor", (class_2520)armor);
        class_2499 offhand = new class_2499();
        for (class_1799 stack : player.method_31548().field_7544) {
            offhand.add(stack.method_7960() ? new class_2487() : stack.method_57376(provider, (class_2520)new class_2487()));
        }
        tag.method_10566("offhand", (class_2520)offhand);
        return tag;
    }

    public static void loadFullInventory(class_1657 player, class_2487 tag, class_7225.class_7874 provider) {
        class_2499 main = tag.method_10554("main", 10);
        for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            class_2487 itemTag = i < main.size() ? main.method_10602(i) : new class_2487();
            player.method_31548().field_7547.set(i, (Object)(itemTag.method_33133() ? class_1799.field_8037 : class_1799.method_57359((class_7225.class_7874)provider, (class_2487)itemTag)));
        }
        class_2499 armor = tag.method_10554("armor", 10);
        for (int i = 0; i < player.method_31548().field_7548.size(); ++i) {
            class_2487 itemTag = i < armor.size() ? armor.method_10602(i) : new class_2487();
            player.method_31548().field_7548.set(i, (Object)(itemTag.method_33133() ? class_1799.field_8037 : class_1799.method_57359((class_7225.class_7874)provider, (class_2487)itemTag)));
        }
        class_2499 offhand = tag.method_10554("offhand", 10);
        for (int i = 0; i < player.method_31548().field_7544.size(); ++i) {
            class_2487 itemTag = i < offhand.size() ? offhand.method_10602(i) : new class_2487();
            player.method_31548().field_7544.set(i, (Object)(itemTag.method_33133() ? class_1799.field_8037 : class_1799.method_57359((class_7225.class_7874)provider, (class_2487)itemTag)));
        }
    }

    static {
        tickCounter = 0;
    }
}

