/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vltno.timeloop.LoopCommands;
import com.vltno.timeloop.LoopTypes;
import com.vltno.timeloop.TimeLoop;
import com.vltno.timeloop.TimeLoopConfig;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class BaseCommands {
    public static void register(LiteralArgumentBuilder<class_2168> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"start").executes(BaseCommands::start)).requires(source -> source.method_9259(2)));
        parentBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"skip").executes(BaseCommands::skip)).requires(source -> source.method_9259(2)));
        parentBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stop").executes(BaseCommands::stop)).requires(source -> source.method_9259(2)));
        parentBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").executes(BaseCommands::reset)).requires(source -> source.method_9259(2)));
        parentBuilder.then(class_2170.method_9247((String)"status").executes(BaseCommands::status));
    }

    private static int start(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!TimeLoop.isLooping) {
            if (TimeLoop.serverLevel == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Error: Server world not available yet."));
                return 0;
            }
            TimeLoop.config.startTimeOfDay = TimeLoop.startTimeOfDay = TimeLoop.serverLevel.method_8532();
            TimeLoop.startLoop();
            source.method_9226(() -> class_2561.method_43470((String)"Loop started!"), true);
            LoopCommands.LOOP_COMMANDS_LOGGER.info("Loop started");
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Loop already running!"));
        return 0;
    }

    private static int skip(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (TimeLoop.isLooping) {
            if (TimeLoop.serverLevel == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Error: Server world not available yet."));
                return 0;
            }
            TimeLoop.runLoopIteration();
            source.method_9226(() -> class_2561.method_43470((String)"Loop skipped!"), true);
            LoopCommands.LOOP_COMMANDS_LOGGER.info("Loop skipped");
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Loop not running"));
        return 0;
    }

    private static int stop(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (TimeLoop.isLooping) {
            TimeLoop.stopLoop();
            source.method_9226(() -> class_2561.method_43470((String)"Loop stopped"), true);
            LoopCommands.LOOP_COMMANDS_LOGGER.info("Loop stopped");
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Loop not running"));
        return 0;
    }

    private static int status(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String status = BaseCommands.getString();
        source.method_9226(() -> class_2561.method_43470((String)status), false);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Status requested: {}", (Object)status);
        return 1;
    }

    @NotNull
    private static String getString() {
        String loopTypeName = TimeLoop.loopType != null ? TimeLoop.loopType.name() : "UNKNOWN";
        String extras = " Looping on " + loopTypeName + "." + (String)(TimeLoop.isLooping && TimeLoop.loopType == LoopTypes.TICKS ? " Ticks Left: " + TimeLoop.ticksLeft : "") + (TimeLoop.trackItems ? " Tracking items." : "");
        return TimeLoop.isLooping ? "Loop is active. Current iteration: " + TimeLoop.loopIteration + extras : "Loop is inactive. Last iteration: " + TimeLoop.loopIteration + extras;
    }

    private static int reset(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        TimeLoop.stopLoop();
        TimeLoopConfig baseConfig = new TimeLoopConfig();
        TimeLoop.startTimeOfDay = baseConfig.startTimeOfDay;
        TimeLoop.config.startTimeOfDay = baseConfig.startTimeOfDay;
        TimeLoop.timeSetting = baseConfig.timeSetting;
        TimeLoop.config.timeSetting = baseConfig.timeSetting;
        TimeLoop.ticksLeft = TimeLoop.loopLengthTicks;
        TimeLoop.config.ticksLeft = TimeLoop.config.loopLengthTicks;
        TimeLoop.trackItems = baseConfig.trackItems;
        TimeLoop.config.trackItems = baseConfig.trackItems;
        TimeLoop.loopType = baseConfig.loopType;
        TimeLoop.config.loopType = baseConfig.loopType;
        TimeLoop.displayTimeInTicks = baseConfig.displayTimeInTicks;
        TimeLoop.config.displayTimeInTicks = baseConfig.displayTimeInTicks;
        TimeLoop.executeCommand("mocap playback stop_all");
        TimeLoop.loopSceneManager.forEachPlayerSceneName(playerSceneName -> {
            TimeLoop.executeCommand(String.format("mocap scenes remove %s", playerSceneName));
            TimeLoop.executeCommand(String.format("mocap scenes add %s", playerSceneName));
        });
        TimeLoop.loopIteration = 0;
        TimeLoop.config.loopIteration = 0;
        TimeLoop.config.save();
        source.method_9226(() -> class_2561.method_43470((String)"Loop reset!"), true);
        return 1;
    }
}

