/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.vltno.timeloop.LoopCommands;
import com.vltno.timeloop.LoopTypes;
import com.vltno.timeloop.RewindTypes;
import com.vltno.timeloop.TimeLoop;
import com.vltno.timeloop.commands.TogglesCommands;
import java.util.Arrays;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class SettingsCommands {
    public static void register(LiteralArgumentBuilder<class_2168> parentBuilder) {
        LiteralArgumentBuilder settingsNode = (LiteralArgumentBuilder)class_2170.method_9247((String)"settings").requires(source -> source.method_9259(2));
        settingsNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setLoopType").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Loop type is set to: " + String.valueOf((Object)TimeLoop.loopType))), false);
            return 1;
        })).then(class_2170.method_9244((String)"loopType", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9264(Arrays.stream(LoopTypes.values()).map(LoopTypes::method_15434), (SuggestionsBuilder)builder)).executes(SettingsCommands::setLoopType)));
        settingsNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setLength").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Loop length is set to: " + TimeLoop.config.loopLengthTicks + " ticks")), false);
            return 1;
        })).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)20)).executes(SettingsCommands::setLoopLength)));
        settingsNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"maxLoops").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Max loops is set to: " + TimeLoop.config.maxLoops)), false);
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(SettingsCommands::maxLoops)));
        settingsNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setTimeOfDay").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Time of day is set to: " + TimeLoop.config.timeSetting)), false);
            return 1;
        })).then(class_2170.method_9244((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0, (int)24000)).executes(SettingsCommands::setTimeOfDay)));
        settingsNode.then(class_2170.method_9247((String)"modifyPlayer").then(class_2170.method_9244((String)"targetPlayer", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"newName", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"newSkin", (ArgumentType)StringArgumentType.string()).executes(SettingsCommands::modifyPlayer)))));
        settingsNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setRewindType").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Rewind type is set to: " + String.valueOf((Object)TimeLoop.rewindType))), false);
            return 1;
        })).then(class_2170.method_9244((String)"rewindType", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9264(Arrays.stream(RewindTypes.values()).map(RewindTypes::method_15434), (SuggestionsBuilder)builder)).executes(SettingsCommands::setRewindType)));
        TogglesCommands.register((LiteralArgumentBuilder<class_2168>)settingsNode);
        parentBuilder.then((ArgumentBuilder)settingsNode);
    }

    private static int setLoopType(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String loopTypeStr = StringArgumentType.getString(context, (String)"loopType");
        try {
            LoopTypes newLoopType;
            TimeLoop.loopType = newLoopType = LoopTypes.valueOf(loopTypeStr.toUpperCase());
            TimeLoop.config.loopType = newLoopType;
            TimeLoop.config.save();
            if (TimeLoop.showLoopInfo && TimeLoop.loopBossBar != null) {
                TimeLoop.loopBossBar.visible(newLoopType.equals((Object)LoopTypes.TICKS) || newLoopType.equals((Object)LoopTypes.TIME_OF_DAY));
            }
            String extra = newLoopType == LoopTypes.MANUAL ? ". Use '/loop skip' to advance to the next iteration." : "";
            source.method_9226(() -> class_2561.method_43470((String)("Loop type is set to: " + String.valueOf((Object)newLoopType) + extra)), true);
            LoopCommands.LOOP_COMMANDS_LOGGER.info("Loop type set to {}", (Object)newLoopType);
            return 1;
        }
        catch (IllegalArgumentException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Invalid loop type: " + loopTypeStr)));
            return 0;
        }
    }

    private static int setLoopLength(CommandContext<class_2168> context) {
        int newTicks;
        class_2168 source = (class_2168)context.getSource();
        TimeLoop.loopLengthTicks = newTicks = IntegerArgumentType.getInteger(context, (String)"ticks");
        TimeLoop.config.loopLengthTicks = newTicks;
        TimeLoop.ticksLeft = newTicks;
        TimeLoop.config.ticksLeft = newTicks;
        TimeLoop.config.save();
        source.method_9226(() -> class_2561.method_43470((String)("Loop length is set to: " + newTicks + " ticks")), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Loop length set to {} ticks", (Object)newTicks);
        return 1;
    }

    private static int maxLoops(CommandContext<class_2168> context) {
        int maxLoops;
        class_2168 source = (class_2168)context.getSource();
        TimeLoop.maxLoops = maxLoops = IntegerArgumentType.getInteger(context, (String)"value");
        TimeLoop.config.maxLoops = maxLoops;
        TimeLoop.config.save();
        source.method_9226(() -> class_2561.method_43470((String)("Max loops is set to: " + maxLoops)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Max loops set to {}", (Object)maxLoops);
        return 1;
    }

    private static int setTimeOfDay(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        int newTime = IntegerArgumentType.getInteger(context, (String)"time");
        TimeLoop.timeSetting = newTime;
        TimeLoop.config.timeSetting = newTime;
        TimeLoop.config.save();
        source.method_9226(() -> class_2561.method_43470((String)("Time of day is set to: " + newTime)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Time of day set to {}", (Object)newTime);
        return 1;
    }

    private static int modifyPlayer(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String targetPlayer = StringArgumentType.getString(context, (String)"targetPlayer");
        String newName = StringArgumentType.getString(context, (String)"newName");
        String newSkin = StringArgumentType.getString(context, (String)"newSkin");
        TimeLoop.modifyPlayerAttributes(targetPlayer, newName, newSkin);
        source.method_9226(() -> class_2561.method_43470((String)("Attempted to modify player " + targetPlayer)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Attempted to modify player {} with name {} and skin {}", new Object[]{targetPlayer, newName, newSkin});
        return 1;
    }

    private static int setRewindType(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String rewindTypeStr = StringArgumentType.getString(context, (String)"rewindType");
        try {
            RewindTypes newRewindType;
            TimeLoop.rewindType = newRewindType = RewindTypes.valueOf(rewindTypeStr.toUpperCase());
            TimeLoop.config.rewindType = newRewindType;
            TimeLoop.config.save();
            source.method_9226(() -> class_2561.method_43470((String)("Rewinding position is set to: " + String.valueOf((Object)newRewindType))), true);
            LoopCommands.LOOP_COMMANDS_LOGGER.info("Rewind position set to {}", (Object)newRewindType);
            return 1;
        }
        catch (IllegalArgumentException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Invalid rewind type: " + rewindTypeStr)));
            return 0;
        }
    }
}

