/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop;

import com.vltno.timeloop.TimeLoop;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;

public class LoopBossBar {
    private final ServerBossEvent bossBar = new ServerBossEvent((Component)Component.literal((String)"TimeLoop"), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);

    public void visible(boolean bool) {
        this.bossBar.setVisible(bool);
    }

    public void setBossBarName(String bossBarName) {
        this.bossBar.setName((Component)Component.literal((String)bossBarName));
    }

    public void setBossBarPercentage(int whole, int part) {
        if (whole <= 0) {
            this.bossBar.setProgress(1.0f);
            return;
        }
        float progress = 1.0f - (float)part / (float)whole;
        this.bossBar.setProgress(Math.max(0.0f, Math.min(1.0f, progress)));
    }

    public void addPlayer(ServerPlayer player) {
        TimeLoop.LOOP_LOGGER.info("Adding player to boss bar: {}", (Object)player.getName().getString());
        this.bossBar.addPlayer(player);
    }

    public void removePlayer(ServerPlayer player) {
        TimeLoop.LOOP_LOGGER.info("Removing player from boss bar: {}", (Object)player.getName().getString());
        this.bossBar.removePlayer(player);
    }
}

