/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vltno.timeloop.LoopCommands;
import com.vltno.timeloop.LoopTypes;
import com.vltno.timeloop.TimeLoop;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TogglesCommands {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> settingsCommandBuilder) {
        LiteralArgumentBuilder togglesNode = Commands.literal((String)"toggles");
        togglesNode.then(((LiteralArgumentBuilder)Commands.literal((String)"trackTimeOfDay").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Track time of day is set to: " + TimeLoop.trackTimeOfDay)), false);
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::trackTimeOfDay)));
        togglesNode.then(((LiteralArgumentBuilder)Commands.literal((String)"trackItems").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Track items is set to: " + TimeLoop.trackItems)), false);
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::trackItems)));
        togglesNode.then(((LiteralArgumentBuilder)Commands.literal((String)"trackInventory").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Track inventory is set to: " + TimeLoop.trackInventory)), false);
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::trackInventory)));
        togglesNode.then(((LiteralArgumentBuilder)Commands.literal((String)"displayTimeInTicks").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Display time in ticks is set to: " + TimeLoop.displayTimeInTicks)), false);
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::displayTimeInTicks)));
        togglesNode.then(((LiteralArgumentBuilder)Commands.literal((String)"showLoopInfo").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Show loop info is set to: " + TimeLoop.showLoopInfo)), false);
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::showLoopInfo)));
        togglesNode.then(((LiteralArgumentBuilder)Commands.literal((String)"trackChat").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Track chat is set to: " + TimeLoop.trackChat)), false);
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::trackChat)));
        togglesNode.then(((LiteralArgumentBuilder)Commands.literal((String)"hurtLoopedPlayers").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Hurt looped players is set to: " + TimeLoop.hurtLoopedPlayers)), false);
            return 1;
        })).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(TogglesCommands::hurtLoopedPlayers)));
        settingsCommandBuilder.then((ArgumentBuilder)togglesNode);
    }

    private static int trackTimeOfDay(CommandContext<CommandSourceStack> context) {
        boolean newTrackTimeOfDay;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TimeLoop.trackTimeOfDay = newTrackTimeOfDay = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.trackTimeOfDay = newTrackTimeOfDay;
        TimeLoop.config.save();
        source.sendSuccess(() -> Component.literal((String)("Track time of day is set to: " + newTrackTimeOfDay)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Track time of day set to {}", (Object)newTrackTimeOfDay);
        return 1;
    }

    private static int trackItems(CommandContext<CommandSourceStack> context) {
        boolean newTrackItems;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TimeLoop.trackItems = newTrackItems = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.trackItems = newTrackItems;
        TimeLoop.config.save();
        TimeLoop.updateEntitiesToTrack(newTrackItems);
        source.sendSuccess(() -> Component.literal((String)("Track items is set to: " + newTrackItems)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Track items set to {}", (Object)newTrackItems);
        return 1;
    }

    private static int trackInventory(CommandContext<CommandSourceStack> context) {
        boolean newTrackInventory;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TimeLoop.trackInventory = newTrackInventory = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.trackInventory = newTrackInventory;
        TimeLoop.config.save();
        TimeLoop.loopSceneManager.forEachRecordingPlayer(playerData -> {
            String playerName = playerData.getName();
            ServerPlayer player = TimeLoop.server.getPlayerList().getPlayerByName(playerName);
            RegistryAccess.Frozen provider = TimeLoop.server.registryAccess();
            CompoundTag invTag = TimeLoop.saveFullInventory((Player)player, (HolderLookup.Provider)provider);
            playerData.setInventoryTag(invTag);
        });
        source.sendSuccess(() -> Component.literal((String)("Track inventory is set to: " + newTrackInventory)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Track inventory set to {}", (Object)newTrackInventory);
        return 1;
    }

    private static int displayTimeInTicks(CommandContext<CommandSourceStack> context) {
        boolean newDisplayTimeInTicks;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TimeLoop.displayTimeInTicks = newDisplayTimeInTicks = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.displayTimeInTicks = newDisplayTimeInTicks;
        TimeLoop.config.save();
        source.sendSuccess(() -> Component.literal((String)("Display time in ticks is set to: " + newDisplayTimeInTicks)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Display time in ticks set to {}", (Object)newDisplayTimeInTicks);
        return 1;
    }

    private static int showLoopInfo(CommandContext<CommandSourceStack> context) {
        boolean newShowLoopInfo;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TimeLoop.showLoopInfo = newShowLoopInfo = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.showLoopInfo = newShowLoopInfo;
        TimeLoop.config.save();
        if (TimeLoop.loopBossBar != null) {
            if (newShowLoopInfo) {
                TimeLoop.loopBossBar.visible(TimeLoop.loopType != null && (TimeLoop.loopType.equals((Object)LoopTypes.TICKS) || TimeLoop.loopType.equals((Object)LoopTypes.TIME_OF_DAY)));
            } else {
                TimeLoop.loopBossBar.visible(false);
            }
        }
        source.sendSuccess(() -> Component.literal((String)("Show loop info is set to: " + newShowLoopInfo)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Show loop info set to {}", (Object)newShowLoopInfo);
        return 1;
    }

    private static int trackChat(CommandContext<CommandSourceStack> context) {
        boolean newTrackChat;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TimeLoop.trackChat = newTrackChat = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.trackChat = newTrackChat;
        TimeLoop.config.save();
        TimeLoop.executeCommand("mocap settings recording chat_recording " + newTrackChat);
        source.sendSuccess(() -> Component.literal((String)("Track chat is set to: " + newTrackChat)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Track chat set to {}", (Object)newTrackChat);
        return 1;
    }

    private static int hurtLoopedPlayers(CommandContext<CommandSourceStack> context) {
        boolean newHurtLoopedPlayers;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TimeLoop.hurtLoopedPlayers = newHurtLoopedPlayers = BoolArgumentType.getBool(context, (String)"value");
        TimeLoop.config.hurtLoopedPlayers = newHurtLoopedPlayers;
        TimeLoop.config.save();
        TimeLoop.executeCommand("mocap settings playback invulnerable_playback " + !newHurtLoopedPlayers);
        source.sendSuccess(() -> Component.literal((String)("Hurt looped players is set to: " + newHurtLoopedPlayers)), true);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Hurt looped players set to {}", (Object)newHurtLoopedPlayers);
        return 1;
    }
}

