/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop.events;

import com.vltno.timeloop.LoopTypes;
import com.vltno.timeloop.TimeLoop;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;

public class PlayConnectionEvent {
    public static void onJoin(ServerGamePacketListenerImpl handler, MinecraftServer server) {
        ServerPlayer player = handler.player;
        String playerName = player.getName().getString();
        RegistryAccess.Frozen provider = server.registryAccess();
        TimeLoop.loopSceneManager.addPlayer(Arrays.asList(playerName, null, null, player.position().toString(), new CompoundTag().toString()));
        CompoundTag invTag = TimeLoop.saveFullInventory((Player)player, (HolderLookup.Provider)provider);
        TimeLoop.loopSceneManager.getRecordingPlayer(playerName).setInventoryTag(invTag);
        if (TimeLoop.loopBossBar != null) {
            TimeLoop.loopBossBar.addPlayer(player);
        }
        TimeLoop.executeCommand(String.format("mocap scenes add %s", TimeLoop.loopSceneManager.getPlayerSceneName(playerName)));
        if (TimeLoop.config != null && TimeLoop.config.firstStart) {
            TimeLoop.config.firstStart = false;
            TimeLoop.config.save();
            TimeLoop.LOOP_LOGGER.info("First start detected, sending message to op(s).");
            MutableComponent modrinthLink = Component.literal((String)"https://modrinth.com/mod/timeloop").withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://modrinth.com/mod/timeloop")).withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)));
            MutableComponent discordLink = Component.literal((String)"https://discord.gg/nzDETZhqur").withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/nzDETZhqur")).withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)));
            if (server.getPlayerList().isOp(player.getGameProfile())) {
                player.sendSystemMessage((Component)Component.literal((String)"Use '/loop start' to start the time loop!"));
                player.sendSystemMessage((Component)Component.literal((String)"Settings: '/loop settings'"));
                player.sendSystemMessage((Component)Component.literal((String)"Toggles: '/loop settings toggles'"));
                player.sendSystemMessage((Component)Component.literal((String)"Information: ").append((Component)modrinthLink));
                player.sendSystemMessage((Component)Component.literal((String)"Help: ").append((Component)discordLink));
            }
        }
        if (TimeLoop.isLooping) {
            TimeLoop.LOOP_LOGGER.info("Starting recording for newly joined player: {}", (Object)playerName);
            TimeLoop.executeCommand(String.format("mocap recording start %s", playerName));
            if (TimeLoop.showLoopInfo && TimeLoop.loopBossBar != null) {
                boolean shouldBeVisible = TimeLoop.loopType != null && (TimeLoop.loopType.equals((Object)LoopTypes.TICKS) || TimeLoop.loopType.equals((Object)LoopTypes.TIME_OF_DAY));
                TimeLoop.loopBossBar.visible(shouldBeVisible);
            }
        }
    }

    public static void onDisconnect(ServerGamePacketListenerImpl handler) {
        ServerPlayer player = handler.player;
        String playerName = player.getName().getString();
        TimeLoop.loopSceneManager.removePlayer(playerName);
        if (TimeLoop.loopBossBar != null) {
            TimeLoop.loopBossBar.removePlayer(player);
        }
        if (TimeLoop.isLooping) {
            TimeLoop.saveRecordings();
            TimeLoop.loopSceneManager.saveRecordingPlayers();
        }
    }
}

