/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop;

import com.vltno.timeloop.TimeLoop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.phys.Vec3;

public class PlayerData {
    private final String name;
    private String nickname;
    private String skin;
    private Vec3 startPosition;
    private Vec3 joinPosition;
    private String inventoryTag;

    public PlayerData(String name, String nickname, String skin, Vec3 joinPosition, CompoundTag inventoryTag) {
        this.name = name;
        this.nickname = nickname;
        this.skin = skin;
        this.startPosition = null;
        this.joinPosition = joinPosition;
        this.setInventoryTag(inventoryTag);
    }

    public String getName() {
        return this.name;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public Vec3 getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(Vec3 newStartPosition) {
        this.startPosition = newStartPosition;
    }

    public Vec3 getJoinPosition() {
        return this.joinPosition;
    }

    public void setJoinPosition(Vec3 newJoinPosition) {
        this.joinPosition = newJoinPosition;
    }

    public void setInventoryTag(CompoundTag inventoryTag) {
        this.inventoryTag = inventoryTag.getAsString();
    }

    public CompoundTag getInventoryTag() {
        if (this.inventoryTag == null || this.inventoryTag.isEmpty()) {
            return new CompoundTag();
        }
        try {
            CompoundTag tag = TagParser.parseTag((String)this.inventoryTag);
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = tag;
                return compoundTag;
            }
        }
        catch (Exception e) {
            TimeLoop.LOOP_LOGGER.error("Failed to parse inventoryTagNbt: " + this.inventoryTag, (Throwable)e);
        }
        return new CompoundTag();
    }

    public String toString() {
        return "PlayerData{name='" + this.name + "', nickname='" + this.nickname + "', skin='" + this.skin + "', join-position='" + String.valueOf(this.joinPosition) + "', start-position='" + String.valueOf(this.startPosition) + "', inventory-tag='" + this.inventoryTag + "'}";
    }
}

