/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.textualizer.minecraft;

import cpw.mods.modlauncher.Launcher;
import dev.deftu.omnicore.common.OmniLoader;
import dev.deftu.textualizer.minecraft.LanguageMetadata;
import dev.deftu.textualizer.minecraft.MCLanguage;
import dev.deftu.textualizer.minecraft.MCLocalization;
import dev.deftu.textualizer.minecraft.ResourcePackHelper;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ+\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020 0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0011\u0010%\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001b\u0010)\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010\u000bR\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0018\u0010\r\u001a\u0004\u0018\u00010\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010-\u00a8\u0006."}, d2={"Ldev/deftu/textualizer/minecraft/MCResourceManager;", "Lnet/minecraft/server/packs/resources/ResourceManagerReloadListener;", "<init>", "()V", "", "initialize", "", "code", "Ldev/deftu/textualizer/minecraft/MCLanguage;", "get", "(Ljava/lang/String;)Ldev/deftu/textualizer/minecraft/MCLanguage;", "()Ldev/deftu/textualizer/minecraft/MCLanguage;", "Lnet/minecraft/server/packs/resources/ResourceManager;", "resourceManager", "onResourceManagerReload", "(Lnet/minecraft/server/packs/resources/ResourceManager;)V", "", "load", "(Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/lang/String;)Ljava/util/Map;", "path", "loadPath", "(Ljava/lang/String;)Ljava/util/Map;", "Ljava/io/InputStream;", "getResource", "(Ljava/lang/String;)Ljava/io/InputStream;", "DEFAULT", "Ljava/lang/String;", "Ljava/lang/ClassLoader;", "getModLauncherClassLoader", "()Ljava/lang/ClassLoader;", "modLauncherClassLoader", "", "Ldev/deftu/textualizer/minecraft/LanguageMetadata;", "allMetadata", "Ljava/util/Map;", "getCurrentLanguageCode", "()Ljava/lang/String;", "currentLanguageCode", "defaultLanguage$delegate", "Lkotlin/Lazy;", "getDefaultLanguage", "defaultLanguage", "", "isInitialized", "Z", "Lnet/minecraft/server/packs/resources/ResourceManager;", "Textualizer"})
@SourceDebugExtension(value={"SMAP\nMCResourceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MCResourceManager.kt\ndev/deftu/textualizer/minecraft/MCResourceManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1557#2:165\n1628#2,3:166\n*S KotlinDebug\n*F\n+ 1 MCResourceManager.kt\ndev/deftu/textualizer/minecraft/MCResourceManager\n*L\n129#1:165\n129#1:166,3\n*E\n"})
public final class MCResourceManager
implements ResourceManagerReloadListener {
    @NotNull
    public static final MCResourceManager INSTANCE = new MCResourceManager();
    @NotNull
    private static final String DEFAULT = "en_us";
    @NotNull
    private static final Map<String, LanguageMetadata> allMetadata = new LinkedHashMap();
    @NotNull
    private static final Lazy defaultLanguage$delegate = LazyKt.lazy(MCResourceManager::defaultLanguage_delegate$lambda$0);
    private static boolean isInitialized;
    @Nullable
    private static ResourceManager resourceManager;

    private MCResourceManager() {
    }

    private final ClassLoader getModLauncherClassLoader() {
        Launcher launcher = Launcher.INSTANCE;
        Field field = launcher.getClass().getDeclaredField("classLoader");
        field.setAccessible(true);
        Object object = field.get(launcher);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.ClassLoader");
        return (ClassLoader)object;
    }

    @NotNull
    public final String getCurrentLanguageCode() {
        String string = Minecraft.m_91087_().m_91102_().m_118983_().getCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCode(...)");
        String string2 = string;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return string3;
    }

    @NotNull
    public final MCLanguage getDefaultLanguage() {
        Lazy lazy = defaultLanguage$delegate;
        return (MCLanguage)lazy.getValue();
    }

    public final void initialize() {
        if (isInitialized) {
            return;
        }
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        if (resourceManager == null) {
            return;
        }
        ResourceManager resourceManager2 = resourceManager;
        if (resourceManager2 instanceof ReloadableResourceManager) {
            isInitialized = true;
            ((ReloadableResourceManager)resourceManager2).m_7217_((PreparableReloadListener)this);
            this.m_6213_(resourceManager2);
        }
    }

    @NotNull
    public final MCLanguage get(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.initialize();
        ResourceManager resourceManager = MCResourceManager.resourceManager;
        if (resourceManager == null) {
            throw new IllegalStateException("Resource manager is not set");
        }
        ResourceManager resourceManager2 = resourceManager;
        Object[] objectArray = new String[]{DEFAULT};
        Set loaded = SetsKt.mutableSetOf((Object[])objectArray);
        LanguageMetadata metadata = allMetadata.get(DEFAULT);
        boolean isRightToLeft = false;
        if (!loaded.contains(this.getCurrentLanguageCode())) {
            metadata = allMetadata.get(this.getCurrentLanguageCode());
            if (metadata != null) {
                isRightToLeft = metadata.isRightToLeft();
            }
            loaded.add(this.getCurrentLanguageCode());
        }
        if (metadata == null) {
            throw new IllegalStateException("Language metadata not found");
        }
        Map<String, String> translations = this.load(resourceManager2, code);
        System.out.println((Object)("Loaded translations for " + code + ": " + translations));
        return new MCLanguage(this.getDefaultLanguage(), code, metadata.getRegion(), isRightToLeft, code, translations);
    }

    @NotNull
    public final MCLanguage get() {
        return this.get(this.getCurrentLanguageCode());
    }

    public void m_6213_(@NotNull ResourceManager resourceManager) {
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        MCResourceManager.resourceManager = resourceManager;
        allMetadata.clear();
        allMetadata.putAll(ResourcePackHelper.loadFromResourcePacks(ResourcePackHelper.getResourcePacks(resourceManager)));
        MCLocalization.INSTANCE.refresh();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> load(ResourceManager resourceManager, String code) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        StringBuilder stringBuilder;
        Map loaded = new LinkedHashMap();
        StringBuilder $this$load_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Object object = new String[]{"_"};
        List split = StringsKt.split$default((CharSequence)code, (String[])object, (boolean)false, (int)0, (int)6, null);
        object = (String)split.get(0);
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        $this$load_u24lambda_u241.append(string);
        if (split.size() > 1) {
            $this$load_u24lambda_u241.append("_");
            object = (String)split.get(1);
            Locale locale2 = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ENGLISH");
            String string2 = ((String)object).toUpperCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            $this$load_u24lambda_u241.append(string2);
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String formattedCode = string3;
        Set checkedPaths = new LinkedHashSet();
        String path = "languages/" + formattedCode + ".json";
        Set set = resourceManager.m_7187_();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getNamespaces(...)");
        object = OmniLoader.getLoadedMods();
        Set set2 = set;
        boolean $i$f$map = false;
        void var10_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            OmniLoader.ModInfo modInfo = (OmniLoader.ModInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$load$stub_for_inlining = false;
            boolean bl2 = false;
            collection.add(p0.getId());
        }
        Set namespaces = SetsKt.plus((Set)set2, (Iterable)((List)destination$iv$iv));
        for (String namespace : namespaces) {
            String fullPath = "/assets/" + namespace + "/" + path;
            if (checkedPaths.contains(fullPath)) continue;
            try {
                loaded.putAll(this.loadPath(fullPath));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return loaded;
    }

    private final Map<String, String> loadPath(String path) {
        InputStream inputStream = this.getResource(path);
        if (inputStream == null) {
            return MapsKt.emptyMap();
        }
        InputStream inputStream2 = inputStream;
        Map loaded = new LinkedHashMap();
        MCLanguage.Companion.load(inputStream2, (String p0, String p1) -> loaded.put(p0, p1));
        inputStream2.close();
        return loaded;
    }

    private final InputStream getResource(String path) {
        System.out.println(this.getModLauncherClassLoader());
        return this.getModLauncherClassLoader().getResourceAsStream(path);
    }

    private static final MCLanguage defaultLanguage_delegate$lambda$0() {
        ResourceManager resourceManager = MCResourceManager.resourceManager;
        if (resourceManager == null) {
            throw new IllegalStateException("Resource manager is not set");
        }
        ResourceManager resourceManager2 = resourceManager;
        Map<String, String> translations = INSTANCE.load(resourceManager2, DEFAULT);
        return new MCLanguage(null, DEFAULT, "US", false, "English (US)", translations);
    }
}

