/*
 * Decompiled with CFR 0.152.
 */
package dev.deftu.textualizer.minecraft;

import dev.deftu.textualizer.minecraft.LanguageMetadata;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.metadata.language.LanguageMetadataSection;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a)\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0007\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/minecraft/server/packs/resources/ResourceManager;", "resourceManager", "", "Lnet/minecraft/server/packs/PackResources;", "getResourcePacks", "(Lnet/minecraft/server/packs/resources/ResourceManager;)Ljava/util/Collection;", "packs", "", "", "Ldev/deftu/textualizer/minecraft/LanguageMetadata;", "loadFromResourcePacks", "(Ljava/util/Collection;)Ljava/util/Map;", "Lnet/minecraft/client/resources/language/LanguageInfo;", "definition", "loadFromLanguageDefinition", "(Lnet/minecraft/client/resources/language/LanguageInfo;)Ldev/deftu/textualizer/minecraft/LanguageMetadata;", "Textualizer"})
@JvmName(name="ResourcePackHelper")
public final class ResourcePackHelper {
    @ApiStatus.Internal
    @NotNull
    public static final Collection<PackResources> getResourcePacks(@NotNull ResourceManager resourceManager) {
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        List list = resourceManager.listPacks().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Map<String, LanguageMetadata> loadFromResourcePacks(@NotNull Collection<? extends PackResources> packs) {
        Intrinsics.checkNotNullParameter(packs, (String)"packs");
        Map result = new LinkedHashMap();
        for (PackResources packResources : packs) {
            LanguageMetadataSection metadata;
            if ((LanguageMetadataSection)packResources.getMetadataSection((MetadataSectionSerializer)LanguageMetadataSection.TYPE) == null) continue;
            Map map = metadata.languages();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"languages(...)");
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                LanguageInfo value = (LanguageInfo)entry.getValue();
                Intrinsics.checkNotNull((Object)value);
                result.put(key, ResourcePackHelper.loadFromLanguageDefinition(value));
            }
        }
        return result;
    }

    @ApiStatus.Internal
    @NotNull
    public static final LanguageMetadata loadFromLanguageDefinition(@NotNull LanguageInfo definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        String string = definition.region();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"region(...)");
        String string2 = string;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String string4 = definition.name();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name(...)");
        string2 = string4;
        Locale locale2 = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"US");
        String string5 = string2.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        return new LanguageMetadata(string3, string5, definition.bidirectional());
    }
}

