/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.common.ai.PlaceWreathTask;
import net.mehvahdjukaar.snowyspirit.common.network.ClientBoundSyncWreathMessage;
import net.mehvahdjukaar.snowyspirit.common.wreath.WreathSavedData;
import net.mehvahdjukaar.snowyspirit.reg.ModMemoryModules;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class RemoveWreathTask
extends Behavior<Villager> {
    private final float speedModifier;
    private int ticksSinceReached = 0;
    private int cooldown = 100;
    protected int lastBreakProgress = -1;

    public RemoveWreathTask(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryStatus.VALUE_ABSENT, ModMemoryModules.WREATH_POS.get(), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 270, 350);
        this.speedModifier = speed * 1.1f;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (SnowySpirit.isChristmasSeason((Level)pLevel)) {
            return false;
        }
        if (this.cooldown-- > 0) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((Level)pLevel, (Entity)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        GlobalPos globalpos = (GlobalPos)pOwner.getBrain().getMemory(ModMemoryModules.WREATH_POS.get()).get();
        return globalpos.dimension() == pLevel.dimension() && !pOwner.isBaby();
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 20 * (5 + pLevel.random.nextInt(20)) + pLevel.random.nextInt(20);
        this.ticksSinceReached = 0;
        this.lastBreakProgress = -1;
        GlobalPos globalpos = (GlobalPos)pEntity.getBrain().getMemory(ModMemoryModules.WREATH_POS.get()).get();
        pEntity.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        pEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(globalpos.pos(), this.speedModifier, 1));
        PlaceWreathTask.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.SHEARS));
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.stop(pLevel, (LivingEntity)pEntity, pGameTime);
        PlaceWreathTask.clearHeldItem(pEntity);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return pEntity.getBrain().hasMemoryValue(ModMemoryModules.WREATH_POS.get());
    }

    protected void tick(ServerLevel level, Villager pOwner, long pGameTime) {
        BlockPos pos = ((GlobalPos)pOwner.getBrain().getMemory(ModMemoryModules.WREATH_POS.get()).get()).pos();
        pOwner.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        pOwner.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(pos, this.speedModifier, 2));
        pOwner.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(pos));
        if (pos.closerToCenterThan((Position)pOwner.position(), 2.3)) {
            ++this.ticksSinceReached;
            BlockState state = level.getBlockState(pos);
            if (state.getBlock() instanceof DoorBlock) {
                boolean lower = state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER;
                WreathSavedData c = WreathSavedData.get((Level)level);
                BlockPos blockPos = pos = lower ? pos.above() : pos;
                if (c != null && c.hasWreath(pos)) {
                    int k = (int)((float)this.ticksSinceReached / 10.0f * 10.0f);
                    if (k != this.lastBreakProgress) {
                        level.destroyBlockProgress(pOwner.getId(), pos, k);
                        this.lastBreakProgress = k;
                    }
                    if (this.ticksSinceReached > 10) {
                        pOwner.getBrain().eraseMemory(ModMemoryModules.WREATH_POS.get());
                        c.removeWreath(pos, (Level)level, true);
                        NetworkHelper.sendToAllClientPlayers((CustomPacketPayload)new ClientBoundSyncWreathMessage(pos, false));
                    }
                    return;
                }
            }
            pOwner.getBrain().eraseMemory(ModMemoryModules.WREATH_POS.get());
        }
    }
}

