/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.block;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.IColored;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.snowyspirit.PlatStuff;
import net.mehvahdjukaar.snowyspirit.common.block.GlowLightsBlockTile;
import net.mehvahdjukaar.snowyspirit.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GlowLightsBlock
extends WaterBlock
implements EntityBlock,
IColored {
    public final DyeColor color;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    private static final Map<Direction, BooleanProperty> DIR_MAP = (Map)Util.make(() -> {
        EnumMap<Direction, BooleanProperty> m = new EnumMap<Direction, BooleanProperty>(Direction.class);
        m.put(Direction.UP, UP);
        m.put(Direction.DOWN, DOWN);
        m.put(Direction.WEST, WEST);
        m.put(Direction.SOUTH, SOUTH);
        m.put(Direction.EAST, EAST);
        m.put(Direction.NORTH, NORTH);
        return m;
    });

    public GlowLightsBlock(DyeColor color) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).lightLevel(s -> 6));
        this.color = color;
    }

    public static boolean hasSide(BlockState state, Direction direction) {
        if (direction == null) {
            return true;
        }
        return (Boolean)state.getValue((Property)DIR_MAP.get(direction));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{UP});
        builder.add(new Property[]{DOWN});
        builder.add(new Property[]{EAST});
        builder.add(new Property[]{WEST});
        builder.add(new Property[]{SOUTH});
        builder.add(new Property[]{NORTH});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return (BlockState)super.updateShape(state, direction, neighborState, level, currentPos, neighborPos).setValue((Property)DIR_MAP.get(direction), (Comparable)Boolean.valueOf(!Block.isFaceFull((VoxelShape)neighborState.getCollisionShape((BlockGetter)level, neighborPos), (Direction)direction.getOpposite())));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        for (Map.Entry<Direction, BooleanProperty> e : DIR_MAP.entrySet()) {
            Direction d = e.getKey();
            BlockPos p = pos.relative(d);
            state = (BlockState)state.setValue((Property)e.getValue(), (Comparable)Boolean.valueOf(!Block.isFaceFull((VoxelShape)level.getBlockState(p).getCollisionShape((BlockGetter)level, p), (Direction)d.getOpposite())));
        }
        return state;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public boolean supportsBlankColor() {
        return true;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        Object object = builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof GlowLightsBlockTile) {
            GlowLightsBlockTile tile = (GlowLightsBlockTile)((Object)object);
            BlockState heldState = tile.getHeldBlock();
            Object object2 = builder.getParameter(LootContextParams.THIS_ENTITY);
            if (object2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)object2;
                if (!ForgeHelper.canHarvestBlock((BlockState)heldState, (ServerLevel)builder.getLevel(), (BlockPos)BlockPos.containing((Position)((Position)builder.getParameter(LootContextParams.ORIGIN))), (ServerPlayer)player)) {
                    return drops;
                }
            }
            List newDrops = heldState.getDrops(builder);
            drops.addAll(newDrops);
        }
        return drops;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new GlowLightsBlockTile(pPos, pState);
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.empty();
    }

    public int getLightBlock(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!pLevel.isRainingAt(pPos.above()) || pRandom.nextInt(15) != 1 || (blockstate = pLevel.getBlockState(blockpos = pPos.below())).canOcclude() && blockstate.isFaceSturdy((BlockGetter)pLevel, blockpos, Direction.UP))) {
            double d0 = (double)pPos.getX() + pRandom.nextDouble();
            double d1 = (double)pPos.getY() - 0.05;
            double d2 = (double)pPos.getZ() + pRandom.nextDouble();
            pLevel.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, d0, d1, d2, 0.0, 0.0, 0.0);
        }
        this.spawnParticlesOnBlockFaces(pLevel, pState, pPos, (ParticleOptions)ModRegistry.GLOW_LIGHT_PARTICLE.get(), pRandom, this.color);
    }

    public void spawnParticlesOnBlockFaces(Level level, BlockState state, BlockPos pos, ParticleOptions particleOptions, RandomSource randomSource, DyeColor color) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        for (Direction direction : Direction.values()) {
            if (!(randomSource.nextFloat() < 0.15f) || !GlowLightsBlock.hasSide(state, direction)) continue;
            int i = direction.getStepX();
            int j = direction.getStepY();
            int k = direction.getStepZ();
            double d0 = vec3.x + (i == 0 ? Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5) : (double)i * 0.6);
            double d1 = vec3.y + (j == 0 ? Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5) : (double)j * 0.6);
            double d2 = vec3.z + (k == 0 ? Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5) : (double)k * 0.6);
            float[] c = ClientDynamicResourcesHandler.getGlowLightColor(color, randomSource);
            level.addParticle(particleOptions, d0, d1, d2, (double)c[0], (double)c[1], (double)c[2]);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player pPlayer, InteractionHand pHand, BlockHitResult hitResult) {
        if (PlatStuff.isShear(stack)) {
            List<ItemStack> drops = this.shearAction(pPlayer, stack, level, pos);
            level.playSound(pPlayer, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            drops.forEach(d -> {
                ItemEntity ent = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, d);
                ent.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)ent);
                RandomSource r = level.random;
                ent.setDeltaMovement(ent.getDeltaMovement().add((double)((r.nextFloat() - r.nextFloat()) * 0.1f), (double)(r.nextFloat() * 0.05f), (double)((r.nextFloat() - r.nextFloat()) * 0.1f)));
            });
            stack.hurtAndBreak(1, (LivingEntity)pPlayer, pHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, pPlayer, pHand, hitResult);
    }

    private List<ItemStack> shearAction(@Nullable Player player, ItemStack item, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof GlowLightsBlockTile) {
            GlowLightsBlockTile tile = (GlowLightsBlockTile)blockEntity;
            if (!world.isClientSide()) {
                world.setBlockAndUpdate(pos, tile.getHeldBlock());
                return Collections.singletonList(ModRegistry.GLOW_LIGHTS_ITEMS.get(this.color).get().getDefaultInstance());
            }
        }
        return Collections.emptyList();
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return ModRegistry.GLOW_LIGHTS_ITEMS.get(this.color).get().getDefaultInstance();
    }
}

