/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.block;

import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SnowGlobeBlock
extends WaterBlock {
    public static final BooleanProperty SNOWING = BlockStateProperties.SNOWY;
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);

    public SnowGlobeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SNOWING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean snowy = this.canBeSnowy(context.getClickedPos(), context.getLevel());
        return (BlockState)super.getStateForPlacement(context).setValue((Property)SNOWING, (Comparable)Boolean.valueOf(snowy));
    }

    private boolean canBeSnowy(BlockPos pos, Level level) {
        return ((Biome)level.getBiome(pos).value()).coldEnoughToSnow(pos);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player player, BlockHitResult hitResult) {
        if (((Boolean)pState.getValue((Property)SNOWING)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)SNOWING, (Comparable)Boolean.valueOf(true)), 3);
        pLevel.scheduleTick(pPos, (Block)this, 50);
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        if (((Boolean)pState.getValue((Property)SNOWING)).booleanValue() && !this.canBeSnowy(pPos, (Level)pLevel)) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)SNOWING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Boolean)state.getValue((Property)SNOWING) != false ? 15 : 0;
    }
}

