/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.entity;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.mehvahdjukaar.snowyspirit.common.block.GumdropButton;
import net.mehvahdjukaar.snowyspirit.common.entity.GingyEntity;
import net.mehvahdjukaar.snowyspirit.common.entity.MongoEntity;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.mehvahdjukaar.snowyspirit.reg.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GolemHelper {
    public static final Supplier<BlockPattern> MONGO_PATTERN = Suppliers.memoize(() -> BlockPatternBuilder.start().aisle(new String[]{"~~~###~~~", "~~~###~~~", "~~~###~~~", "#########", "#########", "~~~###~~~", "~~~###~~~", "~~~###~~~", "~~~###~~~", "~~~###~~~", "~~~###~~~"}).where('~', BlockInWorld.hasState(BlockBehaviour.BlockStateBase::canBeReplaced)).where('#', BlockInWorld.hasState(s -> s.is(ModTags.GINGERBREADS))).build());

    public static void trySpawningGingy(BlockState pumpkinState, LevelAccessor level, BlockPos pumpkinPos, @Nullable Entity entity) {
        BlockPos below = pumpkinPos.below();
        if (level instanceof ServerLevel) {
            Direction dir;
            BlockPos button;
            BlockState state;
            Block block;
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.getBlockState(below).is(ModTags.GINGERBREADS) && (block = (state = level.getBlockState(button = below.relative(dir = (Direction)pumpkinState.getValue((Property)CarvedPumpkinBlock.FACING)))).getBlock()) instanceof GumdropButton) {
                GingyEntity golem;
                GumdropButton b = (GumdropButton)block;
                if (state.getValue((Property)GumdropButton.FACING) == dir && (golem = (GingyEntity)ModRegistry.GINGERBREAD_GOLEM.get().create((Level)serverLevel)) != null) {
                    level.removeBlock(pumpkinPos, false);
                    level.removeBlock(button, false);
                    level.removeBlock(below, false);
                    golem.moveTo((double)pumpkinPos.getX() + 0.5, (double)pumpkinPos.getY() + 0.05 - 1.0, (double)pumpkinPos.getZ() + 0.5, dir.toYRot(), 0.0f);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, (Entity)golem);
                        golem.setOwnerUUID(serverPlayer.getUUID());
                        golem.setPersistenceRequired();
                    }
                    golem.setColor(b.color);
                    golem.setYHeadRot(dir.toYRot());
                    level.addFreshEntity((Entity)golem);
                }
            }
        }
    }

    public static void trySpawningMongo(BlockState buttonState, Level level, BlockPos buttonPos, @Nullable Entity entity) {
        MongoEntity giant;
        BlockPattern.BlockPatternMatch patternMatch;
        BlockPos behind = buttonPos.relative(((Direction)buttonState.getValue((Property)GumdropButton.FACING)).getOpposite());
        if (level.getBlockState(behind).is(ModTags.GINGERBREADS) && (patternMatch = MONGO_PATTERN.get().find((LevelReader)level, behind)) != null && (giant = (MongoEntity)ModRegistry.GINGERBREAD_GIANT.get().create(level)) != null) {
            giant.setColor(((GumdropButton)buttonState.getBlock()).color);
            GolemHelper.clearBlocks(level, patternMatch);
            BlockPos bottom = patternMatch.getBlock(patternMatch.getWidth() / 2, patternMatch.getHeight(), 0).getPos();
            giant.moveTo((double)bottom.getX() + 0.5, (double)bottom.getY() + 0.05, (double)bottom.getZ() + 0.5, 0.0f, 0.0f);
            level.addFreshEntity((Entity)giant);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, (Entity)giant);
            }
        }
    }

    private static void clearBlocks(Level level, BlockPattern.BlockPatternMatch patternMatch) {
        Direction front = patternMatch.getForwards();
        for (int i = 0; i < patternMatch.getWidth(); ++i) {
            for (int j = 0; j < patternMatch.getHeight(); ++j) {
                BlockInWorld blockInWorld = patternMatch.getBlock(i, j, 0);
                if (!blockInWorld.getState().is(ModTags.GINGERBREADS)) continue;
                BlockPos inFront = blockInWorld.getPos().relative(front);
                BlockState gum = level.getBlockState(inFront);
                if (gum.getBlock() instanceof GumdropButton) {
                    level.setBlock(inFront, Blocks.AIR.defaultBlockState(), 2);
                    level.levelEvent(2001, inFront, Block.getId((BlockState)gum));
                }
                level.setBlock(blockInWorld.getPos(), Blocks.AIR.defaultBlockState(), 2);
                level.levelEvent(2001, blockInWorld.getPos(), Block.getId((BlockState)blockInWorld.getState()));
            }
        }
    }
}

