/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.entity;

import java.util.Iterator;
import net.mehvahdjukaar.snowyspirit.common.entity.GingyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MongoEntity
extends GingyEntity
implements PlayerRideableJumping {
    public MongoEntity(EntityType<? extends AbstractGolem> entityType, Level level) {
        super(entityType, level);
    }

    public boolean canJump() {
        return true;
    }

    public void handleStartJump(int jumpPower) {
    }

    public void handleStopJump() {
    }

    public void onPlayerJump(int jumpPower) {
        float f = 0.01f;
        double d = (double)jumpPower * (double)this.getBlockJumpFactor() * (double)f;
        double e = d + (double)this.getJumpBoostPower();
        Vec3 vec32 = this.getDeltaMovement();
        this.setDeltaMovement(vec32.x, e, vec32.z);
        this.hasImpulse = true;
        float g = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
        float h = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
        this.setDeltaMovement(this.getDeltaMovement().add((double)(-0.4f * g * f), 0.0, (double)(0.4f * h * f)));
    }

    public boolean isPushable() {
        return !this.isVehicle();
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity le;
        Entity v = this.getFirstPassenger();
        return v instanceof LivingEntity ? (le = (LivingEntity)v) : null;
    }

    protected Vec3 getRiddenInput(Player player, Vec3 vec3) {
        float f = player.xxa * 0.5f;
        float f1 = player.zza;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    protected void tickRidden(Player player, Vec3 vec3) {
        super.tickRidden(player, vec3);
        this.setYRot(player.getYRot());
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
    }

    protected float getRiddenSpeed(Player player) {
        return 0.1f;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        if (this.level().isClientSide) {
            float scale = 10.0f;
            float period = 7.853982f * scale;
            float limbSwingAmount = 0.0f;
            float walkAnim = 0.0f;
            if (this.isAlive()) {
                limbSwingAmount = this.walkAnimation.speed(partialTick);
                walkAnim = this.walkAnimation.position(partialTick);
                float maxLimbSwing = 1.0f;
                if (limbSwingAmount > maxLimbSwing) {
                    limbSwingAmount = maxLimbSwing;
                }
            }
            Vec3 v = new Vec3(0.0, 6.5, 0.0);
            float angle = walkAnim * ((float)Math.PI * 2 / period);
            float sideSwayPower = 20.0f / scale;
            float cos = Mth.cos((float)angle);
            float walkCycleClamped = cos * Mth.clamp((float)limbSwingAmount, (float)0.0f, (float)0.4f);
            v = v.zRot((float)Math.PI / 180 * (cos * sideSwayPower * limbSwingAmount));
            Vec3 hv = new Vec3(0.0, 4.5, 0.5);
            hv = hv.zRot(walkCycleClamped * 0.3f);
            v = v.add(hv);
            v = v.yRot(-this.getYRot() * ((float)Math.PI / 180));
            return new Vec3(v.x, v.y + 0.25, v.z);
        }
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTick);
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive() && this.horizontalCollision && this.isControlledByLocalInstance()) {
            boolean bl = false;
            AABB aABB = this.getBoundingBox().inflate(1.0);
            Iterator var8 = BlockPos.betweenClosed((int)Mth.floor((double)aABB.minX), (int)Mth.floor((double)aABB.minY), (int)Mth.floor((double)aABB.minZ), (int)Mth.floor((double)aABB.maxX), (int)Mth.floor((double)aABB.maxY), (int)Mth.floor((double)aABB.maxZ)).iterator();
            while (true) {
                if (!var8.hasNext()) {
                    if (bl || !this.onGround()) break;
                    this.jumpFromGround();
                    break;
                }
                BlockPos blockPos = (BlockPos)var8.next();
                BlockState blockState = this.level().getBlockState(blockPos);
                Block block = blockState.getBlock();
                if (!(block instanceof LeavesBlock)) continue;
                bl = this.level().destroyBlock(blockPos, true, (Entity)this) || bl;
            }
        }
    }

    public int getMaxHeadXRot() {
        return 0;
    }

    public static AttributeSupplier.Builder createGiantAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.STEP_HEIGHT, 2.0).add(Attributes.MOVEMENT_SPEED, 0.5);
    }
}

