/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.wreath;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.snowyspirit.common.wreath.WreathSavedData;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ClientEvents {
    private static final boolean FORGE = PlatHelper.getPlatform().isForge();

    public static void tickEvent() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            WreathSavedData.get((Level)level).refreshClientBlocksVisuals((Level)level);
        }
    }

    public static void renderWreaths(PoseStack poseStack) {
        Minecraft mc = Minecraft.getInstance();
        Level level = mc.player.level();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        WreathSavedData wreathData = WreathSavedData.get(level);
        if (wreathData != null) {
            float dist = mc.gameRenderer.getRenderDistance();
            dist *= dist;
            poseStack.pushPose();
            if (FORGE) {
                poseStack.mulPose(new Quaternionf((Quaternionfc)camera.rotation()).invert());
            }
            MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
            RenderSystem.enableDepthTest();
            for (Map.Entry<BlockPos, WreathSavedData.Data> entry : wreathData.getWreathBlocks().entrySet()) {
                BlockPos pos = entry.getKey();
                if (!(mc.player.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < (double)dist)) continue;
                poseStack.pushPose();
                poseStack.translate((double)pos.getX() - cameraPos.x(), (double)pos.getY() - cameraPos.y(), (double)pos.getZ() - cameraPos.z());
                WreathSavedData.Data data = entry.getValue();
                Direction dir = data.getDirection();
                BlockState state = ModRegistry.WREATH.get().defaultBlockState();
                BlockRenderDispatcher blockRenderer = mc.getBlockRenderer();
                poseStack.translate(0.5, 0.5, 0.5);
                Pair<Float, Float> dim = data.getDimensions();
                if (dim != null) {
                    poseStack.pushPose();
                    poseStack.mulPose(Axis.YP.rotationDegrees(-dir.toYRot()));
                    poseStack.translate(-0.5, -0.5, -0.5 + (double)((Float)dim.getSecond()).floatValue());
                    RenderUtil.renderBlock((long)0L, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (BlockState)state, (Level)level, (BlockPos)pos, (BlockRenderDispatcher)blockRenderer);
                    poseStack.popPose();
                    poseStack.pushPose();
                    poseStack.mulPose(Axis.YP.rotationDegrees(-dir.getOpposite().toYRot()));
                    poseStack.translate(-0.5, -0.5, -0.5 + (double)((Float)dim.getFirst()).floatValue());
                    RenderUtil.renderBlock((long)0L, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (BlockState)state, (Level)level, (BlockPos)pos, (BlockRenderDispatcher)blockRenderer);
                    poseStack.popPose();
                }
                poseStack.popPose();
            }
            RenderSystem.disableDepthTest();
            bufferSource.endBatch();
            poseStack.popPose();
        }
    }
}

