/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.firstmodremake.entity;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.mcreator.firstmodremake.entity.RailerEntity;
import net.mcreator.firstmodremake.init.FirstModRemakeModEntities;
import net.mcreator.firstmodremake.init.FirstModRemakeModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class AmethystinePhantomEntity
extends Monster {
    public AmethystinePhantomEntity(EntityType<AmethystinePhantomEntity> type, Level world) {
        super(type, world);
        this.xpReward = 14;
        this.setNoAi(false);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.getNavigation().getNodeEvaluator().setCanOpenDoors(true);
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 3.0, 20){

            protected Vec3 getPosition() {
                RandomSource random = AmethystinePhantomEntity.this.getRandom();
                double dir_x = AmethystinePhantomEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = AmethystinePhantomEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = AmethystinePhantomEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 6.0, (Predicate)Ingredient.of((ItemLike)((ItemLike)FirstModRemakeModItems.AMETHYSTINE_INGOT.get())), false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 5.0, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 289.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                return AmethystinePhantomEntity.this.getTarget() != null && !AmethystinePhantomEntity.this.getMoveControl().hasWanted();
            }

            public boolean canContinueToUse() {
                return AmethystinePhantomEntity.this.getMoveControl().hasWanted() && AmethystinePhantomEntity.this.getTarget() != null && AmethystinePhantomEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = AmethystinePhantomEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                AmethystinePhantomEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 5.0);
            }

            public void tick() {
                LivingEntity livingentity = AmethystinePhantomEntity.this.getTarget();
                if (AmethystinePhantomEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    AmethystinePhantomEntity.this.doHurtTarget(3.getServerLevel((Entity)livingentity), (Entity)livingentity);
                } else {
                    double d0 = AmethystinePhantomEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 40.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        AmethystinePhantomEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 5.0);
                    }
                }
            }
        });
        this.goalSelector.addGoal(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, RailerEntity.class, 10.0f, 10.0, 2.0));
        this.goalSelector.addGoal(9, (Goal)new RemoveBlockGoal(Blocks.OAK_PLANKS, (PathfinderMob)this, 4.0, 10));
        this.targetSelector.addGoal(10, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(11, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(13, (Goal)new FloatGoal((Mob)this));
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, (double)-0.35f, 0.0);
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)FirstModRemakeModItems.AMETHYSTINE_INGOT.get()));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.phantom.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.phantom.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.phantom.death"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)FirstModRemakeModEntities.AMETHYSTINE_PHANTOM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (EntitySpawnReason)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.6);
        builder = builder.add(Attributes.MAX_HEALTH, 22.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 25.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 24.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.FLYING_SPEED, 0.6);
        builder = builder.add(Attributes.TEMPT_RANGE, 10.0);
        return builder;
    }
}

