/*
 * Decompiled with CFR 0.152.
 */
package gg.meza.doobs.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import gg.meza.doobs.DeckedOutOBS;
import gg.meza.doobs.data.CardQueue;
import gg.meza.doobs.data.CardQueueManager;
import gg.meza.doobs.server.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2561;

public class BasicHttpServer {
    private final CardQueueManager cardQueueManager;
    private HttpServer server;
    private final Map<String, Session> sessions = new HashMap<String, Session>();
    private int lastPort = 0;

    public BasicHttpServer(CardQueueManager cardQueueManager) {
        this.cardQueueManager = cardQueueManager;
        DeckedOutOBS.scheduler.scheduleWithFixedDelay(this::cleanUpSessions, 0L, 15L, TimeUnit.SECONDS);
    }

    public void startServer(int port) {
        if (this.server != null && port != this.lastPort) {
            DeckedOutOBS.LOGGER.info(class_2561.method_43469((String)"decked-out-obs.system.changing_ports", (Object[])new Object[]{this.lastPort, port}).getString());
            this.server.stop(0);
        }
        if (this.server != null && port == this.lastPort) {
            DeckedOutOBS.LOGGER.info(class_2561.method_43469((String)"decked-out-obs.system.same_port", (Object[])new Object[]{port}).getString());
            return;
        }
        try {
            this.lastPort = port;
            this.server = HttpServer.create(new InetSocketAddress(port), 0);
            this.server.createContext("/", this::handleIndex);
            this.server.createContext("/favicon.png", this::handleFavicon);
            this.server.createContext("/assets", this::handleAssets);
            this.server.createContext("/nextCard", this::handleNextCard);
            this.server.start();
            DeckedOutOBS.LOGGER.info(class_2561.method_43469((String)"decked-out-obs.message.server_started", (Object[])new Object[]{port}).getString());
        }
        catch (IOException var1) {
            throw new RuntimeException(var1);
        }
    }

    public void stopServer() {
        this.server.stop(0);
        this.server = null;
        DeckedOutOBS.LOGGER.info(class_2561.method_43471((String)"decked-out-obs.message.server_stopped").getString());
    }

    public static boolean isPortAvailable(int port) {
        boolean bl;
        ServerSocket ignored = new ServerSocket(port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }

    private void handleIndex(HttpExchange exchange) throws IOException {
        Session currentSession = this.getSession(exchange);
        String response = this.readFile("/assets/decked-out-obs/web/index.html").replace("X-Session", currentSession.getSessionId());
        exchange.getResponseHeaders().set("Content-Type", "text/html");
        exchange.sendResponseHeaders(200, response.getBytes(StandardCharsets.UTF_8).length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(response.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void handleFavicon(HttpExchange exchange) throws IOException {
        String filePath = "/assets/decked-out-obs/icon.png";
        this.sendAsset(exchange, filePath);
    }

    private void handleAssets(HttpExchange exchange) throws IOException {
        String filePath = exchange.getRequestURI().getPath().replaceFirst("/assets", "/assets/decked-out-obs/web/assets");
        this.sendAsset(exchange, filePath);
    }

    private void sendAsset(HttpExchange exchange, String filePath) throws IOException {
        block20: {
            try (InputStream is = this.getClass().getResourceAsStream(filePath);){
                if (is == null) {
                    String response = "File not found";
                    exchange.sendResponseHeaders(404, response.getBytes().length);
                    try (OutputStream os = exchange.getResponseBody();){
                        os.write(response.getBytes());
                        break block20;
                    }
                }
                exchange.getResponseHeaders().set("Content-Type", this.getMimeType(filePath));
                exchange.sendResponseHeaders(200, 0L);
                try (OutputStream os = exchange.getResponseBody();){
                    int count;
                    byte[] buffer = new byte[1024];
                    while ((count = is.read(buffer)) != -1) {
                        os.write(buffer, 0, count);
                    }
                }
            }
        }
    }

    private void handleNextCard(HttpExchange exchange) throws IOException {
        Object response;
        Session session = this.getSession(exchange);
        CardQueue queue = this.cardQueueManager.getQueueForSession(session);
        String nextQueueItem = queue.nextCard();
        if (nextQueueItem == null) {
            response = "{\"card\": \"\", \"hasCard\": false}";
        } else {
            response = "{\"card\": \"" + nextQueueItem + "\", \"hasCard\": true}";
            DeckedOutOBS.LOGGER.debug("Sending card {} to session {}", (Object)nextQueueItem, (Object)session.getSessionId());
        }
        exchange.getResponseHeaders().set("Content-Type", "application/json");
        exchange.sendResponseHeaders(200, ((String)response).getBytes(StandardCharsets.UTF_8).length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(((String)response).getBytes(StandardCharsets.UTF_8));
        }
    }

    private String readFile(String path) {
        StringBuilder contentBuilder = new StringBuilder();
        try (InputStream is = this.getClass().getResourceAsStream(path);
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String str;
            while ((str = br.readLine()) != null) {
                contentBuilder.append(str);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentBuilder.toString();
    }

    private String getMimeType(String path) {
        String mimeType = "application/octet-stream";
        if (path.endsWith(".html")) {
            mimeType = "text/html";
        } else if (path.endsWith(".js")) {
            mimeType = "application/javascript";
        } else if (path.endsWith(".css")) {
            mimeType = "text/css";
        } else if (path.endsWith(".png")) {
            mimeType = "image/png";
        } else if (path.endsWith(".jpg") || path.endsWith(".jpeg")) {
            mimeType = "image/jpeg";
        }
        return mimeType;
    }

    private Session getSession(HttpExchange exchange) {
        String sessionId = this.getSessionIdFromExchange(exchange);
        Session session = this.sessions.get(sessionId);
        if (session == null) {
            session = new Session(sessionId);
            DeckedOutOBS.LOGGER.debug("Created new session {}", (Object)sessionId);
            this.sessions.put(sessionId, session);
            this.cardQueueManager.addQueueForSession(session);
        }
        session.updateLastAccessed();
        return session;
    }

    private String getSessionIdFromExchange(HttpExchange exchange) {
        Object sessionIds = exchange.getRequestHeaders().get("X-Session");
        return sessionIds != null && !sessionIds.isEmpty() ? (String)sessionIds.get(0) : UUID.randomUUID().toString();
    }

    private void cleanUpSessions() {
        this.sessions.entrySet().removeIf(entry -> {
            Session session = (Session)entry.getValue();
            if (session.isExpired()) {
                this.cardQueueManager.removeQueueForSession(session);
                return true;
            }
            return false;
        });
    }
}

