/*
 * Decompiled with CFR 0.152.
 */
package gg.meza.doobs.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import gg.meza.doobs.DeckedOutOBS;
import gg.meza.doobs.data.Location;
import gg.meza.doobs.data.Worlds;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.apache.commons.lang3.SerializationException;

public class Settings {
    private final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("decked_out.json");
    private String currentWorld = "";
    private Worlds configData = new Worlds();

    public Settings(String world) {
        this.currentWorld = world;
        this.initConfig();
    }

    public void initConfig() {
        if (this.configPath.toFile().exists()) {
            try {
                BufferedReader reader = Files.newBufferedReader(this.configPath);
                Gson gson = new Gson();
                this.configData = (Worlds)gson.fromJson((Reader)reader, Worlds.class);
                reader.close();
            }
            catch (JsonParseException | IOException e) {
                DeckedOutOBS.LOGGER.error("Cause: " + e.getCause().getClass().getSimpleName());
                throw new SerializationException(e);
            }
        }
    }

    public void setDungeonPosition(class_2338 pos, class_2350 direction) {
        if (this.configData.dungeons.containsKey(this.currentWorld)) {
            this.configData.dungeons.replace(this.currentWorld, new Location(direction, pos));
        } else {
            this.configData.dungeons.put(this.currentWorld, new Location(direction, pos));
        }
        this.saveConfig();
    }

    public boolean isDungeonSet() {
        return this.configData.dungeons.containsKey(this.currentWorld);
    }

    public Location getDungeonPosition() {
        if (!this.isDungeonSet()) {
            throw new RuntimeException("Dungeon not set");
        }
        return this.configData.dungeons.get(this.currentWorld);
    }

    public int getPort() {
        return this.configData.port;
    }

    public void setPort(int port) {
        this.configData.port = port;
        this.saveConfig();
    }

    public void saveConfig() {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);
            gson.toJson((Object)this.configData, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }
}

