/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.essentiapipes.api;

import dev.rndmorris.essentiapipes.api.IIOPipeSegment;
import dev.rndmorris.essentiapipes.api.WorldCoordinate;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConnectionInfo
implements Comparable<ConnectionInfo>,
Comparator<ConnectionInfo> {
    @Nonnull
    private final WorldCoordinate coordinate;
    private final int distance;

    public ConnectionInfo(@Nonnull WorldCoordinate coordinate, int distance) {
        this.coordinate = coordinate;
        this.distance = distance;
    }

    @Override
    public int compareTo(@Nonnull ConnectionInfo that) {
        return this.compare(this, that);
    }

    @Override
    public int compare(ConnectionInfo thiz, ConnectionInfo that) {
        int compare = Integer.compare(thiz.distance, that.distance);
        if (compare != 0) {
            return compare;
        }
        return thiz.coordinate.compareTo(that.coordinate);
    }

    @Nullable
    public IIOPipeSegment getIOSegment() {
        return this.coordinate.getTileEntity(IIOPipeSegment.class);
    }

    public String toString() {
        return "ConnectionInfo[" + "coordinate=" + this.coordinate + "," + "distance=" + this.distance + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.coordinate != null ? this.coordinate.hashCode() : 0);
        result = 31 * result + this.distance;
        return result;
    }

    @Override
    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((ConnectionInfo)arg0).coordinate, this.coordinate)) {
            return false;
        }
        return ((ConnectionInfo)arg0).distance == this.distance;
        {
        }
    }

    @Nonnull
    public WorldCoordinate coordinate() {
        return this.coordinate;
    }

    public int distance() {
        return this.distance;
    }
}

