/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.essentiapipes.api;

import dev.rndmorris.essentiapipes.api.WorldCoordinate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;

public class EssentiaRequest {
    public static final String ASPECT = "aspect";
    public static final String DISTANCE = "distance";
    public static final String SUCTION = "suction";
    public static final String DESTINATION = "destination";
    public static final String DESTINATION_FACE = "destinationFace";
    public Aspect aspect;
    public int distance = Integer.MAX_VALUE;
    public int suction;
    public WorldCoordinate destination;
    public ForgeDirection destinationFace;

    public EssentiaRequest(NBTTagCompound nbtTagCompound) {
        this.readFromNBT(nbtTagCompound);
    }

    public EssentiaRequest(WorldCoordinate destination, ForgeDirection destinationFace, Aspect aspect, int suction) {
        this.aspect = aspect;
        this.destination = destination;
        this.destinationFace = destinationFace;
        this.suction = suction;
    }

    public int effectiveSuction() {
        return Integer.max(0, this.suction - this.distance);
    }

    public boolean isSuperceededBy(EssentiaRequest request) {
        int effectiveSuctionDiff = request.effectiveSuction() - this.effectiveSuction();
        if (effectiveSuctionDiff == 0) {
            return request.distance < this.distance;
        }
        return effectiveSuctionDiff > 0;
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        if (this.aspect != null) {
            nbtTagCompound.func_74778_a(ASPECT, this.aspect.getTag());
        }
        nbtTagCompound.func_74768_a(DISTANCE, this.distance);
        nbtTagCompound.func_74768_a(SUCTION, this.suction);
        nbtTagCompound.func_74783_a(DESTINATION, new int[]{this.destination.dimensionId(), this.destination.x(), this.destination.y(), this.destination.z()});
        nbtTagCompound.func_74768_a(DESTINATION_FACE, this.destinationFace.ordinal());
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b(ASPECT)) {
            String aspectTag = nbtTagCompound.func_74779_i(ASPECT);
            this.aspect = Aspect.getAspect((String)aspectTag);
        }
        this.distance = nbtTagCompound.func_74762_e(DISTANCE);
        this.suction = nbtTagCompound.func_74762_e(SUCTION);
        int[] destArr = nbtTagCompound.func_74759_k(DESTINATION);
        this.destination = new WorldCoordinate(0, 0, 0, 0);
        if (destArr.length >= 4) {
            this.destination = new WorldCoordinate(destArr[0], destArr[1], destArr[2], destArr[3]);
        }
        int faceInt = nbtTagCompound.func_74762_e(DESTINATION_FACE);
        this.destinationFace = ForgeDirection.getOrientation((int)faceInt);
    }
}

