/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.essentiapipes.api;

import javax.annotation.Nonnull;

public enum PipeColor {
    NONE(0),
    YELLOW(1),
    RED(2),
    BLUE(3),
    GREEN(4),
    WHITE(5),
    BLACK(6),
    PURPLE(7);

    public final byte id;
    public static final PipeColor[] COLORS;

    private PipeColor(byte id) {
        this.id = id;
    }

    public static PipeColor fromId(int id) {
        if (0 <= id && id < COLORS.length) {
            return COLORS[id];
        }
        return null;
    }

    public boolean willConnectTo(@Nonnull PipeColor color) {
        return this == NONE || color == NONE || this == color;
    }

    public PipeColor nextColor() {
        return this.id + 1 >= COLORS.length ? COLORS[0] : COLORS[this.id + 1];
    }

    public PipeColor prevColor() {
        return this.id - 1 < 0 ? COLORS[COLORS.length - 1] : COLORS[this.id - 1];
    }

    static {
        COLORS = new PipeColor[]{NONE, YELLOW, RED, BLUE, GREEN, WHITE, BLACK, PURPLE};
    }
}

