/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.essentiapipes.api;

import dev.rndmorris.essentiapipes.api.ConnectionInfo;
import dev.rndmorris.essentiapipes.api.IIOPipeSegment;
import dev.rndmorris.essentiapipes.api.IPipeSegment;
import dev.rndmorris.essentiapipes.api.WorldCoordinate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.IEssentiaTransport;

public class PipeHelper {
    public static boolean canConnect(IBlockAccess world, int x, int y, int z, ForgeDirection direction) {
        Block hereBlock = world.func_147439_a(x, y, z);
        if (!(hereBlock instanceof IPipeSegment)) {
            return false;
        }
        IPipeSegment herePipe = (IPipeSegment)hereBlock;
        if (herePipe.canConnectTo(world, x, y, z, direction)) {
            return true;
        }
        int dX = x + direction.offsetX;
        int dY = y + direction.offsetY;
        int dZ = z + direction.offsetZ;
        Block thereBlock = world.func_147439_a(dX, dY, dZ);
        if (!(thereBlock instanceof IPipeSegment)) {
            return false;
        }
        IPipeSegment therePipe = (IPipeSegment)thereBlock;
        return therePipe.canConnectTo(world, dX, dY, dZ, direction.getOpposite());
    }

    public static boolean canConnectVisually(IBlockAccess world, int x, int y, int z, ForgeDirection direction) {
        Block hereBlock = world.func_147439_a(x, y, z);
        if (!(hereBlock instanceof IPipeSegment)) {
            return false;
        }
        IPipeSegment herePipe = (IPipeSegment)hereBlock;
        if (herePipe.canConnectTo(world, x, y, z, direction)) {
            return true;
        }
        int dX = x + direction.offsetX;
        int dY = y + direction.offsetY;
        int dZ = z + direction.offsetZ;
        Block thereBlock = world.func_147439_a(dX, dY, dZ);
        if (thereBlock instanceof IPipeSegment) {
            IPipeSegment therePipe = (IPipeSegment)thereBlock;
            return therePipe.canConnectTo(world, dX, dY, dZ, direction.getOpposite());
        }
        TileEntity thereTile = world.func_147438_o(dX, dY, dZ);
        if (thereTile instanceof IEssentiaTransport) {
            IEssentiaTransport transport = (IEssentiaTransport)thereTile;
            return transport.isConnectable(direction.getOpposite());
        }
        return false;
    }

    public static void notifySegmentAddedOrChanged(World world, int x, int y, int z) {
        Collection<ConnectionInfo> toUpdate = PipeHelper.findIOPipeSegments(SearchType.DepthFirst, new WorldCoordinate(world.field_73011_w.field_76574_g, x, y, z));
        PipeHelper.updateIOSegments(toUpdate);
    }

    public static void notifySegmentRemoved(World world, int x, int y, int z) {
        Collection<ConnectionInfo> found = PipeHelper.findIOPipeSegments(SearchType.DepthFirst, WorldCoordinate.adjacent(world.field_73011_w.field_76574_g, x, y, z));
        PipeHelper.updateIOSegments(found);
    }

    private static void updateIOSegments(Collection<ConnectionInfo> toUpdate) {
        for (ConnectionInfo result : toUpdate) {
            IIOPipeSegment ioSegment = result.getIOSegment();
            if (ioSegment == null) continue;
            ioSegment.rebuildIOConnections();
        }
    }

    public static Collection<ConnectionInfo> findIOPipeSegments(SearchType searchType, WorldCoordinate ... initialPositions) {
        HashMap<WorldCoordinate, Integer> resultMap = new HashMap<WorldCoordinate, Integer>();
        for (WorldCoordinate p : initialPositions) {
            World world = p.getWorld();
            if (world == null) continue;
            ArrayDeque<NavigationEntry> queue = new ArrayDeque<NavigationEntry>();
            HashSet<WorldCoordinate> visited = new HashSet<WorldCoordinate>();
            queue.add(new NavigationEntry(p, 0));
            while (!queue.isEmpty()) {
                NavigationEntry navigationEntry;
                switch (searchType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BreadthFirst: {
                        navigationEntry = (NavigationEntry)queue.pollFirst();
                        break;
                    }
                    case DepthFirst: {
                        navigationEntry = (NavigationEntry)queue.pollLast();
                    }
                }
                NavigationEntry current = navigationEntry;
                WorldCoordinate here = current.coordinate;
                visited.add(here);
                int distance = current.distance;
                World hereWorld = here.getWorld();
                if (hereWorld == null) continue;
                IIOPipeSegment ioSegment = here.getTileEntity(IIOPipeSegment.class);
                if (!(ioSegment == null || resultMap.containsKey(here) && (Integer)resultMap.get(here) <= distance)) {
                    resultMap.put(here, distance);
                }
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    WorldCoordinate there = here.shift(dir);
                    if (visited.contains(here.shift(dir)) || !PipeHelper.canConnect((IBlockAccess)hereWorld, here.x(), here.y(), here.z(), dir)) continue;
                    queue.push(new NavigationEntry(there, distance + 1));
                }
            }
        }
        ArrayList<ConnectionInfo> result = new ArrayList<ConnectionInfo>(resultMap.size());
        for (Map.Entry entry : resultMap.entrySet()) {
            result.add(new ConnectionInfo((WorldCoordinate)entry.getKey(), (Integer)entry.getValue()));
        }
        return result;
    }

    public static enum SearchType {
        BreadthFirst,
        DepthFirst;

    }

    private static final class NavigationEntry {
        private final WorldCoordinate coordinate;
        private final int distance;

        private NavigationEntry(WorldCoordinate coordinate, int distance) {
            this.coordinate = coordinate;
            this.distance = distance;
        }

        public String toString() {
            return "NavigationEntry[" + "coordinate=" + this.coordinate + "," + "distance=" + this.distance + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.coordinate != null ? this.coordinate.hashCode() : 0);
            result = 31 * result + this.distance;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((NavigationEntry)arg0).coordinate, this.coordinate)) {
                return false;
            }
            return ((NavigationEntry)arg0).distance == this.distance;
            {
            }
        }

        public WorldCoordinate coordinate() {
            return this.coordinate;
        }

        public int distance() {
            return this.distance;
        }
    }
}

