/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.essentiapipes.api;

import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public final class WorldCoordinate
implements Comparable<WorldCoordinate>,
Comparator<WorldCoordinate> {
    private final int dimensionId;
    private final int x;
    private final int y;
    private final int z;

    public WorldCoordinate(int dimensionId, int x, int y, int z) {
        this.dimensionId = dimensionId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static WorldCoordinate[] adjacent(int dimensionId, int x, int y, int z) {
        WorldCoordinate[] result = new WorldCoordinate[ForgeDirection.VALID_DIRECTIONS.length];
        for (int index = 0; index < ForgeDirection.VALID_DIRECTIONS.length; ++index) {
            result[index] = WorldCoordinate.shift(dimensionId, x, y, z, ForgeDirection.VALID_DIRECTIONS[index]);
        }
        return result;
    }

    public static WorldCoordinate fromTileEntity(@Nullable Object object) {
        if (!(object instanceof TileEntity)) {
            return null;
        }
        TileEntity tileEntity = (TileEntity)object;
        return new WorldCoordinate(tileEntity.func_145831_w().field_73011_w.field_76574_g, tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public Block getBlock() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public <T> T getBlock(Class<T> clazz) {
        Block block = this.getBlock();
        if (block != null && clazz.isAssignableFrom(block.getClass())) {
            return (T)block;
        }
        return null;
    }

    public int getBlockMetadata() {
        World world = this.getWorld();
        if (world == null) {
            return -1;
        }
        return world.func_72805_g(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity() {
        World world = this.getWorld();
        if (world == null) {
            return null;
        }
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public <T> T getTileEntity(Class<T> clazz) {
        TileEntity entity = this.getTileEntity();
        if (entity != null && clazz.isAssignableFrom(entity.getClass())) {
            return (T)entity;
        }
        return null;
    }

    public World getWorld() {
        if (DimensionManager.isDimensionRegistered((int)this.dimensionId)) {
            return DimensionManager.getWorld((int)this.dimensionId);
        }
        return null;
    }

    public static WorldCoordinate shift(int dimensionId, int x, int y, int z, ForgeDirection direction) {
        return new WorldCoordinate(dimensionId, x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ);
    }

    public WorldCoordinate shift(ForgeDirection direction) {
        return WorldCoordinate.shift(this.dimensionId, this.x, this.y, this.z, direction);
    }

    @Override
    public int compareTo(@Nonnull WorldCoordinate that) {
        return this.compare(this, that);
    }

    @Override
    public int compare(@Nonnull WorldCoordinate thiz, @Nonnull WorldCoordinate that) {
        int compare = Integer.compare(thiz.x, that.x);
        if (compare != 0) {
            return compare;
        }
        compare = Integer.compare(thiz.y, that.y);
        if (compare != 0) {
            return compare;
        }
        compare = Integer.compare(thiz.z, that.z);
        if (compare != 0) {
            return compare;
        }
        return Integer.compare(thiz.dimensionId, that.dimensionId);
    }

    public String toString() {
        return "WorldCoordinate[" + "dimensionId=" + this.dimensionId + "," + "x=" + this.x + "," + "y=" + this.y + "," + "z=" + this.z + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.dimensionId;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    @Override
    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (((WorldCoordinate)arg0).dimensionId != this.dimensionId) {
            return false;
        }
        if (((WorldCoordinate)arg0).x != this.x) {
            return false;
        }
        if (((WorldCoordinate)arg0).y != this.y) {
            return false;
        }
        return ((WorldCoordinate)arg0).z == this.z;
        {
        }
    }

    public int dimensionId() {
        return this.dimensionId;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }
}

