/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.essentiapipes.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dev.rndmorris.essentiapipes.Config;
import dev.rndmorris.essentiapipes.EssentiaPipes;
import dev.rndmorris.essentiapipes.api.IIOPipeSegment;
import dev.rndmorris.essentiapipes.api.IPipeSegment;
import dev.rndmorris.essentiapipes.api.PipeColor;
import dev.rndmorris.essentiapipes.api.PipeHelper;
import dev.rndmorris.essentiapipes.items.ItemBlockPipeSegment;
import dev.rndmorris.essentiapipes.tile.TileEntityIOPipeSegment;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.wands.IWandable;
import thaumcraft.codechicken.lib.raytracer.IndexedCuboid6;
import thaumcraft.codechicken.lib.raytracer.RayTracer;
import thaumcraft.codechicken.lib.vec.BlockCoord;
import thaumcraft.codechicken.lib.vec.Cuboid6;
import thaumcraft.codechicken.lib.vec.Vector3;

public class BlockPipeSegment
extends Block
implements IPipeSegment,
ITileEntityProvider,
IWandable {
    public static final String ID = "pipe_segment";
    public static final String ID_THAUMIUM = "pipe_segment_thaumium";
    public static final String ID_VOIDMETAL = "pipe_segment_voidmetal";
    public static BlockPipeSegment pipe_segment;
    public static BlockPipeSegment pipe_segment_thaumium;
    public static BlockPipeSegment pipe_segment_voidmetal;
    public static int renderId;
    public static final byte IS_IO_SEGMENT = 8;
    public static final float PIXEL = 0.0625f;
    public static final float BOUND_MIN = 0.40625f;
    public static final float BOUND_MAX = 0.59375f;
    public static final float BOUND_MIN_VALVE = 0.375f;
    public static final float BOUND_MAX_VALVE = 0.625f;
    private final String id;
    public final IIcon[] icons = new IIcon[PipeColor.COLORS.length];
    public final IIcon[] valveIcon = new IIcon[1];
    private final RayTracer rayTracer = new RayTracer();

    public static void preInit() {
        if (Config.pipeEnabledBasic) {
            pipe_segment = BlockPipeSegment.register(new BlockPipeSegment(ID), ID);
        }
        if (Config.pipeEnabledThaumium) {
            pipe_segment_thaumium = BlockPipeSegment.register(new BlockPipeSegment(ID_THAUMIUM), ID_THAUMIUM);
        }
        if (Config.pipeEnabledVoidmetal) {
            pipe_segment_voidmetal = BlockPipeSegment.register(new BlockPipeSegment(ID_VOIDMETAL), ID_VOIDMETAL);
        }
        GameRegistry.registerTileEntity(TileEntityIOPipeSegment.class, (String)TileEntityIOPipeSegment.ID);
    }

    private static BlockPipeSegment register(BlockPipeSegment instance, String id) {
        instance.func_149663_c(EssentiaPipes.modid(id));
        instance.func_149647_a(EssentiaPipes.proxy.getCreativeTab());
        GameRegistry.registerBlock((Block)instance, ItemBlockPipeSegment.class, (String)id);
        return instance;
    }

    public static PipeColor pipeColorFromMetadata(int metadata) {
        return PipeColor.fromId(metadata & 0xFFFFFFF7);
    }

    public static boolean isIOSegment(int metadata) {
        return (metadata & 8) == 8;
    }

    public static boolean verifyIOState(World world, int x, int y, int z) {
        Block segment = world.func_147439_a(x, y, z);
        if (!(segment instanceof BlockPipeSegment)) {
            return false;
        }
        int metadata = world.func_72805_g(x, y, z);
        boolean isIOSegment = BlockPipeSegment.isIOSegment(metadata);
        boolean shouldBeIO = BlockPipeSegment.shouldBeIOSegment(world, x, y, z);
        PipeColor pipeColor = BlockPipeSegment.pipeColorFromMetadata(metadata);
        if (!isIOSegment && shouldBeIO) {
            world.func_72921_c(x, y, z, pipeColor.id | 8, 2);
            return true;
        }
        if (isIOSegment && !shouldBeIO) {
            world.func_72921_c(x, y, z, (int)pipeColor.id, 2);
            return true;
        }
        return false;
    }

    private static boolean shouldBeIOSegment(World world, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int dX = x + dir.offsetX;
            int dY = y + dir.offsetY;
            int dZ = z + dir.offsetZ;
            TileEntity tileEntity = world.func_147438_o(dX, dY, dZ);
            if (!(tileEntity instanceof IEssentiaTransport) || tileEntity instanceof IIOPipeSegment) continue;
            return true;
        }
        return false;
    }

    protected BlockPipeSegment(String id) {
        super(Material.field_151573_f);
        this.id = id;
        this.func_149711_c(0.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    private static AxisAlignedBB calcBoundingBox(World world, int x, int y, int z) {
        float minX = PipeHelper.canConnectVisually((IBlockAccess)world, x, y, z, ForgeDirection.WEST) ? 0.0f : 0.375f;
        float minY = PipeHelper.canConnectVisually((IBlockAccess)world, x, y, z, ForgeDirection.DOWN) ? 0.0f : 0.375f;
        float minZ = PipeHelper.canConnectVisually((IBlockAccess)world, x, y, z, ForgeDirection.NORTH) ? 0.0f : 0.375f;
        float maxX = PipeHelper.canConnectVisually((IBlockAccess)world, x, y, z, ForgeDirection.EAST) ? 1.0f : 0.625f;
        float maxY = PipeHelper.canConnectVisually((IBlockAccess)world, x, y, z, ForgeDirection.UP) ? 1.0f : 0.625f;
        float maxZ = PipeHelper.canConnectVisually((IBlockAccess)world, x, y, z, ForgeDirection.SOUTH) ? 1.0f : 0.625f;
        return AxisAlignedBB.func_72330_a((double)((float)x + minX), (double)((float)y + minY), (double)((float)z + minZ), (double)((float)x + maxX), (double)((float)y + maxY), (double)((float)z + maxZ));
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity) {
        AxisAlignedBB pipeBounds = BlockPipeSegment.calcBoundingBox(world, x, y, z);
        if (mask.func_72326_a(pipeBounds)) {
            list.add(pipeBounds);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block blockBroken, int meta) {
        super.func_149749_a(world, x, y, z, blockBroken, meta);
        PipeHelper.notifySegmentRemoved(world, x, y, z);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return BlockPipeSegment.isIOSegment(metadata) ? new TileEntityIOPipeSegment() : null;
    }

    public AxisAlignedBB func_149668_a(World worldIn, int x, int y, int z) {
        return BlockPipeSegment.calcBoundingBox(worldIn, x, y, z);
    }

    public IIcon func_149691_a(int side, int metadata) {
        PipeColor color = BlockPipeSegment.pipeColorFromMetadata(metadata);
        return this.icons[color.id];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess worldIn, int x, int y, int z, int side) {
        int metadata = worldIn.func_72805_g(x, y, z);
        return this.func_149691_a(side, metadata);
    }

    public int func_149645_b() {
        return renderId;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return BlockPipeSegment.calcBoundingBox(world, x, y, z);
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        BlockPipeSegment.verifyIOState(world, x, y, z);
        PipeHelper.notifySegmentAddedOrChanged(world, x, y, z);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        ArrayList<IndexedCuboid6> cuboids = new ArrayList<IndexedCuboid6>(6);
        float min = 0.42f;
        float max = 0.58f;
        if (PipeHelper.canConnectVisually((IBlockAccess)world, x, y, z, ForgeDirection.DOWN)) {
            cuboids.add(new IndexedCuboid6((Object)0, new Cuboid6((double)((float)x + min), (double)y, (double)((float)z + min), (double)((float)x + max), (double)y + 0.5, (double)((float)z + max))));
        }
        if (PipeHelper.canConnectVisually((IBlockAccess)world, x, y, z, ForgeDirection.UP)) {
            cuboids.add(new IndexedCuboid6((Object)1, new Cuboid6((double)((float)x + min), (double)y + 0.5, (double)((float)z + min), (double)((float)x + max), (double)(y + 1), (double)((float)z + max))));
        }
        if (PipeHelper.canConnectVisually((IBlockAccess)world, x, y, z, ForgeDirection.NORTH)) {
            cuboids.add(new IndexedCuboid6((Object)2, new Cuboid6((double)((float)x + min), (double)((float)y + min), (double)z, (double)((float)x + max), (double)((float)y + max), (double)z + 0.5)));
        }
        if (PipeHelper.canConnectVisually((IBlockAccess)world, x, y, z, ForgeDirection.SOUTH)) {
            cuboids.add(new IndexedCuboid6((Object)3, new Cuboid6((double)((float)x + min), (double)((float)y + min), (double)z + 0.5, (double)((float)x + max), (double)((float)y + max), (double)(z + 1))));
        }
        if (PipeHelper.canConnectVisually((IBlockAccess)world, x, y, z, ForgeDirection.WEST)) {
            cuboids.add(new IndexedCuboid6((Object)4, new Cuboid6((double)x, (double)((float)y + min), (double)((float)z + min), (double)x + 0.5, (double)((float)y + max), (double)((float)z + max))));
        }
        if (PipeHelper.canConnectVisually((IBlockAccess)world, x, y, z, ForgeDirection.EAST)) {
            cuboids.add(new IndexedCuboid6((Object)5, new Cuboid6((double)x + 0.5, (double)((float)y + min), (double)((float)z + min), (double)(x + 1), (double)((float)y + max), (double)((float)z + max))));
        }
        cuboids.add(new IndexedCuboid6((Object)6, new Cuboid6((double)x + 0.34375, (double)y + 0.34375, (double)z + 0.34375, (double)x + 0.65625, (double)y + 0.65625, (double)z + 0.65625)));
        return this.rayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), cuboids, new BlockCoord(x, y, z), (Block)this);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        super.func_149695_a(world, x, y, z, neighbor);
        if (!(neighbor instanceof IPipeSegment) && BlockPipeSegment.verifyIOState(world, x, y, z)) {
            PipeHelper.notifySegmentAddedOrChanged(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        int metadata = world.func_72805_g(x, y, z);
        if (!BlockPipeSegment.isIOSegment(metadata) || !world.func_72864_z(x, y, z)) {
            return;
        }
        float posMin = 0.1875f;
        float pX = (float)x + 0.1875f + random.nextFloat() * 0.59375f;
        float pY = (float)y + 0.1875f + random.nextFloat() * 0.59375f;
        float pZ = (float)z + 0.1875f + random.nextFloat() * 0.59375f;
        boolean vX = true;
        float vY = 0.2f;
        float vZ = 0.0f;
        world.func_72869_a("reddust", (double)pX, (double)pY, (double)pZ, 1.0, (double)0.2f, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        for (int index = 0; index < this.icons.length; ++index) {
            String path = String.format("%s:%s_%01d", "essentiapipes", this.getId(), index);
            this.icons[index] = reg.func_94245_a(path);
        }
        this.valveIcon[0] = reg.func_94245_a("thaumcraft:pipe_2");
    }

    protected String getId() {
        return this.id;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public boolean canConnectTo(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        int dX = x + face.offsetX;
        int dY = y + face.offsetY;
        int dZ = z + face.offsetZ;
        Block adjacentBlock = world.func_147439_a(dX, dY, dZ);
        return this == adjacentBlock && this.getPipeColor(world, x, y, z).willConnectTo(this.getPipeColor(world, dX, dY, dZ));
    }

    @Override
    public PipeColor getPipeColor(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        return BlockPipeSegment.pipeColorFromMetadata(metadata);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return this.createTileEntity(worldIn, meta);
    }

    public int onWandRightClick(World world, ItemStack wandStack, EntityPlayer player, int x, int y, int z, int side, int metadata) {
        PipeColor color = BlockPipeSegment.pipeColorFromMetadata(metadata);
        int connectorBit = BlockPipeSegment.isIOSegment(metadata) ? 8 : 0;
        PipeColor newColor = player.func_70093_af() ? color.prevColor() : color.nextColor();
        world.func_72921_c(x, y, z, newColor.id | connectorBit, 3);
        PipeHelper.notifySegmentAddedOrChanged(world, x, y, z);
        return 0;
    }

    public ItemStack onWandRightClick(World var1, ItemStack var2, EntityPlayer var3) {
        return null;
    }

    public void onUsingWandTick(ItemStack var1, EntityPlayer var2, int var3) {
    }

    public void onWandStoppedUsing(ItemStack var1, World var2, EntityPlayer var3, int var4) {
    }

    static {
        renderId = -1;
    }
}

