/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.essentiapipes.client;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dev.rndmorris.essentiapipes.api.IIOPipeSegment;
import dev.rndmorris.essentiapipes.api.PipeHelper;
import dev.rndmorris.essentiapipes.blocks.BlockPipeSegment;
import dev.rndmorris.essentiapipes.client.Bounds;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.client.renderers.block.BlockRenderer;

@SideOnly(value=Side.CLIENT)
public class BlockPipeSegmentRenderer
extends RenderBlocks
implements ISimpleBlockRenderingHandler {
    public static int renderId;
    public static BlockPipeSegmentRenderer instance;

    public static void init() {
        BlockPipeSegment.renderId = renderId = RenderingRegistry.getNextAvailableRenderId();
        instance = new BlockPipeSegmentRenderer();
        RenderingRegistry.registerBlockHandler((int)renderId, (ISimpleBlockRenderingHandler)instance);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockPipeSegment)) {
            return;
        }
        BlockPipeSegment pipeSegment = (BlockPipeSegment)block;
        Bounds.Z_FULL.applyTo(renderer);
        BlockRenderer.drawFaces((RenderBlocks)renderer, (Block)block, (IIcon)pipeSegment.func_149691_a(0, metadata), (boolean)false);
        Bounds.VALVE.applyTo(renderer);
        BlockRenderer.drawFaces((RenderBlocks)renderer, (Block)block, (IIcon)pipeSegment.valveIcon[0], (boolean)false);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int metadata;
        if (!(block instanceof BlockPipeSegment)) {
            return false;
        }
        BlockPipeSegment pipeSegment = (BlockPipeSegment)block;
        boolean[] render = new boolean[ForgeDirection.VALID_DIRECTIONS.length];
        boolean[] extend = new boolean[ForgeDirection.VALID_DIRECTIONS.length];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!PipeHelper.canConnectVisually(world, x, y, z, dir)) continue;
            render[dir.ordinal()] = true;
            extend[dir.ordinal()] = BlockPipeSegmentRenderer.extendTowards(world, x, y, z, dir);
        }
        boolean renderedAny = false;
        Bounds bounds = Bounds.getXBounds(render);
        if (bounds != null) {
            renderedAny = true;
            bounds.applyTo(renderer).func_147784_q(block, x, y, z);
            if (extend[ForgeDirection.WEST.ordinal()]) {
                Bounds.EXTEND_X_NEG.applyTo(renderer).func_147784_q(block, x - 1, y, z);
            }
            if (extend[ForgeDirection.EAST.ordinal()]) {
                Bounds.EXTEND_X_POS.applyTo(renderer).func_147784_q(block, x + 1, y, z);
            }
        }
        if ((bounds = Bounds.getYBounds(render)) != null) {
            renderedAny = true;
            bounds.applyTo(renderer).func_147784_q(block, x, y, z);
            if (extend[ForgeDirection.DOWN.ordinal()]) {
                Bounds.EXTEND_Y_NEG.applyTo(renderer).func_147784_q(block, x, y - 1, z);
            }
            if (extend[ForgeDirection.EAST.ordinal()]) {
                Bounds.EXTEND_Y_POS.applyTo(renderer).func_147784_q(block, x, y + 1, z);
            }
        }
        if ((bounds = Bounds.getZBounds(render)) != null) {
            renderedAny = true;
            bounds.applyTo(renderer).func_147784_q(block, x, y, z);
            if (extend[ForgeDirection.NORTH.ordinal()]) {
                Bounds.EXTEND_Z_NEG.applyTo(renderer).func_147784_q(block, x, y - 1, z);
            }
            if (extend[ForgeDirection.SOUTH.ordinal()]) {
                Bounds.EXTEND_Z_POS.applyTo(renderer).func_147784_q(block, x, y + 1, z);
            }
        }
        if (!renderedAny) {
            Bounds.DEFAULT.applyTo(renderer).func_147784_q(block, x, y, z);
        }
        if (BlockPipeSegment.isIOSegment(metadata = world.func_72805_g(x, y, z))) {
            renderer.field_147840_d = pipeSegment.valveIcon[0];
            Bounds.VALVE.applyTo(renderer).func_147784_q(block, x, y, z);
            renderer.func_147771_a();
        }
        return true;
    }

    private static boolean extendTowards(IBlockAccess world, int x, int y, int z, ForgeDirection direction) {
        IEssentiaTransport transport;
        TileEntity adjacentTile = world.func_147438_o(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ);
        if (adjacentTile instanceof IIOPipeSegment) {
            return false;
        }
        return adjacentTile instanceof IEssentiaTransport && (transport = (IEssentiaTransport)adjacentTile).renderExtendedTube();
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return renderId;
    }

    static {
        instance = new BlockPipeSegmentRenderer();
    }
}

