/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.essentiapipes.client;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraftforge.common.util.ForgeDirection;

final class Bounds {
    private static final float MIN = 0.40625f;
    private static final float MAX = 0.59375f;
    private static final float MIN_FULL = 0.0f;
    private static final float MAX_FULL = 1.0f;
    private static final float MAX_EXTEND = 0.375f;
    private static final float MIN_EXTEND = 0.625f;
    private static final float MIN_VALVE = 0.375f;
    private static final float MAX_VALVE = 0.625f;
    public static final Bounds DEFAULT = new Bounds(0.40625f, 0.40625f, 0.40625f, 0.59375f, 0.59375f, 0.59375f);
    public static final Bounds VALVE = new Bounds(0.375f, 0.375f, 0.375f, 0.625f, 0.625f, 0.625f);
    public static final Bounds X_FULL = new Bounds(0.0f, 0.40625f, 0.40625f, 1.0f, 0.59375f, 0.59375f);
    public static final Bounds X_NEG = new Bounds(0.0f, 0.40625f, 0.40625f, 0.59375f, 0.59375f, 0.59375f);
    public static final Bounds X_POS = new Bounds(0.40625f, 0.40625f, 0.40625f, 1.0f, 0.59375f, 0.59375f);
    public static final Bounds Y_FULL = new Bounds(0.40625f, 0.0f, 0.40625f, 0.59375f, 1.0f, 0.59375f);
    public static final Bounds Y_NEG = new Bounds(0.40625f, 0.0f, 0.40625f, 0.59375f, 0.59375f, 0.59375f);
    public static final Bounds Y_POS = new Bounds(0.40625f, 0.40625f, 0.40625f, 0.59375f, 1.0f, 0.59375f);
    public static final Bounds Z_FULL = new Bounds(0.40625f, 0.40625f, 0.0f, 0.59375f, 0.59375f, 1.0f);
    public static final Bounds Z_NEG = new Bounds(0.40625f, 0.40625f, 0.0f, 0.59375f, 0.59375f, 0.59375f);
    public static final Bounds Z_POS = new Bounds(0.40625f, 0.40625f, 0.40625f, 0.59375f, 0.59375f, 1.0f);
    public static final Bounds EXTEND_X_NEG = new Bounds(0.625f, 0.40625f, 0.40625f, 1.0f, 0.59375f, 0.59375f);
    public static final Bounds EXTEND_X_POS = new Bounds(0.0f, 0.40625f, 0.40625f, 0.375f, 0.59375f, 0.59375f);
    public static final Bounds EXTEND_Y_NEG = new Bounds(0.40625f, 0.625f, 0.40625f, 0.59375f, 1.0f, 0.59375f);
    public static final Bounds EXTEND_Y_POS = new Bounds(0.40625f, 0.0f, 0.40625f, 0.59375f, 0.375f, 0.59375f);
    public static final Bounds EXTEND_Z_NEG = new Bounds(0.40625f, 0.40625f, 0.625f, 0.59375f, 0.59375f, 1.0f);
    public static final Bounds EXTEND_Z_POS = new Bounds(0.40625f, 0.40625f, 0.0f, 0.59375f, 0.59375f, 0.375f);
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;

    @Nullable
    public static Bounds getXBounds(boolean[] render) {
        boolean renderNeg = render[ForgeDirection.WEST.ordinal()];
        boolean renderPos = render[ForgeDirection.EAST.ordinal()];
        if (renderNeg && renderPos) {
            return X_FULL;
        }
        if (renderNeg) {
            return X_NEG;
        }
        if (renderPos) {
            return X_POS;
        }
        return null;
    }

    @Nullable
    public static Bounds getYBounds(boolean[] render) {
        boolean renderNeg = render[ForgeDirection.DOWN.ordinal()];
        boolean renderPos = render[ForgeDirection.UP.ordinal()];
        if (renderNeg && renderPos) {
            return Y_FULL;
        }
        if (renderNeg) {
            return Y_NEG;
        }
        if (renderPos) {
            return Y_POS;
        }
        return null;
    }

    @Nullable
    public static Bounds getZBounds(boolean[] render) {
        boolean renderNeg = render[ForgeDirection.NORTH.ordinal()];
        boolean renderPos = render[ForgeDirection.SOUTH.ordinal()];
        if (renderNeg && renderPos) {
            return Z_FULL;
        }
        if (renderNeg) {
            return Z_NEG;
        }
        if (renderPos) {
            return Z_POS;
        }
        return null;
    }

    private Bounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public RenderBlocks applyTo(RenderBlocks renderer) {
        renderer.func_147782_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        return renderer;
    }
}

