/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.essentiapipes.data;

import dev.rndmorris.essentiapipes.api.ConnectionInfo;
import dev.rndmorris.essentiapipes.api.WorldCoordinate;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class ConnectionSet
extends TreeSet<ConnectionInfo> {
    public static final String DIM = "dimensionId";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String Z = "z";
    public static final String DIST = "distance";

    public void writeToNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        int[] dim = new int[this.size()];
        int[] x = new int[this.size()];
        int[] y = new int[this.size()];
        int[] z = new int[this.size()];
        int[] dist = new int[this.size()];
        int index = 0;
        for (ConnectionInfo info : this) {
            WorldCoordinate pos = info.coordinate();
            dim[index] = pos.dimensionId();
            x[index] = pos.x();
            y[index] = pos.y();
            z[index] = pos.z();
            dist[index] = info.distance();
        }
        nbtTagCompound.func_74783_a(DIM, dim);
        nbtTagCompound.func_74783_a(X, x);
        nbtTagCompound.func_74783_a(Y, y);
        nbtTagCompound.func_74783_a(Z, z);
        nbtTagCompound.func_74783_a(DIST, dist);
    }

    public void readFromNBT(@Nullable NBTTagCompound nbtTagCompound) {
        int[] dist;
        int[] z;
        int[] y;
        int[] x;
        this.clear();
        if (nbtTagCompound == null || ConnectionSet.missingAnyKeys(nbtTagCompound)) {
            return;
        }
        int[] dim = nbtTagCompound.func_74759_k(DIM);
        if (ConnectionSet.mismatchedLengths(dim, x = nbtTagCompound.func_74759_k(X), y = nbtTagCompound.func_74759_k(Y), z = nbtTagCompound.func_74759_k(Z), dist = nbtTagCompound.func_74759_k(DIST))) {
            return;
        }
        for (int index = 0; index < dim.length; ++index) {
            this.add(new ConnectionInfo(new WorldCoordinate(dim[index], x[index], y[index], z[index]), dist[index]));
        }
    }

    private static boolean missingAnyKeys(@Nonnull NBTTagCompound nbtTagCompound) {
        return !nbtTagCompound.func_74764_b(DIM) || !nbtTagCompound.func_74764_b(X) || !nbtTagCompound.func_74764_b(Y) || !nbtTagCompound.func_74764_b(Z) || !nbtTagCompound.func_74764_b(DIST);
    }

    private static boolean mismatchedLengths(int[] ... arrays) {
        int length = -1;
        for (int[] arr : arrays) {
            if (length < 0) {
                length = arr.length;
                continue;
            }
            if (length == arr.length) continue;
            return true;
        }
        return false;
    }
}

