/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.essentiapipes.data;

import dev.rndmorris.essentiapipes.api.EssentiaRequest;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class EssentiaRequestSet {
    private final EssentiaRequest[] requests = new EssentiaRequest[ForgeDirection.VALID_DIRECTIONS.length];

    public EssentiaRequest getRequest(@Nonnull ForgeDirection direction) {
        return this.requests[EssentiaRequestSet.requireValidDirection(direction).ordinal()];
    }

    public void setRequest(@Nonnull ForgeDirection direction, @Nullable EssentiaRequest request) {
        this.requests[EssentiaRequestSet.requireValidDirection((ForgeDirection)direction).ordinal()] = request;
    }

    private static ForgeDirection requireValidDirection(ForgeDirection direction) {
        Objects.requireNonNull(direction);
        if (direction == ForgeDirection.UNKNOWN) {
            throw new IllegalArgumentException(String.format("%s is not a valid %s.", direction, ForgeDirection.class.getName()));
        }
        return direction;
    }

    public void updateWith(Updater updater) {
        Objects.requireNonNull(updater);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            this.requests[direction.ordinal()] = updater.update(direction, this.requests[direction.ordinal()]);
        }
    }

    public void clear() {
        this.updateWith((dir, request) -> null);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            EssentiaRequest request = this.getRequest(direction);
            if (request == null) continue;
            NBTTagCompound requestTag = new NBTTagCompound();
            request.writeToNBT(requestTag);
            nbtTagCompound.func_74782_a(direction.toString(), (NBTBase)requestTag);
        }
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!nbtTagCompound.func_74764_b(direction.toString())) continue;
            NBTTagCompound requestTag = nbtTagCompound.func_74775_l(direction.toString());
            EssentiaRequest request = new EssentiaRequest(requestTag);
            this.setRequest(direction, request);
        }
    }

    public static interface Updater {
        @Nullable
        public EssentiaRequest update(@Nonnull ForgeDirection var1, @Nullable EssentiaRequest var2);
    }
}

