/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.essentiapipes.tile;

import dev.rndmorris.essentiapipes.Config;
import dev.rndmorris.essentiapipes.EssentiaPipes;
import dev.rndmorris.essentiapipes.api.ConnectionInfo;
import dev.rndmorris.essentiapipes.api.EssentiaRequest;
import dev.rndmorris.essentiapipes.api.IIOPipeSegment;
import dev.rndmorris.essentiapipes.api.PipeHelper;
import dev.rndmorris.essentiapipes.api.WorldCoordinate;
import dev.rndmorris.essentiapipes.blocks.BlockPipeSegment;
import dev.rndmorris.essentiapipes.data.ConnectionSet;
import dev.rndmorris.essentiapipes.data.EssentiaRequestSet;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

public class TileEntityIOPipeSegment
extends TileThaumcraft
implements IIOPipeSegment {
    public static final String CONNECTIONS = "connections";
    public static final String ID = EssentiaPipes.modid("IOPipeSegment");
    public static final String RESCAN_OFFSET = "rescanTickOffset";
    public static final String REQUEST_OFFSET = "requestTickOffset";
    public static final String REQUESTS = "requests";
    public final ConnectionSet connections = new ConnectionSet();
    public final EssentiaRequestSet incomingRequests = new EssentiaRequestSet();
    private int rescanTickOffset = -1;
    private int requestTickOffset = -1;
    private WorldCoordinate coordinate;
    private int cycleLength = -1;
    private int transferRate = -1;

    private int halfCycle() {
        return this.cycleLength / 2;
    }

    private int quarterCycle() {
        return this.cycleLength / 4;
    }

    public void markDirty(boolean internal) {
        super.func_70296_d();
        if (!internal) {
            BlockPipeSegment.verifyIOState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void sendEssentiaRequests() {
        if (this.isRedstonePowered()) {
            return;
        }
        block0: for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            EssentiaRequest outgoingRequest = this.getRequestFor(dir);
            if (outgoingRequest == null) continue;
            outgoingRequest.distance = 1;
            if (this.evaluateEssentiaRequest(outgoingRequest)) continue;
            for (ConnectionInfo conn : this.connections) {
                boolean requestedAccepted;
                IIOPipeSegment ioSegment = conn.getIOSegment();
                if (ioSegment == null) continue;
                outgoingRequest.distance = conn.distance() + 1;
                if (outgoingRequest.effectiveSuction() > 0 && !(requestedAccepted = ioSegment.evaluateEssentiaRequest(outgoingRequest))) continue;
                continue block0;
            }
        }
    }

    @Nullable
    private EssentiaRequest getRequestFor(ForgeDirection dir) {
        WorldCoordinate destinationBlock = this.getCoordinate().shift(dir);
        ForgeDirection insertToFace = dir.getOpposite();
        IEssentiaTransport transport = destinationBlock.getTileEntity(IEssentiaTransport.class);
        if (transport == null || transport instanceof IIOPipeSegment || !transport.canInputFrom(insertToFace)) {
            return null;
        }
        int suctionAmount = transport.getSuctionAmount(insertToFace);
        if (suctionAmount < 1) {
            return null;
        }
        return new EssentiaRequest(destinationBlock, insertToFace, transport.getSuctionType(insertToFace), suctionAmount);
    }

    private void distributeEssentia() {
        if (this.isRedstonePowered()) {
            return;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int amountTaken;
            int takeAmount;
            Aspect transferAspect;
            int amountAdded;
            IEssentiaTransport destination;
            EssentiaRequest request = this.incomingRequests.getRequest(dir);
            if (request == null) continue;
            IEssentiaTransport source = this.getEssentiaTransport(dir);
            ForgeDirection takeFromFace = dir.getOpposite();
            if (source == null || !source.canOutputTo(takeFromFace) || (destination = request.destination.getTileEntity(IEssentiaTransport.class)) == null || !destination.canInputFrom(request.destinationFace) || destination.getSuctionAmount(request.destinationFace) <= 0 || destination.getSuctionType(request.destinationFace) != request.aspect || (amountAdded = destination.addEssentia(transferAspect = request.aspect != null ? request.aspect : this.pickAspectToTake(source, takeFromFace), takeAmount = this.calculateAmountToTake(source, takeFromFace, transferAspect), request.destinationFace)) <= (amountTaken = source.takeEssentia(transferAspect, amountAdded, takeFromFace))) continue;
            EssentiaPipes.LOG.error("({}, {}, {}): Added ({}) more than it could take ({}). This should not happen.", new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, amountAdded, amountTaken});
        }
    }

    private Aspect pickAspectToTake(IEssentiaTransport source, ForgeDirection takeFromFace) {
        Aspect fromFace = source.getEssentiaType(takeFromFace);
        if (fromFace != null) {
            return fromFace;
        }
        if (source instanceof IAspectContainer) {
            IAspectContainer container = (IAspectContainer)source;
            Aspect[] containedAspects = container.getAspects().getAspects();
            return containedAspects[this.field_145850_b.field_73012_v.nextInt(containedAspects.length)];
        }
        return null;
    }

    private int calculateAmountToTake(IEssentiaTransport source, ForgeDirection takeFromFace, Aspect aspect) {
        if (source instanceof IAspectContainer) {
            IAspectContainer container = (IAspectContainer)source;
            int containedAmount = container.getAspects().getAmount(aspect);
            return Integer.min(this.transferRate, containedAmount);
        }
        int contained = source.getEssentiaAmount(takeFromFace);
        return Integer.min(this.transferRate, contained);
    }

    private IEssentiaTransport getEssentiaTransport(ForgeDirection dir) {
        WorldCoordinate here = this.getCoordinate();
        WorldCoordinate there = here.shift(dir);
        IEssentiaTransport transport = there.getTileEntity(IEssentiaTransport.class);
        if (transport == null || transport instanceof IIOPipeSegment) {
            return null;
        }
        return transport;
    }

    private boolean isDistributePhase(int step) {
        return step % this.quarterCycle() == this.requestTickOffset;
    }

    private boolean isRescanPhase(int step) {
        return step < this.halfCycle() && step % this.halfCycle() == this.rescanTickOffset;
    }

    private boolean isRedstonePowered() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private boolean isRequestPhase(int step) {
        return step < this.halfCycle() + this.quarterCycle() && step % this.quarterCycle() == this.requestTickOffset;
    }

    private void updateCycleLength() {
        Block thisBlock = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (thisBlock == BlockPipeSegment.pipe_segment_thaumium) {
            this.cycleLength = Config.cycleLengthThaumium;
            return;
        }
        if (thisBlock == BlockPipeSegment.pipe_segment_voidmetal) {
            this.cycleLength = Config.cycleLengthVoidmetal;
            return;
        }
        this.cycleLength = Config.cycleLengthBasic;
    }

    private void updateTransferRate() {
        Block thisBlock = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (thisBlock == BlockPipeSegment.pipe_segment_thaumium) {
            this.transferRate = Config.transferRateThaumium;
            return;
        }
        if (thisBlock == BlockPipeSegment.pipe_segment_voidmetal) {
            this.transferRate = Config.transferRateVoidmetal;
            return;
        }
        this.transferRate = Config.transferRateBasic;
    }

    public void func_145845_h() {
        if (this.cycleLength < 0) {
            this.updateCycleLength();
        }
        if (this.transferRate < 0) {
            this.updateTransferRate();
        }
        if (this.rescanTickOffset < 0) {
            this.rescanTickOffset = this.field_145850_b.field_73012_v.nextInt(this.halfCycle());
            this.markDirty(true);
        }
        if (this.requestTickOffset < 0) {
            this.requestTickOffset = this.field_145850_b.field_73012_v.nextInt(this.quarterCycle());
            this.markDirty(true);
        }
        try {
            int step = (int)(this.field_145850_b.func_82737_E() % (long)this.cycleLength);
            if (this.isRescanPhase(step)) {
                this.rebuildIOConnections();
                return;
            }
            if (this.isRequestPhase(step)) {
                this.sendEssentiaRequests();
                return;
            }
            if (this.isDistributePhase(step)) {
                this.distributeEssentia();
                this.incomingRequests.clear();
                this.rescanTickOffset = -1;
                this.requestTickOffset = -1;
                this.markDirty(true);
                return;
            }
        }
        catch (Exception ex) {
            EssentiaPipes.LOG.catching((Throwable)ex);
        }
    }

    public void func_70296_d() {
        this.markDirty(false);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.coordinate = null;
        this.connections.readFromNBT(compound.func_74775_l(CONNECTIONS));
        this.incomingRequests.readFromNBT(compound.func_74775_l(REQUESTS));
        if (compound.func_74764_b(RESCAN_OFFSET)) {
            this.rescanTickOffset = compound.func_74762_e(RESCAN_OFFSET);
        }
        if (compound.func_74764_b(REQUEST_OFFSET)) {
            this.requestTickOffset = compound.func_74762_e(REQUEST_OFFSET);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagCompound connectionsTag = new NBTTagCompound();
        this.connections.writeToNBT(connectionsTag);
        compound.func_74782_a(CONNECTIONS, (NBTBase)connectionsTag);
        NBTTagCompound requestsTag = new NBTTagCompound();
        this.incomingRequests.writeToNBT(requestsTag);
        compound.func_74782_a(REQUESTS, (NBTBase)requestsTag);
        compound.func_74768_a(RESCAN_OFFSET, this.rescanTickOffset);
        compound.func_74768_a(REQUEST_OFFSET, this.requestTickOffset);
    }

    public boolean isConnectable(ForgeDirection dir) {
        return true;
    }

    public boolean canInputFrom(ForgeDirection dir) {
        return true;
    }

    public boolean canOutputTo(ForgeDirection dir) {
        return true;
    }

    public void setSuction(Aspect aspect, int strength) {
    }

    public Aspect getSuctionType(ForgeDirection direction) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection direction) {
        return 0;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection direction) {
        return 0;
    }

    public int addEssentia(Aspect var1, int var2, ForgeDirection var3) {
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection direction) {
        return null;
    }

    public int getEssentiaAmount(ForgeDirection direction) {
        return 0;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    @Override
    public boolean evaluateEssentiaRequest(EssentiaRequest incomingRequest) {
        if (this.isRedstonePowered()) {
            return false;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            EssentiaRequest savedRequest;
            boolean isBestRequest;
            WorldCoordinate sourceCoords;
            ForgeDirection sourceFace = dir.getOpposite();
            IEssentiaTransport potentialSource = this.getEssentiaTransport(dir);
            if (potentialSource == null || !potentialSource.canOutputTo(sourceFace) || incomingRequest.destination.equals(sourceCoords = WorldCoordinate.fromTileEntity(potentialSource)) || potentialSource.getMinimumSuction() >= incomingRequest.effectiveSuction()) continue;
            Aspect requestedAspect = incomingRequest.aspect;
            if (potentialSource.getEssentiaAmount(sourceFace) <= 0) continue;
            if (potentialSource instanceof IAspectContainer) {
                IAspectContainer container = (IAspectContainer)potentialSource;
                if (requestedAspect != null && !container.doesContainerContainAmount(requestedAspect, 1)) {
                    continue;
                }
            } else if (requestedAspect != null && potentialSource.getEssentiaType(sourceFace) != requestedAspect) continue;
            boolean bl = isBestRequest = (savedRequest = this.incomingRequests.getRequest(dir)) == null || savedRequest.isSuperceededBy(incomingRequest);
            if (isBestRequest) {
                this.incomingRequests.setRequest(dir, incomingRequest);
                this.markDirty(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public WorldCoordinate getCoordinate() {
        if (this.coordinate == null) {
            this.coordinate = new WorldCoordinate(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.coordinate;
    }

    @Override
    public void rebuildIOConnections() {
        WorldCoordinate here = this.getCoordinate();
        Collection<ConnectionInfo> foundConnections = PipeHelper.findIOPipeSegments(PipeHelper.SearchType.BreadthFirst, here);
        this.connections.clear();
        this.incomingRequests.clear();
        for (ConnectionInfo ci : foundConnections) {
            if (here.equals(ci.coordinate())) continue;
            this.connections.add(ci);
        }
        this.markDirty(true);
    }
}

