/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.configuralize;

import github.scarsz.configuralize.Language;
import github.scarsz.configuralize.ParseException;
import github.scarsz.configuralize.Provider;
import github.scarsz.configuralize.Source;
import github.scarsz.discordsrv.dependencies.alexh.weak.Dynamic;
import github.scarsz.discordsrv.dependencies.alexh.weak.Weak;
import github.scarsz.discordsrv.dependencies.json.simple.parser.JSONParser;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.yaml.snakeyaml.Yaml;

public class DynamicConfig {
    private final Map<Source, Provider> sources = new LinkedHashMap<Source, Provider>();
    private final Map<String, Object> runtimeValues = new HashMap<String, Object>();
    private Language language;
    private JSONParser jsonParser = null;
    private Yaml yamlParser = null;

    public DynamicConfig(Source ... sources) {
        this(Language.EN, sources);
    }

    public DynamicConfig(Language language, Source ... sources) {
        this.language = language;
        Arrays.stream(sources).forEach(this::addSource);
    }

    public boolean isLanguageAvailable() {
        return this.isLanguageAvailable(this.language);
    }

    public boolean isLanguageAvailable(Language language) {
        return this.sources.keySet().stream().allMatch(source -> source.isLanguageAvailable(language));
    }

    public boolean addSource(Source source) {
        return this.sources.put(source, new Provider(this, source)) == null;
    }

    public boolean addSource(Class clazz, String resource, File file) {
        Source source = new Source(this, clazz, resource, file);
        return this.sources.put(source, new Provider(this, source)) == null;
    }

    public boolean removeSource(Source source) {
        return this.sources.remove(source) != null;
    }

    public void saveAllDefaults() throws IOException {
        this.saveAllDefaults(false);
    }

    public void saveAllDefaults(boolean overwrite) throws IOException {
        for (Map.Entry<Source, Provider> source : this.sources.entrySet()) {
            source.getValue().saveDefaults(overwrite);
        }
    }

    public void loadAll() throws IOException, ParseException {
        for (Map.Entry<Source, Provider> source : this.sources.entrySet()) {
            source.getValue().load();
        }
    }

    public Dynamic dget(String key) throws IllegalArgumentException {
        if (this.runtimeValues.containsKey(key)) {
            return Dynamic.from(this.runtimeValues.get(key));
        }
        return this.sources.values().stream().filter(Objects::nonNull).filter(provider -> provider.getValues() != null).map(provider -> provider.getValues().dget(key)).filter(Objects::nonNull).filter(Weak::isPresent).findFirst().orElseGet(() -> this.sources.values().stream().map(provider -> provider.getDefaults().dget(key)).filter(Weak::isPresent).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid key: " + key)));
    }

    public <T> T get(String key) throws RuntimeException {
        return (T)this.dget(key).asObject();
    }

    public <T> Optional<T> getOptional(String key) {
        try {
            return Optional.ofNullable(this.get(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public <T> T getElse(String key, T otherwise) {
        try {
            return this.get(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public <K, V> Map<K, V> getMap(String key) throws RuntimeException {
        return this.dget(key).convert().intoMap();
    }

    public <K, V> Optional<Map<K, V>> getOptionalMap(String key) {
        try {
            return Optional.ofNullable(this.getMap(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public <K, V> Map<K, V> getMapElse(String key, Map<K, V> otherwise) {
        try {
            return this.getMap(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public <T> List<T> getList(String key) throws RuntimeException {
        return this.dget(key).convert().intoList();
    }

    public <T> Optional<List<T>> getOptionalList(String key) {
        try {
            return Optional.ofNullable(this.getList(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public <T> List<T> getListElse(String key, List<T> otherwise) {
        try {
            return this.getList(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public String getString(String key) throws RuntimeException {
        return this.dget(key).convert().intoString();
    }

    public Optional<String> getOptionalString(String key) {
        try {
            return Optional.ofNullable(this.getString(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public String getStringElse(String key, String otherwise) {
        try {
            return this.getString(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public List<String> getStringList(String key) throws RuntimeException {
        return this.dget(key).convert().intoList();
    }

    public Optional<List<String>> getOptionalStringList(String key) {
        try {
            return Optional.ofNullable(this.getStringList(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public List<String> getStringListElse(String key, List<String> otherwise) {
        try {
            return this.getStringList(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public boolean getBoolean(String key) throws RuntimeException {
        String value = this.dget(key).convert().intoString();
        switch (value.toLowerCase()) {
            case "true": 
            case "yes": 
            case "on": 
            case "1": {
                return true;
            }
            case "false": 
            case "no": 
            case "off": 
            case "0": {
                return false;
            }
        }
        throw new RuntimeException("Can't convert key " + key + " value \"" + value + "\" to boolean");
    }

    public Optional<Boolean> getOptionalBoolean(String key) {
        try {
            return Optional.of(this.getBoolean(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public boolean getBooleanElse(String key, boolean otherwise) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public List<Boolean> getBooleanList(String key) throws RuntimeException {
        return this.dget(key).convert().intoList();
    }

    public Optional<List<Boolean>> getOptionalBooleanList(String key) {
        try {
            return Optional.ofNullable(this.getBooleanList(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public List<Boolean> getBooleanListElse(String key, List<Boolean> otherwise) {
        try {
            return this.getBooleanList(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public int getInt(String key) throws RuntimeException {
        return this.dget(key).convert().intoInteger();
    }

    public Optional<Integer> getOptionalInt(String key) {
        try {
            return Optional.of(this.getInt(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public int getIntElse(String key, int otherwise) {
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public List<Integer> getIntList(String key) throws RuntimeException {
        return this.dget(key).convert().intoList();
    }

    public Optional<List<Integer>> getOptionalIntList(String key) {
        try {
            return Optional.ofNullable(this.getIntList(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public List<Integer> getIntListElse(String key, List<Integer> otherwise) {
        try {
            return this.getIntList(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public long getLong(String key) throws RuntimeException {
        return this.dget(key).convert().intoLong();
    }

    public Optional<Long> getOptionalLong(String key) {
        try {
            return Optional.of(this.getLong(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public long getLongElse(String key, long otherwise) {
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public List<Long> getLongList(String key) throws RuntimeException {
        return this.dget(key).convert().intoList();
    }

    public Optional<List<Long>> getOptionalLongList(String key) {
        try {
            return Optional.ofNullable(this.getLongList(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public List<Long> getLongListElse(String key, List<Long> otherwise) {
        try {
            return this.getLongList(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public double getDouble(String key) throws RuntimeException {
        return this.dget(key).convert().intoDouble();
    }

    public Optional<Double> getOptionalDouble(String key) {
        try {
            return Optional.of(this.getDouble(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public double getDoubleElse(String key, double otherwise) {
        try {
            return this.getDouble(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public List<Double> getDoubleList(String key) throws RuntimeException {
        return this.dget(key).convert().intoList();
    }

    public Optional<List<Double>> getOptionalDoubleList(String key) {
        try {
            return Optional.ofNullable(this.getDoubleList(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public List<Double> getDoubleListElse(String key, List<Double> otherwise) {
        try {
            return this.getDoubleList(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public BigDecimal getDecimal(String key) throws RuntimeException {
        return this.dget(key).convert().intoDecimal();
    }

    public Optional<BigDecimal> getOptionalDecimal(String key) {
        try {
            return Optional.ofNullable(this.getDecimal(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public BigDecimal getDecimalElse(String key, BigDecimal otherwise) {
        try {
            return this.getDecimal(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public List<BigDecimal> getDecimalList(String key) throws RuntimeException {
        return this.dget(key).convert().intoList();
    }

    public Optional<List<BigDecimal>> getOptionalDecimalList(String key) {
        try {
            return Optional.ofNullable(this.getDecimalList(key));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public List<BigDecimal> getDecimalListElse(String key, List<BigDecimal> otherwise) {
        try {
            return this.getDecimalList(key);
        }
        catch (Exception e) {
            return otherwise;
        }
    }

    public <T> T getSilent(String key) {
        try {
            return (T)this.dget(key).asObject();
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public void getSilent(String key, Consumer<Dynamic> success) {
        this.getSilent(key, success, null);
    }

    public void getSilent(String key, Consumer<Dynamic> success, Consumer<Dynamic> failure) {
        block3: {
            try {
                if (success != null) {
                    success.accept(this.dget(key));
                }
            }
            catch (IllegalArgumentException e) {
                if (failure == null) break block3;
                failure.accept(this.dget(key));
            }
        }
    }

    public void setRuntimeValue(String key, Object value) {
        this.runtimeValues.put(key, value);
    }

    JSONParser getJsonParser() {
        return this.jsonParser != null ? this.jsonParser : (this.jsonParser = new JSONParser());
    }

    Yaml getYamlParser() {
        return this.yamlParser != null ? this.yamlParser : (this.yamlParser = new Yaml());
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Map<Source, Provider> getSources() {
        return this.sources;
    }

    public Provider getProvider(String resource) {
        return this.sources.entrySet().stream().filter(entry -> ((Source)entry.getKey()).getResourceName().equals(resource)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid resource " + resource));
    }
}

