/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.configuralize;

import github.scarsz.configuralize.DynamicConfig;
import github.scarsz.configuralize.ParseException;
import github.scarsz.configuralize.Source;
import github.scarsz.discordsrv.dependencies.alexh.weak.Dynamic;
import github.scarsz.discordsrv.dependencies.commons.io.FileUtils;
import github.scarsz.discordsrv.dependencies.commons.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.yaml.snakeyaml.parser.ParserException;

public class Provider {
    private final DynamicConfig config;
    private final Source source;
    private Dynamic defaults;
    private Dynamic values;

    private static Dynamic load(DynamicConfig config, Source source, String raw) throws ParseException {
        Map parsed;
        block5: {
            if (raw == null) {
                throw new IllegalArgumentException("can't load null config");
            }
            String extension = source.getFile().getName().substring(source.getFile().getName().lastIndexOf(".") + 1);
            try {
                if (extension.equalsIgnoreCase("yml")) {
                    parsed = config.getYamlParser().loadAs(raw, Map.class);
                    break block5;
                }
                if (extension.equalsIgnoreCase("json")) {
                    parsed = (Map)config.getJsonParser().parse(raw);
                    break block5;
                }
                throw new IllegalArgumentException("Config source extension " + extension + " is not supported");
            }
            catch (github.scarsz.discordsrv.dependencies.json.simple.parser.ParseException | ParserException e) {
                throw new ParseException(source, (Throwable)e);
            }
        }
        return Dynamic.from(parsed);
    }

    public Provider(DynamicConfig config, Source source) {
        this.config = config;
        this.source = source;
    }

    public void load() throws IOException, ParseException {
        this.defaults = this.loadResource();
        this.values = this.loadValues();
    }

    public Dynamic loadValues() throws ParseException, IOException {
        return Provider.load(this.config, this.source, FileUtils.readFileToString(this.source.getFile(), "UTF-8"));
    }

    public Dynamic loadResource() throws ParseException, IOException {
        try (InputStream stream = this.source.getResource().openStream();){
            Objects.requireNonNull(stream, "Unknown resource " + this.source.getResourcePath(this.config.getLanguage()));
            Dynamic dynamic = Provider.load(this.config, this.source, IOUtils.toString(stream, StandardCharsets.UTF_8));
            return dynamic;
        }
    }

    public void saveDefaults() throws IOException {
        this.saveDefaults(false);
    }

    public void saveDefaults(boolean overwrite) throws IOException {
        if (this.source.getFile().exists() && !overwrite) {
            return;
        }
        if (!this.source.getFile().getParentFile().exists() && !this.source.getFile().getParentFile().mkdirs()) {
            throw new IOException("Failed to create directory " + this.source.getFile().getParentFile().getAbsolutePath());
        }
        String resource = this.source.getResourcePath(this.config.getLanguage());
        try (InputStream stream = this.source.getResource().openStream();){
            Objects.requireNonNull(stream, "Unknown resource " + this.source.getResourcePath(this.config.getLanguage()));
            FileUtils.copyInputStreamToFile(stream, this.source.getFile());
        }
    }

    public DynamicConfig getConfig() {
        return this.config;
    }

    public Source getSource() {
        return this.source;
    }

    public Dynamic getDefaults() {
        return this.defaults;
    }

    public Dynamic getValues() {
        return this.values;
    }
}

