/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv;

import github.scarsz.discordsrv.DiscordSRV;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public enum Debug {
    MINECRAFT_TO_DISCORD("minecrafttodiscord", "mctodiscord", "todiscord", "minecraft", "minecraftchat"),
    DISCORD_TO_MINECRAFT("discordtominecraft", "discordtomc", "tominecraft", "discord", "discordchat"),
    GROUP_SYNC("group", "groups", "gsync", "role", "roles", "groupsync", "rolesync"),
    PRESENCE("game", "gamestatus", "playing", "playingstatus", "status"),
    VOICE("voicemodule"),
    REQUIRE_LINK("requirelink", "requirelink2play", "requirelinktoplay", "link2play", "linktoplay"),
    NICKNAME_SYNC("nickname", "nicknamesync"),
    ALERTS("alert"),
    WATCHDOG("watchdog"),
    BAN_SYNCHRONIZATION("ban", "bans"),
    LP_CONTEXTS("luckpermscontexts", "luckpermscontext", "lpcontexts", "lpcontext"),
    ACCOUNT_LINKING("linkedaccounts", "accountlinking"),
    CHANNEL_UPDATER("channelupdater", "statschannels"),
    UNCATEGORIZED("all"),
    JDA(new String[0]),
    JDA_REST_ACTIONS("jdarestactions", "jdarest", "restactions", "rest"),
    CALLSTACKS("stack", "stacks", "callstack", "trace", "traces", "stacktrace", "errors", "exceptions", "exception", "except");

    private final String[] aliases;

    private Debug(String ... aliases) {
        this.aliases = aliases;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(String s) {
        if (s.equalsIgnoreCase("all") && this != CALLSTACKS && this != JDA) {
            if (this != JDA_REST_ACTIONS) return true;
        }
        if (s.equalsIgnoreCase("chat")) {
            if (this == MINECRAFT_TO_DISCORD) return true;
            if (this == DISCORD_TO_MINECRAFT) return true;
        }
        if (s.equalsIgnoreCase(this.name())) return true;
        if (!Arrays.stream(this.aliases).anyMatch(s::equalsIgnoreCase)) return false;
        return true;
    }

    public boolean isVisible() {
        Set<String> debuggerCategories = DiscordSRV.getPlugin().getDebuggerCategories();
        if (!debuggerCategories.isEmpty() && debuggerCategories.stream().anyMatch(this::matches)) {
            return true;
        }
        List debug = DiscordSRV.config().getOptionalList("Debug").orElse(Collections.emptyList());
        return debug.stream().filter(obj -> obj instanceof String).map(str -> (String)str).anyMatch(this::matches);
    }

    public static boolean anyEnabled() {
        for (Debug value : Debug.values()) {
            if (!value.isVisible()) continue;
            return true;
        }
        return false;
    }

    public String[] getAliases() {
        return this.aliases;
    }
}

