/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv;

import com.gmail.nossr50.api.ChatAPI;
import github.scarsz.configuralize.DynamicConfig;
import github.scarsz.configuralize.Language;
import github.scarsz.configuralize.ParseException;
import github.scarsz.configuralize.Source;
import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.api.ApiManager;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePostBroadcastEvent;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePreBroadcastEvent;
import github.scarsz.discordsrv.api.events.DiscordReadyEvent;
import github.scarsz.discordsrv.api.events.GameChatMessagePostProcessEvent;
import github.scarsz.discordsrv.api.events.GameChatMessagePreProcessEvent;
import github.scarsz.discordsrv.commands.Command;
import github.scarsz.discordsrv.dependencies.alexh.weak.Dynamic;
import github.scarsz.discordsrv.dependencies.bstats.bukkit.Metrics;
import github.scarsz.discordsrv.dependencies.bstats.charts.AdvancedPie;
import github.scarsz.discordsrv.dependencies.bstats.charts.DrilldownPie;
import github.scarsz.discordsrv.dependencies.bstats.charts.SimplePie;
import github.scarsz.discordsrv.dependencies.bstats.charts.SingleLineChart;
import github.scarsz.discordsrv.dependencies.commons.codec.digest.DigestUtils;
import github.scarsz.discordsrv.dependencies.commons.io.FileUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.exception.ExceptionUtils;
import github.scarsz.discordsrv.dependencies.google.common.collect.ImmutableList;
import github.scarsz.discordsrv.dependencies.google.common.util.concurrent.ThreadFactoryBuilder;
import github.scarsz.discordsrv.dependencies.google.gson.Gson;
import github.scarsz.discordsrv.dependencies.google.gson.GsonBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.EmbedBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.JDA;
import github.scarsz.discordsrv.dependencies.jda.api.JDABuilder;
import github.scarsz.discordsrv.dependencies.jda.api.MessageBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.GuildChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.events.ShutdownEvent;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.ErrorResponseException;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.HierarchyException;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.PermissionException;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.RateLimitedException;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import github.scarsz.discordsrv.dependencies.jda.api.requests.CloseCode;
import github.scarsz.discordsrv.dependencies.jda.api.requests.GatewayIntent;
import github.scarsz.discordsrv.dependencies.jda.api.requests.RestAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.MessageAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.MemberCachePolicy;
import github.scarsz.discordsrv.dependencies.jda.api.utils.cache.CacheFlag;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.TextReplacementConfig;
import github.scarsz.discordsrv.dependencies.minidns.DnsClient;
import github.scarsz.discordsrv.dependencies.minidns.dnsmessage.DnsMessage;
import github.scarsz.discordsrv.dependencies.minidns.record.Record;
import github.scarsz.discordsrv.dependencies.okhttp3.ConnectionPool;
import github.scarsz.discordsrv.dependencies.okhttp3.Credentials;
import github.scarsz.discordsrv.dependencies.okhttp3.Dispatcher;
import github.scarsz.discordsrv.dependencies.okhttp3.Dns;
import github.scarsz.discordsrv.dependencies.okhttp3.OkHttpClient;
import github.scarsz.discordsrv.dependencies.okhttp3.internal.Util;
import github.scarsz.discordsrv.dependencies.okhttp3.internal.tls.OkHostnameVerifier;
import github.scarsz.discordsrv.dependencies.ws.client.DualStackMode;
import github.scarsz.discordsrv.dependencies.ws.client.ProxySettings;
import github.scarsz.discordsrv.dependencies.ws.client.WebSocketFactory;
import github.scarsz.discordsrv.hooks.PlaceholderAPIExpansion;
import github.scarsz.discordsrv.hooks.PluginHook;
import github.scarsz.discordsrv.hooks.VaultHook;
import github.scarsz.discordsrv.hooks.chat.ChatHook;
import github.scarsz.discordsrv.hooks.vanish.VanishHook;
import github.scarsz.discordsrv.hooks.world.WorldHook;
import github.scarsz.discordsrv.listeners.DiscordAccountLinkListener;
import github.scarsz.discordsrv.listeners.DiscordBanListener;
import github.scarsz.discordsrv.listeners.DiscordChatListener;
import github.scarsz.discordsrv.listeners.DiscordConsoleListener;
import github.scarsz.discordsrv.listeners.DiscordDisconnectListener;
import github.scarsz.discordsrv.listeners.ModernPlayerChatListener;
import github.scarsz.discordsrv.listeners.PlayerAchievementsListener;
import github.scarsz.discordsrv.listeners.PlayerAdvancementDoneListener;
import github.scarsz.discordsrv.listeners.PlayerBanListener;
import github.scarsz.discordsrv.listeners.PlayerChatListener;
import github.scarsz.discordsrv.listeners.PlayerDeathListener;
import github.scarsz.discordsrv.listeners.PlayerJoinLeaveListener;
import github.scarsz.discordsrv.modules.alerts.AlertListener;
import github.scarsz.discordsrv.modules.requirelink.RequireLinkModule;
import github.scarsz.discordsrv.modules.voice.VoiceModule;
import github.scarsz.discordsrv.objects.CancellationDetector;
import github.scarsz.discordsrv.objects.Lag;
import github.scarsz.discordsrv.objects.MessageFormat;
import github.scarsz.discordsrv.objects.log4j.JdaFilter;
import github.scarsz.discordsrv.objects.managers.AccountLinkManager;
import github.scarsz.discordsrv.objects.managers.CommandManager;
import github.scarsz.discordsrv.objects.managers.GroupSynchronizationManager;
import github.scarsz.discordsrv.objects.managers.IncompatibleClientManager;
import github.scarsz.discordsrv.objects.managers.link.JdbcAccountLinkManager;
import github.scarsz.discordsrv.objects.managers.link.file.AppendOnlyFileAccountLinkManager;
import github.scarsz.discordsrv.objects.proxy.AlwaysEnabledPluginDynamicProxy;
import github.scarsz.discordsrv.objects.threads.ChannelTopicUpdater;
import github.scarsz.discordsrv.objects.threads.ChannelUpdater;
import github.scarsz.discordsrv.objects.threads.NicknameUpdater;
import github.scarsz.discordsrv.objects.threads.PresenceUpdater;
import github.scarsz.discordsrv.objects.threads.ServerWatchdog;
import github.scarsz.discordsrv.util.ConfigUtil;
import github.scarsz.discordsrv.util.DebugUtil;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.GamePermissionUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageFormatResolver;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.NMSUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.PlayerUtil;
import github.scarsz.discordsrv.util.PluginUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import github.scarsz.discordsrv.util.TimeUtil;
import github.scarsz.discordsrv.util.UpdateUtil;
import github.scarsz.discordsrv.util.WebhookUtil;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.security.auth.login.LoginException;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.scarsz.jdaappender.ChannelLoggingHandler;
import me.scarsz.jdaappender.LogItem;
import me.scarsz.jdaappender.LogLevel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.filter.Filterable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitWorker;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;

public class DiscordSRV
extends JavaPlugin {
    public static final ApiManager api = new ApiManager();
    public static boolean isReady = false;
    public static boolean shuttingDown = false;
    public static boolean updateChecked = false;
    public static boolean invalidBotToken = false;
    private static boolean offlineUuidAvatarUrlNagged = false;
    public static boolean updateIsAvailable = false;
    public static String version = "";
    private AccountLinkManager accountLinkManager;
    private CommandManager commandManager = new CommandManager();
    private GroupSynchronizationManager groupSynchronizationManager = new GroupSynchronizationManager();
    private IncompatibleClientManager incompatibleClientManager = new IncompatibleClientManager();
    private ChannelTopicUpdater channelTopicUpdater;
    private ChannelUpdater channelUpdater;
    private NicknameUpdater nicknameUpdater;
    private PresenceUpdater presenceUpdater;
    private ServerWatchdog serverWatchdog;
    private ScheduledExecutorService updateChecker = null;
    private AlertListener alertListener = null;
    private RequireLinkModule requireLinkModule;
    private VoiceModule voiceModule;
    private final Map<String, String> channels = new LinkedHashMap<String, String>();
    private final Map<String, String> roleAliases = new LinkedHashMap<String, String>();
    private final Map<Pattern, String> consoleRegexes = new LinkedHashMap<Pattern, String>();
    private final Map<Pattern, String> gameRegexes = new LinkedHashMap<Pattern, String>();
    private final Map<Pattern, String> discordRegexes = new LinkedHashMap<Pattern, String>();
    private final Map<Pattern, String> webhookUsernameRegexes = new LinkedHashMap<Pattern, String>();
    private final DynamicConfig config;
    private final Set<String> debuggerCategories = new CopyOnWriteArraySet<String>();
    private final long startTime = System.currentTimeMillis();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private CancellationDetector<AsyncPlayerChatEvent> legacyCancellationDetector = null;
    private CancellationDetector<?> modernCancellationDetector = null;
    private boolean modernChatEventAvailable = false;
    private final Set<PluginHook> pluginHooks = new HashSet<PluginHook>();
    private final File configFile = new File(this.getDataFolder(), "config.yml");
    private final File messagesFile = new File(this.getDataFolder(), "messages.yml");
    private final File voiceFile = new File(this.getDataFolder(), "voice.yml");
    private final File linkingFile = new File(this.getDataFolder(), "linking.yml");
    private final File synchronizationFile = new File(this.getDataFolder(), "synchronization.yml");
    private final File alertsFile = new File(this.getDataFolder(), "alerts.yml");
    private final File debugFolder = new File(this.getDataFolder(), "debug");
    private final File logFolder = new File(this.getDataFolder(), "discord-console-logs");
    private JDA jda = null;
    private ExecutorService callbackThreadPool;
    private ChannelLoggingHandler consoleAppender;
    private JdaFilter jdaFilter;
    private static File playerDataFolder = null;

    public static DiscordSRV getPlugin() {
        return (DiscordSRV)DiscordSRV.getPlugin(DiscordSRV.class);
    }

    public static DynamicConfig config() {
        return DiscordSRV.getPlugin().config;
    }

    public void reloadConfig() {
        try {
            DiscordSRV.config().loadAll();
        }
        catch (ParseException | IOException e) {
            throw new RuntimeException("Failed to load config", e);
        }
    }

    public void reloadAllowedMentions() {
        MessageAction.setDefaultMentions(DiscordSRV.config().getStringList("DiscordChatChannelAllowedMentions").stream().map(s -> {
            try {
                return Message.MentionType.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                DiscordSRV.error("Unknown mention type \"" + s + "\" defined in DiscordChatChannelAllowedMentions");
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet()));
        DiscordSRV.debug("Allowed chat mention types: " + MessageAction.getDefaultMentions().stream().map(Enum::name).collect(Collectors.joining(", ")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadChannels() {
        Map<String, String> map = this.channels;
        synchronized (map) {
            this.channels.clear();
            DiscordSRV.config().dget("Channels").children().forEach(dynamic -> this.channels.put(dynamic.key().convert().intoString(), dynamic.convert().intoString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadRoleAliases() {
        Map<String, String> map = this.roleAliases;
        synchronized (map) {
            this.roleAliases.clear();
            DiscordSRV.config().dget("DiscordChatChannelRoleAliases").children().forEach(dynamic -> this.roleAliases.put(dynamic.key().convert().intoString().toLowerCase(), dynamic.convert().intoString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadRegexes() {
        Map<Pattern, String> map = this.consoleRegexes;
        synchronized (map) {
            this.consoleRegexes.clear();
            this.loadRegexesFromConfig(DiscordSRV.config().dget("DiscordConsoleChannelFilters"), this.consoleRegexes);
        }
        map = this.gameRegexes;
        synchronized (map) {
            this.gameRegexes.clear();
            this.loadRegexesFromConfig(DiscordSRV.config().dget("DiscordChatChannelGameFilters"), this.gameRegexes);
        }
        map = this.discordRegexes;
        synchronized (map) {
            this.discordRegexes.clear();
            this.loadRegexesFromConfig(DiscordSRV.config().dget("DiscordChatChannelDiscordFilters"), this.discordRegexes);
        }
        map = this.webhookUsernameRegexes;
        synchronized (map) {
            this.webhookUsernameRegexes.clear();
            this.loadRegexesFromConfig(DiscordSRV.config().dget("Experiment_WebhookChatMessageUsernameFilters"), this.webhookUsernameRegexes);
        }
    }

    private void loadRegexesFromConfig(Dynamic dynamic, Map<Pattern, String> map) {
        dynamic.children().forEach(d -> {
            String key = d.key().convert().intoString();
            if (StringUtils.isEmpty(key)) {
                return;
            }
            try {
                Pattern pattern = Pattern.compile(key, 32);
                map.put(pattern, d.convert().intoString());
            }
            catch (PatternSyntaxException e) {
                DiscordSRV.error("Invalid regex pattern: " + key + " (" + e.getDescription() + ")");
            }
        });
    }

    public String getMainChatChannel() {
        return this.channels.size() != 0 ? this.channels.keySet().iterator().next() : null;
    }

    public TextChannel getMainTextChannel() {
        if (this.channels.isEmpty() || this.jda == null) {
            return null;
        }
        String firstChannel = this.channels.values().iterator().next();
        if (StringUtils.isBlank(firstChannel)) {
            return null;
        }
        return DiscordUtil.getTextChannelById(firstChannel);
    }

    public Guild getMainGuild() {
        if (this.jda == null) {
            return null;
        }
        return this.getMainTextChannel() != null ? this.getMainTextChannel().getGuild() : (this.getConsoleChannel() != null ? this.getConsoleChannel().getGuild() : (this.jda.getGuilds().size() > 0 ? this.jda.getGuilds().get(0) : null));
    }

    public TextChannel getConsoleChannel() {
        if (this.jda == null) {
            return null;
        }
        String consoleChannel = this.config.getString("DiscordConsoleChannelId");
        return StringUtils.isNotBlank(consoleChannel) && StringUtils.isNumeric(consoleChannel) ? DiscordUtil.getTextChannelById(consoleChannel) : null;
    }

    public TextChannel getDestinationTextChannelForGameChannelName(String gameChannelName) {
        String value;
        Map.Entry entry = this.channels.entrySet().stream().filter(e -> ((String)e.getKey()).equals(gameChannelName)).findFirst().orElse(null);
        String string = value = entry != null ? (String)entry.getValue() : null;
        if (!StringUtils.isBlank(value)) {
            return this.jda.getTextChannelById(value);
        }
        entry = this.channels.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(gameChannelName)).findFirst().orElse(null);
        String string2 = value = entry != null ? (String)entry.getValue() : null;
        if (!StringUtils.isBlank(value)) {
            return this.jda.getTextChannelById(value);
        }
        return null;
    }

    public String getDestinationGameChannelNameForTextChannel(TextChannel source) {
        if (source == null) {
            return null;
        }
        return this.channels.entrySet().stream().filter(entry -> source.getId().equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public File getLogFile() {
        String fileName = DiscordSRV.config().getString("DiscordConsoleChannelUsageLog");
        if (StringUtils.isBlank(fileName)) {
            return null;
        }
        fileName = fileName.replace("%date%", TimeUtil.date());
        return new File(this.getLogFolder(), fileName);
    }

    public static void logThrowable(Throwable throwable, Consumer<String> logger) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        for (String line : stringWriter.toString().split("\n")) {
            logger.accept(line);
        }
    }

    public static void info(LangUtil.InternalMessage message) {
        DiscordSRV.info(message.toString());
    }

    public static void info(String message) {
        DiscordSRV.getPlugin().getLogger().info(message);
    }

    public static void warning(LangUtil.InternalMessage message) {
        DiscordSRV.warning(message.toString());
    }

    public static void warning(String message) {
        DiscordSRV.getPlugin().getLogger().warning(message);
    }

    public static void error(LangUtil.InternalMessage message) {
        DiscordSRV.error(message.toString());
    }

    public static void error(String message) {
        DiscordSRV.getPlugin().getLogger().severe(message);
    }

    public static void error(Throwable throwable) {
        DiscordSRV.logThrowable(throwable, DiscordSRV::error);
    }

    public static void error(String message, Throwable throwable) {
        DiscordSRV.error(message);
        DiscordSRV.error(throwable);
    }

    public static void debug(String message) {
        DiscordSRV.debug(Debug.UNCATEGORIZED, message);
    }

    public static void debug(Debug type, String message) {
        if (type.isVisible()) {
            DiscordSRV.getPlugin().getLogger().info("[" + type.name() + " DEBUG] " + message + (Debug.CALLSTACKS.isVisible() ? "\n" + DebugUtil.getStackTrace() : ""));
        }
    }

    public static void debug(Throwable throwable) {
        DiscordSRV.debug(Debug.UNCATEGORIZED, throwable);
    }

    public static void debug(Debug type, Throwable throwable) {
        DiscordSRV.logThrowable(throwable, DiscordSRV::debug);
    }

    public static void debug(Throwable throwable, String message) {
        DiscordSRV.debug(Debug.UNCATEGORIZED, throwable, message);
    }

    public static void debug(Debug type, Throwable throwable, String message) {
        DiscordSRV.debug(throwable);
        DiscordSRV.debug(message);
    }

    public static void debug(Collection<String> message) {
        message.forEach(DiscordSRV::debug);
    }

    public static void debug(Debug type, Collection<String> message) {
        message.forEach(msg -> DiscordSRV.debug(type, msg));
    }

    public DiscordSRV() {
        this.getDataFolder().mkdirs();
        this.config = new DynamicConfig(new Source[0]);
        this.config.addSource(DiscordSRV.class, "config", this.getConfigFile());
        this.config.addSource(DiscordSRV.class, "messages", this.getMessagesFile());
        this.config.addSource(DiscordSRV.class, "voice", this.getVoiceFile());
        this.config.addSource(DiscordSRV.class, "linking", this.getLinkingFile());
        this.config.addSource(DiscordSRV.class, "synchronization", this.getSynchronizationFile());
        this.config.addSource(DiscordSRV.class, "alerts", this.getAlertsFile());
        String languageCode = System.getProperty("user.language").toUpperCase();
        Language language = null;
        try {
            Language lang2 = Language.valueOf(languageCode);
            if (!this.config.isLanguageAvailable(lang2)) {
                throw new IllegalArgumentException();
            }
            language = lang2;
        }
        catch (IllegalArgumentException e) {
            String lang3 = language != null ? language.getName() : languageCode.toUpperCase();
            this.getLogger().info("Unknown user language " + lang3 + ".");
            this.getLogger().info("If you fluently speak " + lang3 + " as well as English, see the GitHub repo to translate it!");
        }
        if (language == null) {
            language = Language.EN;
        }
        this.config.setLanguage(language);
        try {
            this.config.saveAllDefaults();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save default config files", e);
        }
        try {
            this.config.loadAll();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load config", e);
        }
        String forcedLanguage = this.config.getString("ForcedLanguage");
        if (StringUtils.isNotBlank(forcedLanguage) && !forcedLanguage.equalsIgnoreCase("none")) {
            Arrays.stream(Language.values()).filter(lang -> lang.getCode().equalsIgnoreCase(forcedLanguage) || lang.getName().equalsIgnoreCase(forcedLanguage)).findFirst().ifPresent(this.config::setLanguage);
        }
        try {
            PluginDescriptionFile description = this.getDescription();
            Class<?> descriptionClass = description.getClass();
            ArrayList<org.bukkit.permissions.Permission> permissions = new ArrayList<org.bukkit.permissions.Permission>(description.getPermissions());
            for (String s : this.getGroupSynchronizables().keySet()) {
                permissions.add(new org.bukkit.permissions.Permission("discordsrv.sync." + s, null, PermissionDefault.FALSE));
                permissions.add(new org.bukkit.permissions.Permission("discordsrv.sync.deny." + s, null, PermissionDefault.FALSE));
            }
            Field permissionsField = descriptionClass.getDeclaredField("permissions");
            permissionsField.setAccessible(true);
            permissionsField.set(description, ImmutableList.copyOf(permissions));
            Class<?> pluginClass = ((Object)((Object)this)).getClass().getSuperclass();
            Field descriptionField = pluginClass.getDeclaredField("description");
            descriptionField.setAccessible(true);
            descriptionField.set((Object)this, description);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEnable() {
        if (++DebugUtil.initializationCount > 1) {
            DiscordSRV.error(ChatColor.RED + LangUtil.InternalMessage.PLUGIN_RELOADED.toString());
            PlayerUtil.getOnlinePlayers().stream().filter(player -> player.hasPermission("discordsrv.admin")).forEach(player -> MessageUtil.sendMessage((CommandSender)player, ChatColor.RED + LangUtil.InternalMessage.PLUGIN_RELOADED.toString()));
        }
        ConfigUtil.migrate();
        ConfigUtil.logMissingOptions();
        DiscordSRV.debug("Language is " + this.config.getLanguage().getName());
        version = this.getDescription().getVersion();
        Thread initThread = new Thread(this::init, "DiscordSRV - Initialization");
        initThread.setUncaughtExceptionHandler((t, e) -> {
            this.disablePlugin();
            DiscordSRV.error(e);
            this.getLogger().severe("DiscordSRV failed to load properly: " + e.getMessage() + ". See " + DebugUtil.run("DiscordSRV") + " for more information. Can't figure it out? Go to https://discordsrv.com/discord for help");
        });
        initThread.start();
        if (Bukkit.getWorlds().size() > 0) {
            playerDataFolder = new File(((World)Bukkit.getWorlds().get(0)).getWorldFolder().getAbsolutePath(), "/playerdata");
        }
    }

    public void disablePlugin() {
        SchedulerUtil.runTask((Plugin)this, () -> Bukkit.getPluginManager().disablePlugin((Plugin)this));
        PluginCommand pluginCommand = this.getCommand("discordsrv");
        if (pluginCommand != null && pluginCommand.getPlugin() == this) {
            try {
                Field owningPlugin = pluginCommand.getClass().getDeclaredField("owningPlugin");
                if (!owningPlugin.isAccessible()) {
                    owningPlugin.setAccessible(true);
                }
                owningPlugin.set(pluginCommand, new AlwaysEnabledPluginDynamicProxy().getProxy((Plugin)this));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void init() {
        File metricsFile;
        block105: {
            String token;
            if (Bukkit.getPluginManager().isPluginEnabled("PlugMan")) {
                Plugin plugMan = Bukkit.getPluginManager().getPlugin("PlugMan");
                try {
                    List ignoredPlugins = (List)plugMan.getClass().getMethod("getIgnoredPlugins", new Class[0]).invoke((Object)plugMan, new Object[0]);
                    if (!ignoredPlugins.contains("DiscordSRV")) {
                        ignoredPlugins.add("DiscordSRV");
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignoredPlugins) {
                    // empty catch block
                }
            }
            try {
                File specialSourceFile = new File("libraries/net/md-5/SpecialSource/1.7-SNAPSHOT/SpecialSource-1.7-SNAPSHOT.jar");
                if (!specialSourceFile.exists()) {
                    specialSourceFile = new File("bin/net/md-5/SpecialSource/1.7-SNAPSHOT/SpecialSource-1.7-SNAPSHOT.jar");
                }
                if (specialSourceFile.exists() && DigestUtils.md5Hex(FileUtils.readFileToByteArray(specialSourceFile)).equalsIgnoreCase("096777a1b6098130d6c925f1c04050a3")) {
                    DiscordSRV.warning(LangUtil.InternalMessage.ASM_WARNING.toString().replace("{specialsourcefolder}", specialSourceFile.getParentFile().getPath()));
                }
            }
            catch (IOException e) {
                DiscordSRV.error(e);
            }
            this.requireLinkModule = new RequireLinkModule();
            if (!DiscordSRV.isUpdateCheckDisabled()) {
                if (this.updateChecker == null) {
                    ThreadFactory gatewayThreadFactory = new ThreadFactoryBuilder().setNameFormat("DiscordSRV - Update Checker").build();
                    this.updateChecker = Executors.newScheduledThreadPool(1);
                }
                this.updateChecker.schedule(() -> {
                    updateIsAvailable = UpdateUtil.checkForUpdates();
                    updateChecked = true;
                }, 0L, TimeUnit.SECONDS);
                this.updateChecker.scheduleAtFixedRate(() -> {
                    updateIsAvailable = UpdateUtil.checkForUpdates(false);
                }, 6L, 6L, TimeUnit.HOURS);
            }
            if (this.jda != null) {
                try {
                    this.jda.shutdown();
                    this.jda = null;
                }
                catch (Exception e) {
                    DiscordSRV.error(e);
                }
            }
            this.reloadAllowedMentions();
            if (ProxySelector.getDefault() == null) {
                ProxySelector.setDefault(new ProxySelector(){
                    private final List<Proxy> DIRECT_CONNECTION = Collections.unmodifiableList(Collections.singletonList(Proxy.NO_PROXY));

                    @Override
                    public void connectFailed(URI arg0, SocketAddress arg1, IOException arg2) {
                    }

                    @Override
                    public List<Proxy> select(URI uri) {
                        return this.DIRECT_CONNECTION;
                    }
                });
            }
            if (DiscordSRV.config().getBoolean("ForceTLSv12")) {
                try {
                    SSLContext context = SSLContext.getInstance("TLSv1.2");
                    context.init(null, null, null);
                    SSLContext.setDefault(context);
                }
                catch (Exception context) {
                    // empty catch block
                }
            }
            boolean serverIsLog4jCapable = false;
            boolean serverIsLog4j21Capable = false;
            try {
                serverIsLog4jCapable = Class.forName("org.apache.logging.log4j.core.Logger") != null;
            }
            catch (ClassNotFoundException e) {
                DiscordSRV.error("Log4j classes are NOT available, console channel will not be attached");
            }
            try {
                serverIsLog4j21Capable = Class.forName("org.apache.logging.log4j.core.Filter") != null;
            }
            catch (ClassNotFoundException e) {
                DiscordSRV.error("Log4j 2.1 classes are NOT available, JDA messages will NOT be formatted properly");
            }
            if (serverIsLog4j21Capable && this.jdaFilter == null) {
                try {
                    Class<?> jdaFilterClass = Class.forName("github.scarsz.discordsrv.objects.log4j.JdaFilter");
                    this.jdaFilter = (JdaFilter)jdaFilterClass.newInstance();
                    ((Logger)LogManager.getRootLogger()).addFilter((Filter)this.jdaFilter);
                    DiscordSRV.debug("JdaFilter applied");
                }
                catch (Exception e) {
                    DiscordSRV.error("Failed to attach JDA message filter to root logger", e);
                }
            }
            if (Debug.JDA.isVisible()) {
                LoggerContext config2 = (LoggerContext)LogManager.getContext((boolean)false);
                config2.getConfiguration().getLoggerConfig("").setLevel(Level.ALL);
                config2.updateLoggers();
            }
            if (Debug.JDA_REST_ACTIONS.isVisible()) {
                RestAction.setPassContext(true);
            }
            Dns dns = Dns.SYSTEM;
            try {
                final CopyOnWriteArrayList<InetAddress> fallbackDnsServers = new CopyOnWriteArrayList<InetAddress>(Arrays.asList(InetAddress.getByName("1.1.1.1"), InetAddress.getByName("1.0.0.1"), InetAddress.getByName("8.8.8.8"), InetAddress.getByName("8.8.4.4")));
                dns = new Dns(){
                    private final DnsClient client = new DnsClient();
                    private int failedRequests = 0;

                    @Override
                    @NotNull
                    public List<InetAddress> lookup(@NotNull String host) throws UnknownHostException {
                        block4: {
                            int max = DiscordSRV.this.config.getInt("MaximumAttemptsForSystemDNSBeforeUsingFallbackDNS");
                            if (max < 0 || max > 0 && this.failedRequests < max) {
                                try {
                                    List<InetAddress> result = Dns.SYSTEM.lookup(host);
                                    this.failedRequests = 0;
                                    return result;
                                }
                                catch (Exception e) {
                                    ++this.failedRequests;
                                    DiscordSRV.error("System DNS FAILED to resolve hostname " + host + ", " + (max == 0 ? "" : (this.failedRequests >= max ? "using fallback DNS for this request" : "switching to fallback DNS servers")) + "!");
                                    if (max != 0) break block4;
                                    if (e instanceof UnknownHostException) {
                                        throw e;
                                    }
                                    return null;
                                }
                            }
                        }
                        return this.lookupPublic(host);
                    }

                    private List<InetAddress> lookupPublic(String host) throws UnknownHostException {
                        for (InetAddress dnsServer : fallbackDnsServers) {
                            try {
                                List<InetAddress> resolved;
                                DnsMessage query = this.client.query((String)host, (Record.TYPE)Record.TYPE.A, (Record.CLASS)Record.CLASS.IN, (InetAddress)dnsServer).response;
                                if (query.responseCode != DnsMessage.RESPONSE_CODE.NO_ERROR) {
                                    DiscordSRV.error("DNS server " + dnsServer.getHostAddress() + " failed our DNS query for " + host + ": " + query.responseCode.name());
                                }
                                if ((resolved = query.answerSection.stream().map(record -> record.payloadData.toString()).map(s -> {
                                    try {
                                        return InetAddress.getByName(s);
                                    }
                                    catch (UnknownHostException e) {
                                        DiscordSRV.error(e);
                                        return null;
                                    }
                                }).filter(Objects::nonNull).distinct().collect(Collectors.toList())).size() > 0) {
                                    return resolved;
                                }
                                DiscordSRV.error("DNS server " + dnsServer.getHostAddress() + " failed to resolve " + host + ": no results");
                            }
                            catch (Exception e) {
                                DiscordSRV.error("DNS server " + dnsServer.getHostAddress() + " failed to resolve " + host, e);
                            }
                            fallbackDnsServers.remove(dnsServer);
                            fallbackDnsServers.add(dnsServer);
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        UnknownHostException exception = new UnknownHostException("All DNS resolvers failed to resolve hostname " + host + ". Not good.");
                        exception.setStackTrace(new StackTraceElement[]{exception.getStackTrace()[0]});
                        throw exception;
                    }
                };
            }
            catch (Exception e) {
                DiscordSRV.error("Failed to make custom DNS client", e);
            }
            Optional<Boolean> noopHostnameVerifier = DiscordSRV.config().getOptionalBoolean("NoopHostnameVerifier");
            Dispatcher dispatcher = new Dispatcher(new ThreadPoolExecutor(2, 20, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp Dispatcher", false)));
            dispatcher.setMaxRequests(20);
            dispatcher.setMaxRequestsPerHost(20);
            ConnectionPool connectionPool = new ConnectionPool(5, 10L, TimeUnit.SECONDS);
            String proxyHost = this.config.getString("ProxyHost");
            int proxyPort = this.config.getInt("ProxyPort");
            String authUser = this.config.getString("ProxyUser");
            String authPassword = this.config.getString("ProxyPassword");
            WebSocketFactory websocketFactory = new WebSocketFactory().setDualStackMode(DualStackMode.IPV4_ONLY);
            OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().dispatcher(dispatcher).connectionPool(connectionPool).dns(dns).connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).hostnameVerifier(noopHostnameVerifier.isPresent() && noopHostnameVerifier.get() != false ? (hostname, sslSession) -> true : OkHostnameVerifier.INSTANCE);
            if (!proxyHost.isEmpty() && !proxyHost.equals("example.com")) {
                try {
                    System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost.trim(), proxyPort));
                    httpClientBuilder = httpClientBuilder.proxy(proxy);
                    ProxySettings proxySettings = websocketFactory.getProxySettings();
                    proxySettings.setHost(proxyHost.trim());
                    proxySettings.setPort(proxyPort);
                    if (!authPassword.isEmpty()) {
                        String trimmedUsername = authUser.trim();
                        String trimmedPassword = authPassword.trim();
                        httpClientBuilder = httpClientBuilder.proxyAuthenticator((route, response) -> {
                            String credential = Credentials.basic(trimmedUsername, trimmedPassword);
                            return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                        });
                        proxySettings.setCredentials(trimmedUsername, trimmedPassword);
                    }
                }
                catch (Exception e) {
                    DiscordSRV.error("Failed to generate a proxy from config options.", e);
                }
            }
            OkHttpClient httpClient = httpClientBuilder.build();
            Consumer<Throwable> defaultFailure = RestAction.getDefaultFailure();
            RestAction.setDefaultFailure(throwable -> {
                Throwable cause;
                if (shuttingDown) {
                    for (Throwable t = throwable; t != null; t = t.getCause()) {
                        if (!(t instanceof InterruptedException) && !(t instanceof InterruptedIOException)) continue;
                        return;
                    }
                }
                if (throwable instanceof HierarchyException) {
                    DiscordSRV.error("DiscordSRV failed to perform an action due to being lower in hierarchy than the action's target: " + throwable.getMessage());
                } else if (throwable instanceof PermissionException) {
                    DiscordSRV.error("DiscordSRV failed to perform an action because the bot is missing the " + ((PermissionException)throwable).getPermission().name() + " permission: " + throwable.getMessage());
                } else if (throwable instanceof RateLimitedException) {
                    DiscordSRV.error("DiscordSRV encountered rate limiting. If you are running multiple DiscordSRV instances on the same token, this is considered API abuse and risks your server being IP banned from Discord. Make one bot per server.");
                } else if (throwable instanceof ErrorResponseException) {
                    JDA.Status status;
                    if (((ErrorResponseException)throwable).getErrorCode() == 50013) {
                        DiscordSRV.error("DiscordSRV received a permission error response (50013) from Discord. Unfortunately the specific error isn't provided in that response.");
                        DiscordSRV.debug(Debug.JDA_REST_ACTIONS, throwable.getCause());
                        return;
                    }
                    cause = throwable.getCause();
                    if (cause instanceof InterruptedIOException && this.jda != null && ((status = this.jda.getStatus()) == JDA.Status.SHUTDOWN || status == JDA.Status.SHUTTING_DOWN)) {
                        return;
                    }
                    DiscordSRV.error("DiscordSRV encountered an unknown Discord error: " + throwable.getMessage());
                } else {
                    DiscordSRV.error("DiscordSRV encountered an unknown exception: " + throwable.getMessage() + "\n" + ExceptionUtils.getStackTrace(throwable));
                }
                if (Debug.JDA_REST_ACTIONS.isVisible()) {
                    cause = throwable.getCause();
                    DiscordSRV.error(cause);
                }
            });
            File tokenFile = new File(this.getDataFolder(), ".token");
            if (StringUtils.isNotBlank(System.getProperty("DISCORDSRV_TOKEN"))) {
                token = System.getProperty("DISCORDSRV_TOKEN");
                DiscordSRV.debug("Using bot token supplied from JVM property DISCORDSRV_TOKEN");
            } else if (StringUtils.isNotBlank(System.getenv("DISCORDSRV_TOKEN"))) {
                token = System.getenv("DISCORDSRV_TOKEN");
                DiscordSRV.debug("Using bot token supplied from environment variable DISCORDSRV_TOKEN");
            } else if (tokenFile.exists()) {
                try {
                    token = FileUtils.readFileToString(tokenFile, StandardCharsets.UTF_8);
                    DiscordSRV.debug("Using bot token supplied from " + tokenFile.getPath());
                }
                catch (IOException e) {
                    DiscordSRV.error(".token file could not be read: " + e.getMessage());
                    token = null;
                }
            } else {
                token = this.config.getString("BotToken");
                DiscordSRV.debug("Using bot token supplied from config");
            }
            if (StringUtils.isBlank(token) || "BOTTOKEN".equalsIgnoreCase(token)) {
                this.disablePlugin();
                DiscordSRV.error("No bot token has been set in the config; a bot token is required to connect to Discord.");
                invalidBotToken = true;
                return;
            }
            if (token.length() < 59) {
                this.disablePlugin();
                DiscordSRV.error("An invalid length bot token (" + token.length() + ") has been set in the config; a valid bot token is required to connect to Discord." + (token.length() == 32 ? " Did you copy the \"Client Secret\" instead of the \"Bot Token\" into the config?" : ""));
                invalidBotToken = true;
                return;
            }
            token = token.replaceAll("[^\\w\\d-_.]", "");
            this.callbackThreadPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), pool -> {
                ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName("DiscordSRV - JDA Callback " + worker.getPoolIndex());
                return worker;
            }, null, true);
            ThreadFactory gatewayThreadFactory = new ThreadFactoryBuilder().setNameFormat("DiscordSRV - JDA Gateway").build();
            ScheduledExecutorService gatewayThreadPool = Executors.newSingleThreadScheduledExecutor(gatewayThreadFactory);
            ThreadFactory rateLimitThreadFactory = new ThreadFactoryBuilder().setNameFormat("DiscordSRV - JDA Rate Limit").build();
            ScheduledThreadPoolExecutor rateLimitThreadPool = new ScheduledThreadPoolExecutor(5, rateLimitThreadFactory);
            if (this.config.getBooleanElse("EnablePresenceInformation", false)) {
                api.requireIntent(GatewayIntent.GUILD_PRESENCES);
                api.requireCacheFlag(CacheFlag.ACTIVITY);
                api.requireCacheFlag(CacheFlag.CLIENT_STATUS);
            }
            try {
                this.jda = JDABuilder.create(api.getIntents()).disableCache(Arrays.stream(CacheFlag.values()).filter(cacheFlag -> !api.getCacheFlags().contains(cacheFlag)).collect(Collectors.toList())).setMemberCachePolicy(MemberCachePolicy.ALL).setCallbackPool(this.callbackThreadPool, false).setGatewayPool(gatewayThreadPool, true).setRateLimitPool(rateLimitThreadPool, true).setWebsocketFactory(websocketFactory).setHttpClient(httpClient).setAutoReconnect(true).setBulkDeleteSplittingEnabled(false).setEnableShutdownHook(false).setToken(token).addEventListeners(new DiscordBanListener()).addEventListeners(new DiscordChatListener()).addEventListeners(new DiscordConsoleListener()).addEventListeners(new DiscordAccountLinkListener()).addEventListeners(new DiscordDisconnectListener()).addEventListeners(api).addEventListeners(this.groupSynchronizationManager).setContextEnabled(false).build();
                this.jda.awaitReady();
                for (Guild guild : this.jda.getGuilds()) {
                    guild.retrieveOwner(true).queue();
                    guild.loadMembers().onSuccess(members -> DiscordSRV.debug("Loaded " + members.size() + " members in guild " + guild)).onError(throwable -> DiscordSRV.error("Failed to retrieve members of guild " + guild, throwable)).get();
                }
            }
            catch (LoginException e) {
                this.disablePlugin();
                if (e.getMessage().toLowerCase().contains("the provided token is invalid")) {
                    invalidBotToken = true;
                    DiscordDisconnectListener.printDisconnectMessage(true, "The bot token is invalid");
                } else {
                    DiscordDisconnectListener.printDisconnectMessage(true, e.getMessage());
                }
                return;
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException && e.getMessage().equals("Was shutdown trying to await status")) {
                    return;
                }
                DiscordSRV.error("An unknown error occurred building JDA...", e);
                return;
            }
            if (this.presenceUpdater != null) {
                if (this.presenceUpdater.getState() != Thread.State.NEW) {
                    this.presenceUpdater.interrupt();
                    this.presenceUpdater = new PresenceUpdater();
                }
                SchedulerUtil.runTaskLater((Plugin)this, () -> this.presenceUpdater.start(), 100L);
            } else {
                this.presenceUpdater = new PresenceUpdater();
                this.presenceUpdater.start();
            }
            if (this.nicknameUpdater != null) {
                if (this.nicknameUpdater.getState() != Thread.State.NEW) {
                    this.nicknameUpdater.interrupt();
                    this.nicknameUpdater = new NicknameUpdater();
                }
                SchedulerUtil.runTaskLater((Plugin)this, () -> this.nicknameUpdater.start(), 100L);
            } else {
                this.nicknameUpdater = new NicknameUpdater();
                this.nicknameUpdater.start();
            }
            if (this.jda.getGuilds().size() == 0) {
                DiscordSRV.error(LangUtil.InternalMessage.BOT_NOT_IN_ANY_SERVERS);
                DiscordSRV.error(this.jda.getInviteUrl(Permission.ADMINISTRATOR));
                return;
            }
            if (serverIsLog4jCapable) {
                TextChannel consoleChannel = this.getConsoleChannel();
                if (consoleChannel != null) {
                    DiscordSRV.info((Object)((Object)LangUtil.InternalMessage.CONSOLE_FORWARDING_ASSIGNED_TO_CHANNEL) + " " + consoleChannel);
                    this.consoleAppender = new ChannelLoggingHandler(() -> {
                        TextChannel textChannel = DiscordSRV.getPlugin().getConsoleChannel();
                        return textChannel != null && textChannel.getGuild().getSelfMember().hasPermission((GuildChannel)textChannel, Permission.MESSAGE_READ, Permission.MESSAGE_WRITE) ? textChannel : null;
                    }, config -> {
                        config.setUseCodeBlocks(DiscordSRV.config().getBooleanElse("DiscordConsoleChannelUseCodeBlocks", true));
                        config.setLoggerNamePadding(DiscordSRV.config().getIntElse("DiscordConsoleChannelPadding", 0));
                        Set configuredLevels = DiscordSRV.config().getStringList("DiscordConsoleChannelLevels").stream().map(value -> value.toUpperCase(Locale.ROOT)).map(s -> {
                            try {
                                return LogLevel.valueOf(s);
                            }
                            catch (IllegalArgumentException e) {
                                DiscordSRV.error("Invalid console logging level '" + s + "', valid options are " + Arrays.stream(LogLevel.values()).map(Enum::name).collect(Collectors.joining(", ")));
                                return null;
                            }
                        }).filter(Objects::nonNull).collect(Collectors.toSet());
                        config.setLogLevels(!configuredLevels.isEmpty() ? EnumSet.copyOf(configuredLevels) : EnumSet.noneOf(LogLevel.class));
                        config.mapLoggerName("net.minecraft.server.MinecraftServer", "Server");
                        config.mapLoggerNameFriendly("net.minecraft.server", s -> "Server/" + s);
                        config.mapLoggerNameFriendly("net.minecraft", s -> "Minecraft/" + s);
                        config.mapLoggerName("github.scarsz.discordsrv.dependencies.jda", s -> "DiscordSRV/JDA/" + s);
                        config.addTransformer(logItem -> true, s -> MessageUtil.strip(DiscordUtil.aggressiveStrip(s)));
                        config.addTransformer(logItem -> true, line -> {
                            for (Map.Entry<Pattern, String> entry : this.consoleRegexes.entrySet()) {
                                line = entry.getKey().matcher((CharSequence)line).replaceAll(entry.getValue());
                                if (!StringUtils.isBlank(line)) continue;
                                return null;
                            }
                            return line;
                        });
                        BiFunction<String, LogItem, String> placeholders = (key, item) -> {
                            String name = config.padLoggerName(config.resolveLoggerName(item.getLogger()));
                            String timestamp = TimeUtil.consoleTimeStamp(item.getTimestamp());
                            String value = DiscordSRV.config().getString((String)key);
                            if (StringUtils.isBlank(value)) {
                                return "";
                            }
                            return PlaceholderUtil.replacePlaceholdersToDiscord(value).replace("{date}", timestamp).replace("{datetime}", timestamp).replace("{name}", StringUtils.isNotBlank(name) ? " " + name : "").replace("{level}", config.padLevelName(item.getLevel().name()));
                        };
                        config.setPrefixer(item -> (String)placeholders.apply("DiscordConsoleChannelPrefix", (LogItem)item));
                        config.setSuffixer(item -> (String)placeholders.apply("DiscordConsoleChannelSuffix", (LogItem)item));
                    }).attachLog4jLogging().schedule();
                } else {
                    DiscordSRV.info(LangUtil.InternalMessage.NOT_FORWARDING_CONSOLE_OUTPUT.toString());
                }
            }
            this.reloadChannels();
            this.reloadRegexes();
            this.reloadRoleAliases();
            SchedulerUtil.runTask((Plugin)this, () -> SchedulerUtil.runTaskAsynchronously((Plugin)this, api::updateSlashCommands));
            if (this.getMainTextChannel() != null && this.getConsoleChannel() != null && this.getMainTextChannel().getId().equals(this.getConsoleChannel().getId())) {
                DiscordSRV.warning(LangUtil.InternalMessage.CONSOLE_CHANNEL_ASSIGNED_TO_LINKED_CHANNEL);
            }
            SchedulerUtil.runTaskLater((Plugin)this, () -> DiscordUtil.queueMessage(this.getOptionalTextChannel("status"), PlaceholderUtil.replacePlaceholdersToDiscord(LangUtil.Message.SERVER_STARTUP_MESSAGE.toString()), true), 20L);
            if (!DiscordSRV.config().getBooleanElse("RespectChatPlugins", true)) {
                DiscordSRV.warning(LangUtil.InternalMessage.RESPECT_CHAT_PLUGINS_DISABLED);
            }
            if (!this.isEnabled()) {
                return;
            }
            if (!SchedulerUtil.isFolia().booleanValue()) {
                if (this.serverWatchdog != null && this.serverWatchdog.getState() != Thread.State.NEW) {
                    this.serverWatchdog.interrupt();
                }
                this.serverWatchdog = new ServerWatchdog();
                this.serverWatchdog.start();
            }
            if (!SchedulerUtil.isFolia().booleanValue()) {
                Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new Lag(), 100L, 1L);
            }
            this.reloadCancellationDetector();
            if (JdbcAccountLinkManager.shouldUseJdbc()) {
                try {
                    this.accountLinkManager = new JdbcAccountLinkManager();
                    ((JdbcAccountLinkManager)this.accountLinkManager).migrateFile();
                }
                catch (SQLException e) {
                    StringBuilder stringBuilder = new StringBuilder("JDBC account link backend failed to initialize: ");
                    Throwable selected = e;
                    do {
                        stringBuilder.append("\n").append("Caused by: ").append(selected instanceof UnknownHostException ? "UnknownHostException" : ExceptionUtils.getMessage(selected));
                    } while ((selected = selected.getCause()) != null);
                    String message = stringBuilder.toString().replace(this.config.getString("Experiment_JdbcAccountLinkBackend"), "<jdbc url>").replace(this.config.getString("Experiment_JdbcUsername"), "<jdbc username>");
                    if (!StringUtils.isEmpty(this.config.getString("Experiment_JdbcPassword"))) {
                        message = message.replace(this.config.getString("Experiment_JdbcPassword"), "");
                    }
                    for (String line : message.split("\n")) {
                        DiscordSRV.warning(line);
                    }
                    DiscordSRV.warning("Account link manager falling back to file backend");
                    this.accountLinkManager = new AppendOnlyFileAccountLinkManager();
                }
            } else {
                this.accountLinkManager = new AppendOnlyFileAccountLinkManager();
            }
            Bukkit.getPluginManager().registerEvents((Listener)this.accountLinkManager, (Plugin)this);
            new PlayerBanListener();
            new PlayerDeathListener();
            new PlayerJoinLeaveListener();
            try {
                Class.forName("org.bukkit.event.player.PlayerAdvancementDoneEvent");
                new PlayerAdvancementDoneListener();
            }
            catch (Exception ignored) {
                new PlayerAchievementsListener();
            }
            for (String hookClassName : new String[]{"github.scarsz.discordsrv.hooks.chat.ChattyChatHook", "github.scarsz.discordsrv.hooks.chat.ChattyV3ChatHook", "github.scarsz.discordsrv.hooks.chat.FancyChatHook", "github.scarsz.discordsrv.hooks.chat.HerochatHook", "github.scarsz.discordsrv.hooks.chat.NChatHook", "github.scarsz.discordsrv.hooks.chat.LegendChatHook", "github.scarsz.discordsrv.hooks.chat.LunaChatHook", "github.scarsz.discordsrv.hooks.chat.TownyChatHook", "github.scarsz.discordsrv.hooks.chat.VentureChatHook", "github.scarsz.discordsrv.hooks.vanish.EssentialsHook", "github.scarsz.discordsrv.hooks.vanish.PhantomAdminHook", "github.scarsz.discordsrv.hooks.vanish.SuperVanishHook", "github.scarsz.discordsrv.hooks.vanish.VanishNoPacketHook", "github.scarsz.discordsrv.hooks.DynmapHook", "github.scarsz.discordsrv.hooks.permissions.LuckPermsHook", "github.scarsz.discordsrv.hooks.world.MultiverseCoreV4Hook", "github.scarsz.discordsrv.hooks.world.MultiverseCoreV5Hook"}) {
                try {
                    Class<?> hookClass = Class.forName(hookClassName);
                    PluginHook pluginHook2 = (PluginHook)hookClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!pluginHook2.isEnabled()) continue;
                    DiscordSRV.info(LangUtil.InternalMessage.PLUGIN_HOOK_ENABLING.toString().replace("{plugin}", pluginHook2.getPlugin().getName()));
                    Bukkit.getPluginManager().registerEvents((Listener)pluginHook2, (Plugin)this);
                    try {
                        pluginHook2.hook();
                        this.pluginHooks.add(pluginHook2);
                    }
                    catch (Throwable t) {
                        DiscordSRV.error("Failed to hook " + hookClassName, t);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof ClassNotFoundException || e instanceof NoClassDefFoundError) continue;
                    DiscordSRV.error("Failed to load " + hookClassName, e);
                }
            }
            if (this.pluginHooks.stream().noneMatch(pluginHook -> pluginHook instanceof ChatHook)) {
                DiscordSRV.debug(Debug.UNCATEGORIZED, LangUtil.InternalMessage.NO_CHAT_PLUGIN_HOOKED.toString());
                try {
                    Class.forName("io.papermc.paper.event.player.AsyncChatEvent");
                    this.getServer().getPluginManager().registerEvents((Listener)new ModernPlayerChatListener(), (Plugin)this);
                    this.modernChatEventAvailable = true;
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
                boolean configOption = DiscordSRV.config().getBoolean("UseModernPaperChatEvent");
                Warning warning = AsyncPlayerChatEvent.class.getAnnotation(Warning.class);
                boolean isWarning = warning != null && this.getServer().getWarningState().printFor(warning);
                Runnable registerLegacy = () -> this.getServer().getPluginManager().registerEvents((Listener)new PlayerChatListener(), (Plugin)this);
                if (isWarning) {
                    if (!configOption) {
                        if (this.modernChatEventAvailable) {
                            DiscordSRV.warning("AsyncPlayerChatEvent will be registered because the UseModernPaperChatEvent config option is set to false");
                            DiscordSRV.warning("You should enable UseModernPaperChatEvent if your chat plugins have updated to using the new event");
                        } else {
                            DiscordSRV.warning("AsyncPlayerChatEvent has a nag but Paper's modern PlayerChatEvent is not available.");
                            DiscordSRV.warning("Your server platform's chat event isn't supported currently");
                        }
                        registerLegacy.run();
                    }
                } else {
                    registerLegacy.run();
                }
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Modern PlayerChatEvent (Paper) is " + (this.modernChatEventAvailable ? "" : "not ") + "available");
            }
            this.pluginHooks.add(new VanishHook(){

                @Override
                public boolean isVanished(Player player) {
                    boolean vanished = false;
                    for (MetadataValue metadataValue : player.getMetadata("vanished")) {
                        if (!metadataValue.asBoolean()) continue;
                        vanished = true;
                        break;
                    }
                    return vanished;
                }

                @Override
                public Plugin getPlugin() {
                    return null;
                }

                @Override
                public boolean isEnabled() {
                    return true;
                }
            });
            if (PluginUtil.pluginHookIsEnabled("PlaceholderAPI")) {
                try {
                    DiscordSRV.info(LangUtil.InternalMessage.PLUGIN_HOOK_ENABLING.toString().replace("{plugin}", "PlaceholderAPI"));
                    SchedulerUtil.runTask((Plugin)this, () -> {
                        try {
                            if (PlaceholderAPIPlugin.getInstance().getLocalExpansionManager().findExpansionByIdentifier("discordsrv").isPresent()) {
                                this.getLogger().warning("The DiscordSRV PlaceholderAPI expansion is no longer required.");
                                this.getLogger().warning("The expansion is now integrated in DiscordSRV.");
                            }
                            new PlaceholderAPIExpansion().register();
                        }
                        catch (Throwable ignored) {
                            this.getLogger().severe("Failed to hook into PlaceholderAPI, please check your PlaceholderAPI version");
                        }
                    });
                }
                catch (Exception e) {
                    if (e instanceof ClassNotFoundException) break block105;
                    DiscordSRV.error("Failed to load PlaceholderAPI expansion", e);
                }
            }
        }
        if (this.channelTopicUpdater != null) {
            if (this.channelTopicUpdater.getState() != Thread.State.NEW) {
                this.channelTopicUpdater.interrupt();
                this.channelTopicUpdater = new ChannelTopicUpdater();
            }
        } else {
            this.channelTopicUpdater = new ChannelTopicUpdater();
        }
        this.channelTopicUpdater.start();
        if (this.channelUpdater != null) {
            if (this.channelUpdater.getState() != Thread.State.NEW) {
                this.channelUpdater.interrupt();
                this.channelUpdater = new ChannelUpdater();
            }
        } else {
            this.channelUpdater = new ChannelUpdater();
        }
        this.channelUpdater.start();
        if (!DiscordSRV.config().getBooleanElse("MetricsDisabled", false)) {
            Metrics bStats = new Metrics(this, 387);
            bStats.addCustomChart(new SimplePie("linked_channels", () -> String.valueOf(this.channels.size())));
            bStats.addCustomChart(new AdvancedPie("hooked_plugins", () -> new HashMap<String, Integer>(){
                {
                    if (DiscordSRV.this.pluginHooks.size() == 0) {
                        this.put("none", 1);
                    } else {
                        for (PluginHook hookedPlugin : DiscordSRV.this.pluginHooks) {
                            Plugin plugin = hookedPlugin.getPlugin();
                            if (plugin == null) continue;
                            this.put(plugin.getName(), 1);
                        }
                    }
                }
            }));
            bStats.addCustomChart(new SingleLineChart("minecraft-discord_account_links", () -> this.accountLinkManager.getLinkedAccountCount()));
            bStats.addCustomChart(new SimplePie("server_language", () -> DiscordSRV.config().getLanguage().getName()));
            bStats.addCustomChart(new AdvancedPie("features", () -> new HashMap<String, Integer>(){
                {
                    if (DiscordSRV.this.getConsoleChannel() != null) {
                        this.put("Console channel", 1);
                    }
                    if (StringUtils.isNotBlank(DiscordSRV.config().getString("DiscordChatChannelPrefixRequiredToProcessMessage"))) {
                        this.put("Chatting prefix", 1);
                    }
                    if (JdbcAccountLinkManager.shouldUseJdbc(true)) {
                        this.put("JDBC", 1);
                    }
                    if (DiscordSRV.config().getBoolean("Experiment_MCDiscordReserializer_ToMinecraft")) {
                        this.put("Discord -> MC Reserializer", 1);
                    }
                    if (DiscordSRV.config().getBoolean("Experiment_MCDiscordReserializer_ToDiscord")) {
                        this.put("MC -> Discord Reserializer", 1);
                    }
                    if (DiscordSRV.config().getBoolean("Experiment_MCDiscordReserializer_InBroadcast")) {
                        this.put("Broadcast Reserializer", 1);
                    }
                    if (DiscordSRV.config().getBoolean("Experiment_WebhookChatMessageDelivery")) {
                        this.put("Webhooks", 1);
                    }
                    if (DiscordSRV.config().getMap("GroupRoleSynchronizationGroupsAndRolesToSync").values().stream().anyMatch(s -> s.toString().replace("0", "").length() > 0)) {
                        this.put("Group -> role synchronization", 1);
                    }
                    if (DiscordSRV.config().getBoolean("Voice enabled")) {
                        this.put("Voice", 1);
                    }
                    if (DiscordSRV.config().getBoolean("Require linked account to play.Enabled")) {
                        this.put("Require linked account to play", 1);
                        if (DiscordSRV.config().getBoolean("Require linked account to play.Subscriber role.Require subscriber role to join")) {
                            this.put("Required subscriber role to play", 1);
                        }
                    }
                }
            }));
            bStats.addCustomChart(new SingleLineChart("atleast_1player_online", () -> PlayerUtil.getOnlinePlayers().isEmpty() ? 0 : 1));
            bStats.addCustomChart(new SimplePie("better_online_mode", () -> {
                boolean onlineMode = Bukkit.getOnlineMode();
                try {
                    Class<?> spigotConfig = Class.forName("org.spigotmc.SpigotConfig");
                    Field bungee = spigotConfig.getField("bungee");
                    if (bungee.getBoolean(null)) {
                        return "bungee";
                    }
                }
                catch (Throwable spigotConfig) {
                    // empty catch block
                }
                try {
                    Class<?> paperConfig = Class.forName("com.destroystokyo.paper.PaperConfig");
                    Field velocitySupport = paperConfig.getField("velocitySupport");
                    Field velocityOnlineMode = paperConfig.getField("velocityOnlineMode");
                    if (velocitySupport.getBoolean(null) && velocityOnlineMode.getBoolean(null)) {
                        return "velocity";
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return onlineMode ? "online" : "offline";
            }));
            bStats.addCustomChart(new DrilldownPie("server_plugins", () -> {
                int pluginCount = Bukkit.getPluginManager().getPlugins().length;
                HashMap<String, Integer> count = new HashMap<String, Integer>();
                count.put(String.valueOf(pluginCount), 1);
                String key = pluginCount <= 5 ? "1-5" : (pluginCount <= 10 ? "6-10" : (pluginCount <= 20 ? "11-20" : (pluginCount <= 50 ? "21-50" : (pluginCount <= 100 ? "51-100" : (int)(Math.floor((float)pluginCount / 100.0f) * 100.0) + "+"))));
                HashMap<String, HashMap<String, Integer>> plugins = new HashMap<String, HashMap<String, Integer>>();
                plugins.put(key, count);
                return plugins;
            }));
        }
        if ((metricsFile = new File(this.getDataFolder(), "metrics.json")).exists() && !metricsFile.delete()) {
            metricsFile.deleteOnExit();
        }
        if (this.isGroupRoleSynchronizationEnabled()) {
            int cycleTime = DiscordSRV.config().getInt("GroupRoleSynchronizationCycleTime") * 20 * 60;
            if (cycleTime < 1200) {
                cycleTime = 1200;
            }
            try {
                this.groupSynchronizationManager.resync(GroupSynchronizationManager.SyncDirection.AUTHORITATIVE, GroupSynchronizationManager.SyncCause.TIMER);
            }
            catch (Exception e) {
                DiscordSRV.error("Failed to resync\n" + ExceptionUtils.getMessage(e));
            }
            Bukkit.getPluginManager().registerEvents((Listener)this.groupSynchronizationManager, (Plugin)this);
            SchedulerUtil.runTaskTimerAsynchronously((Plugin)this, () -> this.groupSynchronizationManager.resync(GroupSynchronizationManager.SyncDirection.AUTHORITATIVE, GroupSynchronizationManager.SyncCause.TIMER), cycleTime, cycleTime);
        }
        this.voiceModule = new VoiceModule();
        PluginCommand discordCommand = this.getCommand("discord");
        if (discordCommand != null && discordCommand.getPlugin() != this) {
            DiscordSRV.warning("/discord command is being handled by plugin other than DiscordSRV. You must use /discordsrv instead.");
        }
        this.alertListener = new AlertListener();
        this.jda.addEventListener(this.alertListener);
        api.subscribe(this.alertListener);
        this.getServer().getPluginManager().registerEvents((Listener)this.alertListener, (Plugin)this);
        if (this.jda.getStatus() == JDA.Status.CONNECTED) {
            isReady = true;
            api.callEvent(new DiscordReadyEvent());
        }
    }

    public void onDisable() {
        shuttingDown = true;
        long shutdownStartTime = System.currentTimeMillis();
        String shutdownFormat = LangUtil.Message.SERVER_SHUTDOWN_MESSAGE.toString();
        if (Pattern.compile("%[^%]+%").matcher(shutdownFormat).find()) {
            shutdownFormat = PlaceholderUtil.replacePlaceholdersToDiscord(shutdownFormat);
        }
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("DiscordSRV - Shutdown").build();
        ExecutorService executor = Executors.newSingleThreadExecutor(threadFactory);
        try {
            String finalShutdownFormat = shutdownFormat;
            executor.invokeAll(Collections.singletonList(() -> {
                if (DiscordSRV.config().getBoolean("ChannelTopicUpdaterChannelTopicsAtShutdownEnabled")) {
                    Iterator time = TimeUtil.timeStamp();
                    String serverVersion = Bukkit.getBukkitVersion();
                    String totalPlayers = Integer.toString(DiscordSRV.getTotalPlayerCount());
                    String shutdownTimestamp2 = Long.toString(System.currentTimeMillis() / 1000L);
                    DiscordUtil.setTextChannelTopic(this.getMainTextChannel(), LangUtil.Message.CHAT_CHANNEL_TOPIC_AT_SERVER_SHUTDOWN.toString().replaceAll("%time%|%date%", (String)((Object)time)).replace("%serverversion%", serverVersion).replace("%totalplayers%", totalPlayers).replace("%timestamp%", shutdownTimestamp2));
                    DiscordUtil.setTextChannelTopic(this.getConsoleChannel(), LangUtil.Message.CONSOLE_CHANNEL_TOPIC_AT_SERVER_SHUTDOWN.toString().replaceAll("%time%|%date%", (String)((Object)time)).replace("%serverversion%", serverVersion).replace("%totalplayers%", totalPlayers).replace("%timestamp%", shutdownTimestamp2));
                }
                for (ChannelUpdater.UpdaterChannel updaterChannel : this.getChannelUpdater().getUpdaterChannels()) {
                    updaterChannel.updateToShutdownFormat();
                }
                isReady = false;
                HandlerList.unregisterAll((Plugin)this);
                SchedulerUtil.cancelTasks((Plugin)this);
                if (!SchedulerUtil.isFolia().booleanValue()) {
                    for (BukkitWorker activeWorker : Bukkit.getScheduler().getActiveWorkers()) {
                        if (!activeWorker.getOwner().equals((Object)this)) continue;
                        List<String> stackTrace = Arrays.stream(activeWorker.getThread().getStackTrace()).map(StackTraceElement::toString).collect(Collectors.toList());
                        DiscordSRV.warning("a DiscordSRV scheduler task still active during onDisable: " + (String)stackTrace.remove(0));
                        DiscordSRV.debug(stackTrace);
                    }
                }
                if (this.alertListener != null) {
                    this.alertListener.unregister();
                }
                if (this.voiceModule != null) {
                    this.voiceModule.shutdown();
                }
                if (this.channelTopicUpdater != null) {
                    this.channelTopicUpdater.interrupt();
                }
                if (this.channelUpdater != null) {
                    this.channelUpdater.interrupt();
                }
                if (this.presenceUpdater != null) {
                    this.presenceUpdater.interrupt();
                }
                if (this.nicknameUpdater != null) {
                    this.nicknameUpdater.interrupt();
                }
                if (this.serverWatchdog != null) {
                    this.serverWatchdog.interrupt();
                }
                if (this.updateChecker != null) {
                    this.updateChecker.shutdown();
                }
                if (this.legacyCancellationDetector != null) {
                    this.legacyCancellationDetector.close();
                }
                if (this.modernCancellationDetector != null) {
                    this.modernCancellationDetector.close();
                }
                if (this.consoleAppender != null) {
                    this.consoleAppender.shutdown();
                }
                if (this.jdaFilter != null) {
                    try {
                        Logger logger = (Logger)LogManager.getRootLogger();
                        AccessibleObject configField = null;
                        for (Class<?> targetClass = logger.getClass(); targetClass != null; targetClass = targetClass.getSuperclass()) {
                            try {
                                configField = targetClass.getDeclaredField("config");
                                break;
                            }
                            catch (NoSuchFieldException shutdownTimestamp2) {
                                try {
                                    configField = targetClass.getDeclaredField("privateConfig");
                                    break;
                                }
                                catch (NoSuchFieldException shutdownTimestamp2) {
                                    continue;
                                }
                            }
                        }
                        if (configField != null) {
                            Object config2;
                            Object config;
                            Field configField2;
                            if (!configField.isAccessible()) {
                                ((Field)configField).setAccessible(true);
                            }
                            if (!(configField2 = (config = ((Field)configField).get(logger)).getClass().getDeclaredField("config")).isAccessible()) {
                                configField2.setAccessible(true);
                            }
                            if ((config2 = configField2.get(config)) instanceof Filterable) {
                                ((Filterable)config2).removeFilter((Filter)this.jdaFilter);
                                this.jdaFilter = null;
                                DiscordSRV.debug("JdaFilter removed");
                            }
                        }
                    }
                    catch (Throwable t) {
                        this.getLogger().warning("Could not remove JDA Filter: " + t.toString());
                    }
                }
                if (this.jda != null) {
                    this.jda.getEventManager().getRegisteredListeners().forEach(listener -> this.jda.getEventManager().unregister(listener));
                }
                DiscordUtil.sendMessageBlocking(this.getOptionalTextChannel("status"), finalShutdownFormat, true);
                if (this.jda != null) {
                    final CompletableFuture shutdownTask = new CompletableFuture();
                    this.jda.addEventListener(new ListenerAdapter(){

                        @Override
                        public void onShutdown(@NotNull ShutdownEvent event) {
                            shutdownTask.complete(null);
                        }
                    });
                    this.jda.shutdownNow();
                    this.jda = null;
                    try {
                        shutdownTask.get(5L, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException e) {
                        this.getLogger().warning("JDA took too long to shut down, skipping");
                    }
                }
                if (this.callbackThreadPool != null) {
                    this.callbackThreadPool.shutdownNow();
                }
                DiscordSRV.info(LangUtil.InternalMessage.SHUTDOWN_COMPLETED.toString().replace("{ms}", String.valueOf(System.currentTimeMillis() - shutdownStartTime)));
                return null;
            }), 15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            DiscordSRV.error(e);
        }
        executor.shutdownNow();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command cmd, @NotNull String label, String[] args) {
        Supplier<Boolean> handle = () -> this.commandManager.handle(sender, args[0], (String[])Arrays.stream(args).skip(1L).toArray(String[]::new));
        if (!this.isEnabled()) {
            if (args.length > 0 && args[0].equalsIgnoreCase("debug")) {
                return handle.get();
            }
            if (invalidBotToken) {
                sender.sendMessage(ChatColor.RED + "DiscordSRV is disabled: your bot token is invalid.");
                sender.sendMessage(ChatColor.RED + "Please enter a valid token into your config.yml (" + ChatColor.GRAY + "/plugins/DiscordSRV/config.yml" + ChatColor.RED + ") and restart your server to get DiscordSRV to work.");
            } else if (DiscordDisconnectListener.mostRecentCloseCode == CloseCode.DISALLOWED_INTENTS) {
                sender.sendMessage(ChatColor.RED + "DiscordSRV is disabled: your DiscordSRV bot is lacking required intents.");
                sender.sendMessage(ChatColor.RED + "Please check your server log (" + ChatColor.GRAY + "/logs/latest.log" + ChatColor.RED + ") for a extended error message during DiscordSRV's startup to get DiscordSRV to work.");
            } else {
                sender.sendMessage(ChatColor.RED + "DiscordSRV is disabled, check your server log (" + ChatColor.GRAY + "/logs/latest.log" + ChatColor.RED + ") for errors during DiscordSRV's startup to find out why");
            }
            return true;
        }
        if (args.length == 0) {
            return this.commandManager.handle(sender, null, new String[0]);
        }
        return handle.get();
    }

    public List<String> onTabComplete(final @NotNull CommandSender sender, @NotNull org.bukkit.command.Command bukkitCommand, @NotNull String alias, String[] args) {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        final String command = args[0];
        String[] commandArgs = (String[])Arrays.stream(args).skip(1L).toArray(String[]::new);
        if (command.equals("")) {
            return new ArrayList<String>(){
                {
                    for (Map.Entry<String, Method> command : DiscordSRV.this.getCommandManager().getCommands().entrySet()) {
                        if (!GamePermissionUtil.hasPermission((Permissible)sender, command.getValue().getAnnotation(Command.class).permission())) continue;
                        this.add(command.getKey());
                    }
                }
            };
        }
        if (commandArgs.length == 0) {
            return new ArrayList<String>(){
                {
                    for (Map.Entry<String, Method> commandPair : DiscordSRV.this.getCommandManager().getCommands().entrySet()) {
                        if (!commandPair.getKey().toLowerCase().startsWith(command.toLowerCase()) || !GamePermissionUtil.hasPermission((Permissible)sender, commandPair.getValue().getAnnotation(Command.class).permission())) continue;
                        this.add(commandPair.getKey());
                    }
                }
            };
        }
        return null;
    }

    public void reloadCancellationDetector() {
        if (this.legacyCancellationDetector != null) {
            this.legacyCancellationDetector.close();
            this.legacyCancellationDetector = null;
        }
        if (this.modernCancellationDetector != null) {
            this.modernCancellationDetector.close();
            this.modernCancellationDetector = null;
        }
        if (Debug.MINECRAFT_TO_DISCORD.isVisible()) {
            try {
                this.legacyCancellationDetector = new CancellationDetector<AsyncPlayerChatEvent>((Plugin)this, AsyncPlayerChatEvent.class, (listener, event) -> {
                    Plugin plugin = listener.getPlugin();
                    DiscordSRV.info("Plugin " + plugin + " cancelled AsyncPlayerChatEvent (Bukkit) (author: " + event.getPlayer().getName() + " | message: " + event.getMessage() + ")");
                });
                try {
                    Class.forName("io.papermc.paper.event.player.AsyncChatEvent");
                    this.modernCancellationDetector = new CancellationDetector<AsyncChatEvent>((Plugin)this, AsyncChatEvent.class, (listener, event) -> {
                        Plugin plugin = listener.getPlugin();
                        DiscordSRV.info("Plugin " + plugin + " cancelled AsyncChatEvent (Paper) (author: " + event.getPlayer().getName() + ")");
                    });
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                DiscordSRV.debug(LangUtil.InternalMessage.CHAT_CANCELLATION_DETECTOR_ENABLED.toString());
            }
            catch (Throwable t) {
                DiscordSRV.error("Could not initialize cancellation detector(s)", t);
            }
        }
    }

    public String getWorldAlias(String world) {
        WorldHook worldHook = this.pluginHooks.stream().filter(hook -> hook instanceof WorldHook).map(hook -> (WorldHook)hook).findAny().orElse(null);
        if (worldHook == null) {
            return world;
        }
        return worldHook.getWorldAlias(world);
    }

    @Deprecated
    public void processChatMessage(Player player, String message, String channel, boolean cancelled) {
        this.processChatMessage(player, message, channel, cancelled, null);
    }

    public void processChatMessage(Player player, String message, String channel, boolean cancelled, Event event) {
        this.processChatMessage(player, MessageUtil.toComponent(message, true), channel, cancelled, event);
    }

    @Deprecated
    public void processChatMessage(Player player, Component message, String channel, boolean cancelled) {
        this.processChatMessage(player, message, channel, cancelled, null);
    }

    public void processChatMessage(Player player, Component message, String channel, boolean cancelled, Event event) {
        GameChatMessagePostProcessEvent postEvent;
        DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Chat message received, canceled: " + cancelled + ", channel: " + channel);
        if (player == null) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Received chat message was from a null sender, not processing message");
            return;
        }
        if (!GamePermissionUtil.hasPermission((Permissible)player, "discordsrv.chat")) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "User " + player.getName() + " sent a message but it was not delivered to Discord due to lack of in-game permission (discordsrv.chat)");
            return;
        }
        if (PluginUtil.pluginHookIsEnabled("mcMMO") && player.hasMetadata("mcMMO: Player Data")) {
            boolean usingAdminChat = ChatAPI.isUsingAdminChat((Player)player);
            boolean usingPartyChat = ChatAPI.isUsingPartyChat((Player)player);
            if (usingAdminChat || usingPartyChat) {
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Not processing message because message was from " + (usingAdminChat ? "admin" : "party") + " chat");
                return;
            }
        }
        if (DiscordSRV.config().getBooleanElse("RespectChatPlugins", true) && cancelled) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "User " + player.getName() + " sent a message but it was not delivered to Discord because the chat event was canceled");
            return;
        }
        if (!DiscordSRV.config().getBoolean("DiscordChatChannelMinecraftToDiscord")) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "User " + player.getName() + " sent a message but it was not delivered to Discord because DiscordChatChannelMinecraftToDiscord is false");
            return;
        }
        String prefix = DiscordSRV.config().getString("DiscordChatChannelPrefixRequiredToProcessMessage");
        boolean blacklist = this.config.getBoolean("DiscordChatChannelPrefixActsAsBlacklist");
        String legacy = MessageUtil.toLegacy(message);
        if (MessageUtil.strip(legacy).startsWith(prefix) == blacklist) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "User " + player.getName() + " sent a message but it was not delivered to Discord because " + (blacklist ? "the message started with \"" + prefix : "the message didn't start with \"" + prefix) + "\" (DiscordChatChannelPrefixRequiredToProcessMessage): \"" + message + "\"");
            return;
        }
        GameChatMessagePreProcessEvent preEvent = api.callEvent(new GameChatMessagePreProcessEvent(channel, message, player, event));
        if (preEvent.isCancelled()) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "GameChatMessagePreProcessEvent was cancelled, message send aborted");
            return;
        }
        channel = preEvent.getChannel();
        message = preEvent.getMessageComponent();
        String userPrimaryGroup = VaultHook.getPrimaryGroup(player);
        boolean hasGoodGroup = StringUtils.isNotBlank(userPrimaryGroup);
        if (hasGoodGroup) {
            userPrimaryGroup = userPrimaryGroup.substring(0, 1).toUpperCase() + userPrimaryGroup.substring(1);
        }
        boolean reserializer = DiscordSRV.config().getBoolean("Experiment_MCDiscordReserializer_ToDiscord");
        boolean webhookMessageDelivery = DiscordSRV.config().getBoolean("Experiment_WebhookChatMessageDelivery");
        String discordMessageContent = reserializer ? MessageUtil.reserializeToDiscord(message) : MessageUtil.strip(MessageUtil.toLegacy(message));
        if (webhookMessageDelivery && (discordMessageContent = this.processRegex(discordMessageContent)) == null) {
            return;
        }
        discordMessageContent = DiscordSRV.config().getBoolean("DiscordChatChannelTranslateMentions") ? DiscordUtil.convertMentionsFromNames(discordMessageContent, this.getMainGuild()) : discordMessageContent.replace("@", "@\u200b");
        String processedMessage = discordMessageContent;
        if (!webhookMessageDelivery) {
            String username = player.getName();
            if (!reserializer) {
                username = DiscordUtil.escapeMarkdown(username);
            }
            String displayName = MessageUtil.strip(player.getDisplayName());
            String discordMessagePattern = (hasGoodGroup ? LangUtil.Message.CHAT_TO_DISCORD.toString() : LangUtil.Message.CHAT_TO_DISCORD_NO_PRIMARY_GROUP.toString()).replace("%displayname%", DiscordUtil.escapeMarkdown(displayName)).replace("%displaynamenoescapes%", displayName).replace("%username%", username).replaceAll("%time%|%date%", TimeUtil.timeStamp()).replace("%channelname%", channel != null ? channel.substring(0, 1).toUpperCase() + channel.substring(1) : "").replace("%primarygroup%", userPrimaryGroup).replace("%usernamenoescapes%", MessageUtil.strip(player.getName())).replace("%world%", player.getWorld().getName()).replace("%worldalias%", MessageUtil.strip(this.getWorldAlias(player.getWorld().getName())));
            discordMessagePattern = PlaceholderUtil.replacePlaceholdersToDiscord(discordMessagePattern, (OfflinePlayer)player);
            if (!reserializer) {
                discordMessagePattern = MessageUtil.strip(discordMessagePattern);
            }
            discordMessagePattern = discordMessagePattern.replace("%message%", discordMessageContent);
            if ((discordMessagePattern = this.processRegex(discordMessagePattern)) == null) {
                return;
            }
            processedMessage = discordMessagePattern;
        }
        if ((postEvent = api.callEvent(new GameChatMessagePostProcessEvent(channel, processedMessage, player, preEvent.isCancelled(), event))).isCancelled()) {
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "GameChatMessagePostProcessEvent was cancelled, message send aborted");
            return;
        }
        channel = postEvent.getChannel();
        processedMessage = postEvent.getProcessedMessage();
        if (channel == null) {
            channel = this.getOptionalChannel("global");
        }
        TextChannel destinationChannel = this.getDestinationTextChannelForGameChannelName(channel);
        if (!webhookMessageDelivery) {
            DiscordUtil.sendMessage(destinationChannel, processedMessage);
        } else {
            if (destinationChannel == null) {
                DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Failed to find Discord channel to forward message from game channel " + channel);
                return;
            }
            if (!DiscordUtil.checkPermission(destinationChannel, Permission.MANAGE_WEBHOOKS)) {
                DiscordSRV.error("Couldn't deliver chat message as webhook because the bot lacks the \"Manage Webhooks\" permission.");
                return;
            }
            WebhookUtil.deliverMessage(destinationChannel, player, processedMessage);
        }
    }

    private String processRegex(String discordMessage) {
        for (Map.Entry<Pattern, String> entry : this.getGameRegexes().entrySet()) {
            discordMessage = entry.getKey().matcher(discordMessage).replaceAll(entry.getValue());
            if (!StringUtils.isBlank(discordMessage)) continue;
            DiscordSRV.debug(Debug.MINECRAFT_TO_DISCORD, "Not processing Minecraft message because it was cleared by a filter: " + entry.getKey().pattern());
            return null;
        }
        return discordMessage;
    }

    @Deprecated
    public void broadcastMessageToMinecraftServer(String channel, String message, User author) {
        Player authorPlayer = null;
        UUID authorLinkedUuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(author.getId());
        if (authorLinkedUuid != null) {
            authorPlayer = Bukkit.getPlayer((UUID)authorLinkedUuid);
        }
        message = PlaceholderUtil.replacePlaceholders(message, (OfflinePlayer)authorPlayer);
        this.broadcastMessageToMinecraftServer(channel, MessageUtil.toComponent(message), author);
    }

    public void broadcastMessageToMinecraftServer(String channel, Component message, User author) {
        ChatHook chatHook = this.pluginHooks.stream().filter(hook -> hook instanceof ChatHook).map(hook -> (ChatHook)hook).findAny().orElse(null);
        if (chatHook == null || channel == null) {
            if (channel != null && !channel.equalsIgnoreCase("global")) {
                return;
            }
            DiscordGuildMessagePreBroadcastEvent preBroadcastEvent = api.callEvent(new DiscordGuildMessagePreBroadcastEvent(author, channel, message, PlayerUtil.getOnlinePlayers()));
            message = preBroadcastEvent.getMessage();
            channel = preBroadcastEvent.getChannel();
            MessageUtil.sendMessage(preBroadcastEvent.getRecipients(), message);
            PlayerUtil.notifyPlayersOfMentions(null, MessageUtil.toLegacy(message));
        } else {
            chatHook.broadcastMessageToChannel(channel, message);
            message = message.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%channelcolor%").replacement("").build());
        }
        api.callEvent(new DiscordGuildMessagePostBroadcastEvent(channel, message));
        if (DiscordSRV.config().getBoolean("DiscordChatChannelBroadcastDiscordMessagesToConsole")) {
            DiscordSRV.info((Object)((Object)LangUtil.InternalMessage.CHAT) + ": " + MessageUtil.strip(MessageUtil.toLegacy(message).replace("\u00bb", ">")));
        }
    }

    public void sendJoinMessage(Player player, String joinMessage) {
        String botName;
        String botAvatarUrl;
        String avatarUrl;
        String name;
        MessageFormat messageFormat;
        if (player == null) {
            throw new IllegalArgumentException("player cannot be null");
        }
        MessageFormat messageFormat2 = messageFormat = player.hasPlayedBefore() ? this.getMessageFromConfiguration("MinecraftPlayerJoinMessage") : this.getMessageFromConfiguration("MinecraftPlayerFirstJoinMessage");
        if (messageFormat == null || !messageFormat.isAnyContent()) {
            DiscordSRV.debug("Not sending join message due to it being disabled");
            return;
        }
        TextChannel textChannel = this.getOptionalTextChannel("join");
        if (textChannel == null) {
            DiscordSRV.debug("Not sending join message, text channel is null");
            return;
        }
        String displayName = StringUtils.isNotBlank(player.getDisplayName()) ? MessageUtil.strip(player.getDisplayName()) : "";
        String message = StringUtils.isNotBlank(joinMessage) ? joinMessage : "";
        BiFunction<String, Boolean, String> translator = (arg_0, arg_1) -> DiscordSRV.lambda$sendJoinMessage$63(message, name = player.getName(), displayName, avatarUrl = DiscordSRV.getAvatarUrl(player), botAvatarUrl = DiscordUtil.getJda().getSelfUser().getEffectiveAvatarUrl(), botName = this.getMainGuild() != null ? this.getMainGuild().getSelfMember().getEffectiveName() : DiscordUtil.getJda().getSelfUser().getName(), textChannel, player, arg_0, arg_1);
        Message discordMessage = DiscordSRV.translateMessage(messageFormat, translator);
        if (discordMessage == null) {
            return;
        }
        String webhookName = translator.apply(messageFormat.getWebhookName(), false);
        String webhookAvatarUrl = translator.apply(messageFormat.getWebhookAvatarUrl(), false);
        if (messageFormat.isUseWebhooks()) {
            WebhookUtil.deliverMessage(textChannel, webhookName, webhookAvatarUrl, discordMessage.getContentRaw(), (MessageEmbed)discordMessage.getEmbeds().stream().findFirst().orElse(null));
        } else {
            DiscordUtil.queueMessage(textChannel, discordMessage, true);
        }
    }

    public void sendLeaveMessage(Player player, String quitMessage) {
        String botName;
        String botAvatarUrl;
        String avatarUrl;
        String name;
        if (player == null) {
            throw new IllegalArgumentException("player cannot be null");
        }
        MessageFormat messageFormat = this.getMessageFromConfiguration("MinecraftPlayerLeaveMessage");
        if (messageFormat == null || !messageFormat.isAnyContent()) {
            DiscordSRV.debug("Not sending leave message due to it being disabled");
            return;
        }
        TextChannel textChannel = this.getOptionalTextChannel("leave");
        if (textChannel == null) {
            DiscordSRV.debug("Not sending quit message, text channel is null");
            return;
        }
        String displayName = StringUtils.isNotBlank(player.getDisplayName()) ? MessageUtil.strip(player.getDisplayName()) : "";
        String message = StringUtils.isNotBlank(quitMessage) ? quitMessage : "";
        BiFunction<String, Boolean, String> translator = (arg_0, arg_1) -> DiscordSRV.lambda$sendLeaveMessage$64(message, name = player.getName(), displayName, avatarUrl = DiscordSRV.getAvatarUrl(player), botAvatarUrl = DiscordUtil.getJda().getSelfUser().getEffectiveAvatarUrl(), botName = this.getMainGuild() != null ? this.getMainGuild().getSelfMember().getEffectiveName() : DiscordUtil.getJda().getSelfUser().getName(), textChannel, player, arg_0, arg_1);
        Message discordMessage = DiscordSRV.translateMessage(messageFormat, translator);
        if (discordMessage == null) {
            return;
        }
        String webhookName = translator.apply(messageFormat.getWebhookName(), false);
        String webhookAvatarUrl = translator.apply(messageFormat.getWebhookAvatarUrl(), false);
        if (messageFormat.isUseWebhooks()) {
            WebhookUtil.deliverMessage(textChannel, webhookName, webhookAvatarUrl, discordMessage.getContentRaw(), (MessageEmbed)discordMessage.getEmbeds().stream().findFirst().orElse(null));
        } else {
            DiscordUtil.queueMessage(textChannel, discordMessage, true);
        }
    }

    public MessageFormat getMessageFromConfiguration(String key) {
        return MessageFormatResolver.getMessageFromConfiguration(DiscordSRV.config(), key);
    }

    @CheckReturnValue
    public static Message translateMessage(MessageFormat messageFormat, BiFunction<String, Boolean, String> translator) {
        MessageBuilder messageBuilder = new MessageBuilder();
        Optional.ofNullable(messageFormat.getContent()).map(content -> (String)translator.apply((String)content, true)).filter(StringUtils::isNotBlank).ifPresent(messageBuilder::setContent);
        EmbedBuilder embedBuilder = new EmbedBuilder();
        embedBuilder.setAuthor(Optional.ofNullable(messageFormat.getAuthorName()).map(content -> (String)translator.apply((String)content, false)).filter(StringUtils::isNotBlank).orElse(null), Optional.ofNullable(messageFormat.getAuthorUrl()).map(content -> (String)translator.apply((String)content, true)).filter(StringUtils::isNotBlank).orElse(null), Optional.ofNullable(messageFormat.getAuthorImageUrl()).map(content -> (String)translator.apply((String)content, true)).filter(StringUtils::isNotBlank).orElse(null));
        embedBuilder.setThumbnail(Optional.ofNullable(messageFormat.getThumbnailUrl()).map(content -> (String)translator.apply((String)content, true)).filter(StringUtils::isNotBlank).orElse(null));
        embedBuilder.setImage(Optional.ofNullable(messageFormat.getImageUrl()).map(content -> (String)translator.apply((String)content, true)).filter(StringUtils::isNotBlank).orElse(null));
        embedBuilder.setDescription(Optional.ofNullable(messageFormat.getDescription()).map(content -> (String)translator.apply((String)content, true)).filter(StringUtils::isNotBlank).orElse(null));
        embedBuilder.setTitle(Optional.ofNullable(messageFormat.getTitle()).map(content -> (String)translator.apply((String)content, false)).filter(StringUtils::isNotBlank).orElse(null), Optional.ofNullable(messageFormat.getTitleUrl()).map(content -> (String)translator.apply((String)content, true)).filter(StringUtils::isNotBlank).orElse(null));
        embedBuilder.setFooter(Optional.ofNullable(messageFormat.getFooterText()).map(content -> (String)translator.apply((String)content, true)).filter(StringUtils::isNotBlank).orElse(null), Optional.ofNullable(messageFormat.getFooterIconUrl()).map(content -> (String)translator.apply((String)content, true)).filter(StringUtils::isNotBlank).orElse(null));
        if (messageFormat.getFields() != null) {
            messageFormat.getFields().forEach(field -> embedBuilder.addField((String)translator.apply(field.getName(), true), (String)translator.apply(field.getValue(), true), field.isInline()));
        }
        embedBuilder.setColor(messageFormat.getColorRaw());
        embedBuilder.setTimestamp(messageFormat.getTimestamp());
        if (!embedBuilder.isEmpty()) {
            messageBuilder.setEmbeds(embedBuilder.build());
        }
        return messageBuilder.isEmpty() ? null : messageBuilder.build();
    }

    public static String getAvatarUrl(String username, UUID uuid) {
        String avatarUrl = DiscordSRV.constructAvatarUrl(username, uuid, "");
        avatarUrl = PlaceholderUtil.replacePlaceholdersToDiscord(avatarUrl);
        return avatarUrl;
    }

    private static String getAvatarUrl(OfflinePlayer player) {
        if (player.isOnline()) {
            return DiscordSRV.getAvatarUrl(player.getPlayer());
        }
        String avatarUrl = DiscordSRV.constructAvatarUrl(player.getName(), player.getUniqueId(), "");
        avatarUrl = PlaceholderUtil.replacePlaceholdersToDiscord(avatarUrl, player);
        return avatarUrl;
    }

    public static String getAvatarUrl(Player player) {
        String avatarUrl = DiscordSRV.constructAvatarUrl(player.getName(), player.getUniqueId(), NMSUtil.getTexture(player));
        avatarUrl = PlaceholderUtil.replacePlaceholdersToDiscord(avatarUrl, (OfflinePlayer)player);
        return avatarUrl;
    }

    private static String constructAvatarUrl(String username, UUID uuid, String texture) {
        boolean offline = uuid == null || PlayerUtil.uuidIsOffline(uuid);
        OfflinePlayer player = null;
        if (StringUtils.isNotBlank(username) && offline) {
            player = Bukkit.getOfflinePlayer((String)username);
            uuid = player.getUniqueId();
            offline = PlayerUtil.uuidIsOffline(uuid);
        }
        if (StringUtils.isBlank(username) && uuid != null) {
            player = Bukkit.getOfflinePlayer((UUID)uuid);
            username = player.getName();
        }
        if (StringUtils.isBlank(texture) && player != null && player.isOnline()) {
            texture = NMSUtil.getTexture(player.getPlayer());
        }
        String avatarUrl = DiscordSRV.config().getString("AvatarUrl");
        String defaultUrl = "https://crafthead.net/helm/{uuid-nodashes}/{size}#{texture}";
        String offlineUrl = "https://crafthead.net/helm/{username}/{size}#{texture}";
        if (StringUtils.isBlank(avatarUrl)) {
            String string = avatarUrl = !offline ? defaultUrl : offlineUrl;
        }
        if (avatarUrl.contains("://crafatar.com/")) {
            avatarUrl = !offline ? defaultUrl : offlineUrl;
            DiscordSRV.config().setRuntimeValue("AvatarUrl", avatarUrl);
            DiscordSRV.warning("Your AvatarUrl config option uses crafatar.com, which no longer allows usage with Discord. An alternative provider will be used.");
            DiscordSRV.warning("You should set your AvatarUrl (in config.yml) to an empty string (\"\") to get rid of this warning.");
        }
        if (offline && (avatarUrl.contains("{uuid}") || avatarUrl.contains("{uuid-nodashes}")) && !offlineUuidAvatarUrlNagged) {
            DiscordSRV.error("Your AvatarUrl config option contains {uuid} or {uuid-nodashes} but this server is using offline UUIDs.");
            offlineUuidAvatarUrlNagged = true;
        }
        if (username.startsWith("*")) {
            username = username.substring(1);
        }
        try {
            username = URLEncoder.encode(username, "utf8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String usedBaseUrl = avatarUrl;
        avatarUrl = avatarUrl.replace("{texture}", texture != null ? texture : "").replace("{username}", username).replace("{uuid}", uuid != null ? uuid.toString() : "").replace("{uuid-nodashes}", uuid.toString().replace("-", "")).replace("{size}", "128");
        DiscordSRV.debug("Constructed avatar url: " + avatarUrl + " from " + usedBaseUrl);
        DiscordSRV.debug("Avatar url is for " + (offline ? "**offline** " : "") + "uuid: " + uuid + ". The texture is: " + texture);
        return avatarUrl;
    }

    public static int getLength(Message message) {
        StringBuilder content = new StringBuilder();
        content.append(message.getContentRaw());
        message.getEmbeds().stream().findFirst().ifPresent(embed -> {
            if (embed.getTitle() != null) {
                content.append(embed.getTitle());
            }
            if (embed.getDescription() != null) {
                content.append(embed.getDescription());
            }
            if (embed.getAuthor() != null) {
                content.append(embed.getAuthor().getName());
            }
            for (MessageEmbed.Field field : embed.getFields()) {
                content.append(field.getName()).append(field.getValue());
            }
        });
        return content.toString().replaceAll("[^A-z]", "").length();
    }

    public List<Role> getSelectedRoles(Member member) {
        List<String> discordRolesSelection = DiscordSRV.config().getStringList("DiscordChatChannelRolesSelection");
        List<Role> selectedRoles = DiscordSRV.config().getBoolean("DiscordChatChannelRolesSelectionAsWhitelist") ? member.getRoles().stream().filter(role -> discordRolesSelection.contains(DiscordUtil.getRoleName(role)) || discordRolesSelection.contains(role.getId())).collect(Collectors.toList()) : member.getRoles().stream().filter(role -> !discordRolesSelection.contains(DiscordUtil.getRoleName(role)) && !discordRolesSelection.contains(role.getId())).collect(Collectors.toList());
        selectedRoles.removeIf(role -> StringUtils.isBlank(role.getName()));
        return selectedRoles;
    }

    public Role getTopSelectedRole(Member member) {
        List<Role> selectedRoles = this.getSelectedRoles(member);
        if (selectedRoles.isEmpty()) {
            return null;
        }
        return member.getRoles().stream().filter(selectedRoles::contains).findFirst().orElse(null);
    }

    public Map<String, String> getGroupSynchronizables() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.config.dget("GroupRoleSynchronizationGroupsAndRolesToSync").children().forEach(dynamic -> map.put(dynamic.key().convert().intoString(), dynamic.convert().intoString()));
        return map;
    }

    public Map<String, String> getCannedResponses() {
        HashMap<String, String> responses = new HashMap<String, String>();
        this.config.dget("DiscordCannedResponses").children().forEach(dynamic -> {
            String trigger = dynamic.key().convert().intoString();
            if (StringUtils.isEmpty(trigger)) {
                DiscordSRV.debug("Skipping canned response with empty trigger");
                return;
            }
            responses.put(trigger, dynamic.convert().intoString());
        });
        return responses;
    }

    public static int getTotalPlayerCount() {
        if (playerDataFolder == null) {
            return 0;
        }
        File[] playerFiles = playerDataFolder.listFiles(f -> f.getName().endsWith(".dat"));
        return playerFiles != null ? playerFiles.length : 0;
    }

    public static boolean isUpdateCheckDisabled() {
        return System.getenv("NoUpdateChecks") != null || System.getProperty("NoUpdateChecks") != null || DiscordSRV.config().getBooleanElse("UpdateCheckDisabled", false);
    }

    public boolean isGroupRoleSynchronizationEnabled() {
        return this.isGroupRoleSynchronizationEnabled(true);
    }

    public boolean isGroupRoleSynchronizationEnabled(boolean checkPermissions) {
        if (checkPermissions && this.groupSynchronizationManager.getPermissions() == null) {
            return false;
        }
        Map groupsAndRolesToSync = this.config.getMap("GroupRoleSynchronizationGroupsAndRolesToSync");
        if (groupsAndRolesToSync.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : groupsAndRolesToSync.entrySet()) {
            String roleId;
            String group = (String)entry.getKey();
            if (group.isEmpty() || (roleId = (String)entry.getValue()).isEmpty() || roleId.replace("0", "").trim().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getOptionalChannel(String name) {
        return this.getChannels().containsKey(name) ? name : this.getMainChatChannel();
    }

    public TextChannel getOptionalTextChannel(String gameChannel) {
        return this.getDestinationTextChannelForGameChannelName(this.getOptionalChannel(gameChannel));
    }

    public AccountLinkManager getAccountLinkManager() {
        return this.accountLinkManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public GroupSynchronizationManager getGroupSynchronizationManager() {
        return this.groupSynchronizationManager;
    }

    public IncompatibleClientManager getIncompatibleClientManager() {
        return this.incompatibleClientManager;
    }

    public ChannelTopicUpdater getChannelTopicUpdater() {
        return this.channelTopicUpdater;
    }

    public ChannelUpdater getChannelUpdater() {
        return this.channelUpdater;
    }

    public NicknameUpdater getNicknameUpdater() {
        return this.nicknameUpdater;
    }

    public PresenceUpdater getPresenceUpdater() {
        return this.presenceUpdater;
    }

    public ServerWatchdog getServerWatchdog() {
        return this.serverWatchdog;
    }

    public ScheduledExecutorService getUpdateChecker() {
        return this.updateChecker;
    }

    public AlertListener getAlertListener() {
        return this.alertListener;
    }

    public RequireLinkModule getRequireLinkModule() {
        return this.requireLinkModule;
    }

    public VoiceModule getVoiceModule() {
        return this.voiceModule;
    }

    public Map<String, String> getChannels() {
        return this.channels;
    }

    public Map<String, String> getRoleAliases() {
        return this.roleAliases;
    }

    public Map<Pattern, String> getConsoleRegexes() {
        return this.consoleRegexes;
    }

    public Map<Pattern, String> getGameRegexes() {
        return this.gameRegexes;
    }

    public Map<Pattern, String> getDiscordRegexes() {
        return this.discordRegexes;
    }

    public Map<Pattern, String> getWebhookUsernameRegexes() {
        return this.webhookUsernameRegexes;
    }

    public Set<String> getDebuggerCategories() {
        return this.debuggerCategories;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Gson getGson() {
        return this.gson;
    }

    public CancellationDetector<AsyncPlayerChatEvent> getLegacyCancellationDetector() {
        return this.legacyCancellationDetector;
    }

    public CancellationDetector<?> getModernCancellationDetector() {
        return this.modernCancellationDetector;
    }

    public boolean isModernChatEventAvailable() {
        return this.modernChatEventAvailable;
    }

    public Set<PluginHook> getPluginHooks() {
        return this.pluginHooks;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public File getMessagesFile() {
        return this.messagesFile;
    }

    public File getVoiceFile() {
        return this.voiceFile;
    }

    public File getLinkingFile() {
        return this.linkingFile;
    }

    public File getSynchronizationFile() {
        return this.synchronizationFile;
    }

    public File getAlertsFile() {
        return this.alertsFile;
    }

    public File getDebugFolder() {
        return this.debugFolder;
    }

    public File getLogFolder() {
        return this.logFolder;
    }

    public JDA getJda() {
        return this.jda;
    }

    public ChannelLoggingHandler getConsoleAppender() {
        return this.consoleAppender;
    }

    private static /* synthetic */ String lambda$sendLeaveMessage$64(String message, String name, String displayName, String avatarUrl, String botAvatarUrl, String botName, TextChannel textChannel, Player player, String content, Boolean needsEscape) {
        if (content == null) {
            return null;
        }
        content = content.replaceAll("%time%|%date%", TimeUtil.timeStamp()).replace("%message%", MessageUtil.strip(needsEscape != false ? DiscordUtil.escapeMarkdown(message) : message)).replace("%username%", MessageUtil.strip(needsEscape != false ? DiscordUtil.escapeMarkdown(name) : name)).replace("%displayname%", needsEscape != false ? DiscordUtil.escapeMarkdown(displayName) : displayName).replace("%usernamenoescapes%", name).replace("%displaynamenoescapes%", displayName).replace("%embedavatarurl%", avatarUrl).replace("%botavatarurl%", botAvatarUrl).replace("%botname%", botName);
        content = DiscordUtil.translateEmotes(content, textChannel.getGuild());
        content = PlaceholderUtil.replacePlaceholdersToDiscord(content, (OfflinePlayer)player);
        return content;
    }

    private static /* synthetic */ String lambda$sendJoinMessage$63(String message, String name, String displayName, String avatarUrl, String botAvatarUrl, String botName, TextChannel textChannel, Player player, String content, Boolean needsEscape) {
        if (content == null) {
            return null;
        }
        content = content.replaceAll("%time%|%date%", TimeUtil.timeStamp()).replace("%message%", MessageUtil.strip(needsEscape != false ? DiscordUtil.escapeMarkdown(message) : message)).replace("%username%", needsEscape != false ? DiscordUtil.escapeMarkdown(name) : name).replace("%displayname%", needsEscape != false ? DiscordUtil.escapeMarkdown(displayName) : displayName).replace("%usernamenoescapes%", name).replace("%displaynamenoescapes%", displayName).replace("%embedavatarurl%", avatarUrl).replace("%botavatarurl%", botAvatarUrl).replace("%botname%", botName);
        content = DiscordUtil.translateEmotes(content, textChannel.getGuild());
        content = PlaceholderUtil.replacePlaceholdersToDiscord(content, (OfflinePlayer)player);
        return content;
    }
}

