/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.api;

import com.hrakaroo.glob.GlobPattern;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.ListenerPriority;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.commands.CommandRegistrationError;
import github.scarsz.discordsrv.api.commands.PluginSlashCommand;
import github.scarsz.discordsrv.api.commands.SlashCommand;
import github.scarsz.discordsrv.api.commands.SlashCommandPriority;
import github.scarsz.discordsrv.api.commands.SlashCommandProvider;
import github.scarsz.discordsrv.api.events.Event;
import github.scarsz.discordsrv.api.events.GuildSlashCommandUpdateEvent;
import github.scarsz.discordsrv.dependencies.google.common.collect.Sets;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.SlashCommandEvent;
import github.scarsz.discordsrv.dependencies.jda.api.exceptions.ErrorResponseException;
import github.scarsz.discordsrv.dependencies.jda.api.hooks.ListenerAdapter;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.build.CommandData;
import github.scarsz.discordsrv.dependencies.jda.api.requests.ErrorResponse;
import github.scarsz.discordsrv.dependencies.jda.api.requests.GatewayIntent;
import github.scarsz.discordsrv.dependencies.jda.api.requests.RestAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.cache.CacheFlag;
import github.scarsz.discordsrv.util.LangUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.PluginClassLoader;
import org.jetbrains.annotations.NotNull;

public class ApiManager
extends ListenerAdapter {
    private final List<Object> apiListeners = new CopyOnWriteArrayList<Object>();
    private final Set<SlashCommandProvider> slashCommandProviders = new CopyOnWriteArraySet<SlashCommandProvider>();
    private final Set<PluginSlashCommand> runningCommandData = new HashSet<PluginSlashCommand>();
    private boolean anyHooked = false;
    private final EnumSet<GatewayIntent> intents = EnumSet.of(GatewayIntent.GUILD_MEMBERS, new GatewayIntent[]{GatewayIntent.GUILD_BANS, GatewayIntent.GUILD_EMOJIS, GatewayIntent.GUILD_VOICE_STATES, GatewayIntent.GUILD_MESSAGES, GatewayIntent.DIRECT_MESSAGES});
    private final EnumSet<CacheFlag> cacheFlags = EnumSet.of(CacheFlag.MEMBER_OVERRIDES, CacheFlag.VOICE_STATE, CacheFlag.EMOTE);

    public void subscribe(Object listener) {
        int methodsAnnotatedSubscribe = 0;
        for (Method method : listener.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Subscribe.class)) continue;
            ++methodsAnnotatedSubscribe;
        }
        if (methodsAnnotatedSubscribe == 0) {
            throw new IllegalArgumentException(listener.getClass().getName() + " attempted DiscordSRV API registration but no public methods inside of it were annotated @Subscribe (github.scarsz.discordsrv.api.Subscribe)");
        }
        if (!listener.getClass().getPackage().getName().contains("scarsz.discordsrv")) {
            DiscordSRV.info(LangUtil.InternalMessage.API_LISTENER_SUBSCRIBED.toString().replace("{listenername}", listener.getClass().getName()).replace("{methodcount}", String.valueOf(methodsAnnotatedSubscribe)));
            this.anyHooked = true;
        }
        this.apiListeners.add(listener);
    }

    public boolean unsubscribe(Object listener) {
        DiscordSRV.info(LangUtil.InternalMessage.API_LISTENER_UNSUBSCRIBED.toString().replace("{listenername}", listener.getClass().getName()));
        return this.apiListeners.remove(listener);
    }

    public <E extends Event> E callEvent(E event) {
        for (ListenerPriority listenerPriority : ListenerPriority.values()) {
            for (Object apiListener : this.apiListeners) {
                for (Method method : apiListener.getClass().getMethods()) {
                    Subscribe subscribeAnnotation;
                    if (method.getParameters().length != 1 || !method.getParameters()[0].getType().isAssignableFrom(event.getClass()) || (subscribeAnnotation = method.getAnnotation(Subscribe.class)) == null || subscribeAnnotation.priority() != listenerPriority) continue;
                    this.invokeMethod(method, apiListener, event);
                }
            }
        }
        return event;
    }

    public void updateSlashCommands() {
        HashSet<PluginSlashCommand> commands = new HashSet<PluginSlashCommand>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (!(plugin instanceof SlashCommandProvider)) continue;
            SlashCommandProvider provider = (SlashCommandProvider)plugin;
            commands.addAll(provider.getSlashCommands());
        }
        this.slashCommandProviders.forEach(p -> commands.addAll(p.getSlashCommands()));
        int conflictingCommands = 0;
        HashMap<String, PluginSlashCommand> conflictResolvedCommands = new HashMap<String, PluginSlashCommand>();
        for (PluginSlashCommand pluginSlashCommand : commands) {
            String name = pluginSlashCommand.getCommandData().getName();
            PluginSlashCommand conflictingCommand = conflictResolvedCommands.putIfAbsent(name, pluginSlashCommand);
            if (conflictingCommand == null) continue;
            ++conflictingCommands;
            if (pluginSlashCommand.getPriority().ordinal() >= conflictingCommand.getPriority().ordinal()) continue;
            conflictResolvedCommands.put(name, pluginSlashCommand);
        }
        this.runningCommandData.clear();
        this.runningCommandData.addAll(conflictResolvedCommands.values());
        int cancelledGuilds = 0;
        HashSet<RestAction<List>> guildCommandUpdateActions = new HashSet<RestAction<List>>();
        Set errors = Collections.synchronizedSet(new HashSet());
        for (Guild guild : DiscordSRV.getPlugin().getJda().getGuilds()) {
            Set<CommandData> commandSet;
            GuildSlashCommandUpdateEvent event = DiscordSRV.api.callEvent(new GuildSlashCommandUpdateEvent(guild, commandSet = conflictResolvedCommands.values().stream().filter(command -> command.isApplicable(guild)).map(PluginSlashCommand::getCommandData).collect(Collectors.toSet())));
            if (event.isCancelled()) {
                ++cancelledGuilds;
                continue;
            }
            guildCommandUpdateActions.add(guild.updateCommands().addCommands(commandSet).onErrorMap(throwable -> {
                errors.add(new CommandRegistrationError(guild, (Throwable)throwable));
                return null;
            }));
        }
        int finalCancelledGuilds = cancelledGuilds;
        int finalConflictingCommands = conflictingCommands;
        RestAction.allOf(guildCommandUpdateActions).queue(all -> {
            int successful = all.stream().filter(Objects::nonNull).mapToInt(List::size).sum();
            long pluginCount = conflictResolvedCommands.values().stream().map(PluginSlashCommand::getPlugin).distinct().count();
            long registeredGuilds = all.stream().filter(Objects::nonNull).count();
            int totalGuilds = DiscordSRV.getPlugin().getJda().getGuilds().size();
            if (successful > 0) {
                DiscordSRV.info("Successfully registered " + successful + " slash commands (" + finalConflictingCommands + " conflicted) for " + pluginCount + " plugins in " + registeredGuilds + "/" + totalGuilds + " guilds (" + finalCancelledGuilds + " cancelled)");
            } else {
                DiscordSRV.info("Cleared all pre-existing slash commands in " + registeredGuilds + "/" + totalGuilds + " guilds (" + finalCancelledGuilds + " cancelled)");
            }
            if (errors.isEmpty()) {
                return;
            }
            for (CommandRegistrationError error : errors) {
                Throwable exception = error.getException();
                Guild guild = error.getGuild();
                if (!(exception instanceof ErrorResponseException)) {
                    DiscordSRV.warning("Unexpected error adding slash commands in server " + guild.getName() + ": " + exception.toString());
                    continue;
                }
                ErrorResponseException errorResponseException = (ErrorResponseException)exception;
                ErrorResponse response = errorResponseException.getErrorResponse();
                if (response == ErrorResponse.MISSING_ACCESS) {
                    DiscordSRV.warning("Missing scopes in " + guild.getName() + " (" + guild.getId() + ")");
                    continue;
                }
                DiscordSRV.warning("Failed to register slash commands in guild " + guild.getName() + " (" + guild.getId() + ") due to error: " + errorResponseException.getMeaning());
            }
            DiscordSRV.error("Until this is fixed, plugin slash commands won't work properly in the specified guilds.");
            if (errors.stream().anyMatch(r -> r.getException() instanceof ErrorResponseException && ((ErrorResponseException)r.getException()).getErrorResponse() == ErrorResponse.MISSING_ACCESS)) {
                String invite = "https://scarsz.me/authorize#";
                try {
                    invite = invite + DiscordSRV.getPlugin().getJda().getSelfUser().getApplicationId();
                }
                catch (IllegalStateException e) {
                    invite = invite + DiscordSRV.getPlugin().getJda().retrieveApplicationInfo().complete().getId();
                }
                DiscordSRV.error("Re-authorize your bot at " + invite + " to the respective guild to grant the applications.commands slash commands scope.");
            }
            for (CommandRegistrationError error : errors) {
                DiscordSRV.debug(error.getException(), error.getGuild().toString());
            }
        });
    }

    public void addSlashCommandProvider(@NonNull SlashCommandProvider provider) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        if (provider instanceof Plugin) {
            return;
        }
        this.slashCommandProviders.add(provider);
    }

    public boolean removeSlashCommandProvider(@NonNull SlashCommandProvider provider) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        return this.slashCommandProviders.remove(provider);
    }

    @Override
    public void onSlashCommand(@NotNull SlashCommandEvent event) {
        PluginSlashCommand commandData = this.runningCommandData.stream().filter(command -> command.isApplicable(event.getGuild())).filter(command -> command.getCommandData().getName().equals(event.getName())).findFirst().orElse(null);
        if (commandData == null) {
            return;
        }
        HashSet<SlashCommandProvider> providers = new HashSet<SlashCommandProvider>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (!(plugin instanceof SlashCommandProvider)) continue;
            providers.add((SlashCommandProvider)plugin);
        }
        providers.addAll(this.slashCommandProviders);
        boolean handled = false;
        for (SlashCommandPriority priority : SlashCommandPriority.values()) {
            for (SlashCommandProvider provider : providers) {
                handled |= this.handleSlashCommandEvent(provider, commandData, event, priority);
            }
        }
        if (handled) {
            this.ackCheck(event, commandData.getPlugin());
        }
    }

    private boolean handleSlashCommandEvent(SlashCommandProvider provider, PluginSlashCommand commandData, SlashCommandEvent event, SlashCommandPriority priority) {
        for (Method method : provider.getClass().getMethods()) {
            for (SlashCommand slashCommand : (SlashCommand[])method.getAnnotationsByType(SlashCommand.class)) {
                if (slashCommand.priority() != priority || !slashCommand.ignoreAcknowledged() && event.isAcknowledged() || !GlobPattern.compile(slashCommand.path()).matches(event.getCommandPath()) || method.getParameters().length != 1 || !method.getParameters()[0].getType().equals(SlashCommandEvent.class)) continue;
                if (!slashCommand.deferReply()) {
                    this.invokeMethod(method, provider, event);
                } else {
                    event.deferReply(slashCommand.deferEphemeral()).queue(hook -> this.invokeMethod(method, provider, event));
                }
                return true;
            }
        }
        return false;
    }

    private boolean invokeMethod(Method method, Object instance, Object ... args) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            method.invoke(instance, method.getParameterCount() == 0 ? null : args);
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            DiscordSRV.debug(instance.getClass().getName() + "#" + method.getName() + " threw an error: " + cause);
            if (!this.logException(method.getClass(), cause)) {
                cause.printStackTrace();
            }
        }
        catch (IllegalAccessException e) {
            DiscordSRV.error(LangUtil.InternalMessage.API_LISTENER_METHOD_NOT_ACCESSIBLE.toString().replace("{listenername}", method.getClass().getName()).replace("{methodname}", method.toString()), e);
        }
        return false;
    }

    private boolean logException(Class<?> offendingClass, Throwable throwable) {
        try {
            ClassLoader classLoader = offendingClass.getClassLoader();
            if (classLoader instanceof PluginClassLoader) {
                JavaPlugin owner = ((PluginClassLoader)classLoader).getPlugin();
                DiscordSRV.logThrowable(throwable, owner.getLogger()::severe);
                return true;
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        return false;
    }

    private void ackCheck(SlashCommandEvent event, Plugin badPlugin) {
        if (!event.isAcknowledged()) {
            DiscordSRV.error(String.format("Slash command \"/%s\" was not acknowledged by %s's handler! The command will show as failed on Discord until this is fixed!", event.getCommandPath().replace("/", " "), badPlugin.getName()));
        }
    }

    public void requireIntent(GatewayIntent gatewayIntent) {
        if (DiscordSRV.getPlugin().getJda() != null) {
            throw new IllegalStateException("Intents must be required before JDA initializes");
        }
        this.intents.add(gatewayIntent);
        DiscordSRV.debug("Gateway intent " + (Object)((Object)gatewayIntent) + " has been required through the API");
    }

    public void requireCacheFlag(CacheFlag cacheFlag) {
        if (DiscordSRV.getPlugin().getJda() != null) {
            throw new IllegalStateException("Cache flags must be required before JDA initializes");
        }
        this.cacheFlags.add(cacheFlag);
        DiscordSRV.debug("Cache flag " + (Object)((Object)cacheFlag) + " has been required through the API");
    }

    public Set<GatewayIntent> getIntents() {
        return Sets.immutableEnumSet(this.intents);
    }

    public Set<CacheFlag> getCacheFlags() {
        return Sets.immutableEnumSet(this.cacheFlags);
    }

    public boolean isAnyHooked() {
        return this.anyHooked;
    }
}

