/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.api.commands;

import github.scarsz.discordsrv.api.commands.SlashCommandPriority;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.build.CommandData;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.bukkit.plugin.Plugin;

public final class PluginSlashCommand {
    private final Plugin plugin;
    private final CommandData commandData;
    private final Set<String> guilds = new HashSet<String>();
    private SlashCommandPriority priority;

    public PluginSlashCommand(Plugin plugin, CommandData commandData) {
        this(plugin, commandData, SlashCommandPriority.NORMAL);
    }

    public PluginSlashCommand(Plugin plugin, CommandData commandData, SlashCommandPriority priority) {
        this(plugin, commandData, priority, (String[])null);
    }

    public PluginSlashCommand(Plugin plugin, CommandData commandData, String ... guildIds) {
        this(plugin, commandData, SlashCommandPriority.NORMAL, guildIds);
    }

    public PluginSlashCommand(Plugin plugin, CommandData commandData, SlashCommandPriority priority, String ... guildIds) {
        this.plugin = plugin;
        this.commandData = commandData;
        this.priority = priority;
        if (guildIds != null) {
            Collections.addAll(this.guilds, guildIds);
        }
    }

    public boolean isApplicable(Guild guild) {
        if (guild == null) {
            return false;
        }
        return this.guilds.isEmpty() || this.guilds.contains(guild.getId());
    }

    public PluginSlashCommand addGuildFilter(Guild guild) {
        return this.addGuildFilter(guild.getId());
    }

    public PluginSlashCommand addGuildFilter(String guildId) {
        this.guilds.add(guildId);
        return this;
    }

    public PluginSlashCommand removeGuildFilter(Guild guild) {
        return this.removeGuildFilter(guild.getId());
    }

    public PluginSlashCommand removeGuildFilter(String guildId) {
        this.guilds.remove(guildId);
        return this;
    }

    public PluginSlashCommand setPriority(SlashCommandPriority priority) {
        this.priority = priority;
        return this;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public CommandData getCommandData() {
        return this.commandData;
    }

    public Set<String> getGuilds() {
        return this.guilds;
    }

    public SlashCommandPriority getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginSlashCommand)) {
            return false;
        }
        PluginSlashCommand that = (PluginSlashCommand)o;
        return Objects.equals(this.getPlugin(), that.getPlugin()) && Objects.equals(this.getCommandData(), that.getCommandData()) && this.getGuilds().equals(that.getGuilds()) && this.getPriority() == that.getPriority();
    }

    public int hashCode() {
        int result = Objects.hashCode(this.getPlugin());
        result = 31 * result + Objects.hashCode(this.getCommandData());
        result = 31 * result + this.getGuilds().hashCode();
        result = 31 * result + Objects.hashCode((Object)this.getPriority());
        return result;
    }

    public String toString() {
        return "PluginSlashCommand(plugin=" + this.getPlugin() + ", commandData=" + this.getCommandData() + ", guilds=" + this.getGuilds() + ", priority=" + (Object)((Object)this.getPriority()) + ")";
    }
}

