/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.api.events;

import github.scarsz.discordsrv.api.events.GameEvent;
import github.scarsz.discordsrv.dependencies.jda.api.MessageBuilder;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;

public class AchievementMessagePostProcessEvent
extends GameEvent<Event>
implements Cancellable {
    private boolean cancelled;
    private final String achievementName;
    private String channel;
    private Message discordMessage;
    private boolean usingWebhooks;
    private String webhookName;
    private String webhookAvatarUrl;

    public AchievementMessagePostProcessEvent(String channel, Message discordMessage, Player player, String achievementName, Event triggeringBukkitEvent, boolean usingWebhooks, String webhookName, String webhookAvatarUrl, boolean cancelled) {
        super(player, triggeringBukkitEvent);
        this.channel = channel;
        this.discordMessage = discordMessage;
        this.achievementName = achievementName;
        this.usingWebhooks = usingWebhooks;
        this.webhookName = webhookName;
        this.webhookAvatarUrl = webhookAvatarUrl;
        this.setCancelled(cancelled);
    }

    @Deprecated
    public AchievementMessagePostProcessEvent(String channel, Message discordMessage, Player player, String achievementName, boolean usingWebhooks, String webhookName, String webhookAvatarUrl, boolean cancelled) {
        super(player, null);
        this.channel = channel;
        this.discordMessage = discordMessage;
        this.achievementName = achievementName;
        this.usingWebhooks = usingWebhooks;
        this.webhookName = webhookName;
        this.webhookAvatarUrl = webhookAvatarUrl;
        this.setCancelled(cancelled);
    }

    @Deprecated
    public AchievementMessagePostProcessEvent(String channel, String processedMessage, Player player, String achievementName, boolean cancelled) {
        super(player, null);
        this.channel = channel;
        this.discordMessage = new MessageBuilder().setContent(processedMessage).build();
        this.achievementName = achievementName;
        this.setCancelled(cancelled);
    }

    @Deprecated
    public String getProcessedMessage() {
        return this.discordMessage.getContentRaw();
    }

    @Deprecated
    public void setProcessedMessage(String processedMessage) {
        this.discordMessage = new MessageBuilder(processedMessage).build();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getAchievementName() {
        return this.achievementName;
    }

    public String getChannel() {
        return this.channel;
    }

    public Message getDiscordMessage() {
        return this.discordMessage;
    }

    public boolean isUsingWebhooks() {
        return this.usingWebhooks;
    }

    public String getWebhookName() {
        return this.webhookName;
    }

    public String getWebhookAvatarUrl() {
        return this.webhookAvatarUrl;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setDiscordMessage(Message discordMessage) {
        this.discordMessage = discordMessage;
    }

    public void setUsingWebhooks(boolean usingWebhooks) {
        this.usingWebhooks = usingWebhooks;
    }

    public void setWebhookName(String webhookName) {
        this.webhookName = webhookName;
    }

    public void setWebhookAvatarUrl(String webhookAvatarUrl) {
        this.webhookAvatarUrl = webhookAvatarUrl;
    }
}

