/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.commands;

import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.commands.Command;
import github.scarsz.discordsrv.util.DebugUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

public class CommandDebugger {
    @Command(commandNames={"debugger"}, helpMessage="A toggleable timings-like command to dump debug information to bin.scarsz.me", permission="discordsrv.debug")
    public static void execute(CommandSender sender, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        String subCommand = arguments.isEmpty() ? "start" : (String)arguments.remove(0);
        boolean upload = false;
        if (subCommand.equalsIgnoreCase("start") || subCommand.equalsIgnoreCase("on")) {
            HashSet<String> validArguments = new HashSet<String>();
            for (String argument : arguments) {
                boolean anyValid = false;
                for (Debug value : Debug.values()) {
                    if (!value.matches(argument)) continue;
                    anyValid = true;
                    break;
                }
                if (!anyValid) {
                    sender.sendMessage(ChatColor.RED + "Invalid debug category: " + ChatColor.DARK_RED + argument);
                    continue;
                }
                validArguments.add(argument);
            }
            if (validArguments.isEmpty()) {
                DiscordSRV.getPlugin().getDebuggerCategories().add(Debug.UNCATEGORIZED.name());
            } else {
                DiscordSRV.getPlugin().getDebuggerCategories().addAll(validArguments);
            }
            sender.sendMessage(ChatColor.DARK_AQUA + "Debugger enabled, use " + ChatColor.GRAY + "/discordsrv debugger stop " + ChatColor.DARK_AQUA + "to stop debugging or " + ChatColor.GRAY + "/discordsrv debugger upload " + ChatColor.DARK_AQUA + "to stop debugging and generate a debug report");
            return;
        }
        if (subCommand.equalsIgnoreCase("stop") || subCommand.equalsIgnoreCase("off") || (upload = subCommand.equalsIgnoreCase("upload"))) {
            if (upload) {
                String result = DebugUtil.run(sender instanceof ConsoleCommandSender ? "CONSOLE" : sender.getName(), arguments.size() == 0 ? 256 : Integer.parseInt((String)arguments.get(0)));
                sender.sendMessage(ChatColor.DARK_AQUA + "Your debug report has been generated and is available at " + ChatColor.AQUA + result);
            } else {
                sender.sendMessage(ChatColor.DARK_AQUA + "Debugger disabled");
            }
            DiscordSRV.getPlugin().getDebuggerCategories().clear();
            return;
        }
        sender.sendMessage(ChatColor.RED + "Invalid subcommand " + ChatColor.DARK_RED + subCommand);
    }
}

