/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.commands;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.commands.Command;
import github.scarsz.discordsrv.util.GamePermissionUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

public class CommandHelp {
    private static List<ChatColor> disallowedChatColorCharacters = new ArrayList<ChatColor>(){
        {
            this.add(ChatColor.BLACK);
            this.add(ChatColor.DARK_BLUE);
            this.add(ChatColor.GRAY);
            this.add(ChatColor.DARK_GRAY);
            this.add(ChatColor.WHITE);
            this.add(ChatColor.MAGIC);
            this.add(ChatColor.BOLD);
            this.add(ChatColor.STRIKETHROUGH);
            this.add(ChatColor.UNDERLINE);
            this.add(ChatColor.ITALIC);
            this.add(ChatColor.RESET);
        }
    };

    @Command(commandNames={"?", "help"}, helpMessage="Shows command help for DiscordSRV's commands", permission="discordsrv.help", usageExample="help [command]")
    public static void execute(CommandSender sender, String[] args) {
        if (args.length == 0) {
            CommandHelp.help(sender);
        } else {
            CommandHelp.help(sender, Arrays.asList(args));
        }
    }

    private static void help(CommandSender sender) {
        ChatColor titleColor = ChatColor.RESET;
        ChatColor commandColor = ChatColor.RESET;
        while (disallowedChatColorCharacters.contains(titleColor)) {
            titleColor = ChatColor.values()[ThreadLocalRandom.current().nextInt(ChatColor.values().length)];
        }
        while (disallowedChatColorCharacters.contains(commandColor) || commandColor == titleColor) {
            commandColor = ChatColor.values()[ThreadLocalRandom.current().nextInt(ChatColor.values().length)];
        }
        ArrayList<Method> commandMethods = new ArrayList<Method>();
        for (Method method : DiscordSRV.getPlugin().getCommandManager().getCommands().values()) {
            if (commandMethods.contains(method)) continue;
            commandMethods.add(method);
        }
        MessageUtil.sendMessage(sender, ChatColor.DARK_GRAY + "================[ " + titleColor + "DiscordSRV" + ChatColor.DARK_GRAY + " ]================");
        for (Method commandMethod : commandMethods) {
            Command commandAnnotation = commandMethod.getAnnotation(Command.class);
            if (!GamePermissionUtil.hasPermission((Permissible)sender, commandAnnotation.permission())) continue;
            MessageUtil.sendMessage(sender, ChatColor.GRAY + "- " + commandColor + "/discord " + String.join((CharSequence)"/", commandAnnotation.commandNames()));
            MessageUtil.sendMessage(sender, "    " + ChatColor.ITALIC + commandAnnotation.helpMessage());
            if (commandAnnotation.usageExample().equals("")) continue;
            MessageUtil.sendMessage(sender, "    " + ChatColor.GRAY + ChatColor.ITALIC + "ex. /discord " + commandAnnotation.usageExample());
        }
    }

    private static void help(CommandSender sender, List<String> commands) {
        ChatColor titleColor = ChatColor.RESET;
        ChatColor commandColor = ChatColor.RESET;
        while (disallowedChatColorCharacters.contains(titleColor)) {
            titleColor = ChatColor.values()[ThreadLocalRandom.current().nextInt(ChatColor.values().length - 1)];
        }
        while (disallowedChatColorCharacters.contains(commandColor) || commandColor == titleColor) {
            commandColor = ChatColor.values()[ThreadLocalRandom.current().nextInt(ChatColor.values().length - 1)];
        }
        LinkedList<Method> commandMethodsList = new LinkedList<Method>();
        Map<String, Method> commandMethods = DiscordSRV.getPlugin().getCommandManager().getCommands();
        for (String commandName : commands) {
            if (!commandMethods.containsKey(commandName)) continue;
            commandMethodsList.add(DiscordSRV.getPlugin().getCommandManager().getCommands().get(commandName));
        }
        if (commandMethodsList.isEmpty()) {
            MessageUtil.sendMessage(sender, LangUtil.Message.COMMAND_DOESNT_EXIST.toString());
            return;
        }
        MessageUtil.sendMessage(sender, ChatColor.DARK_GRAY + "===================[ " + titleColor + "DiscordSRV" + ChatColor.DARK_GRAY + " ]===================");
        for (Method commandMethod : commandMethodsList) {
            Command commandAnnotation = commandMethod.getAnnotation(Command.class);
            if (!GamePermissionUtil.hasPermission((Permissible)sender, commandAnnotation.permission())) continue;
            MessageUtil.sendMessage(sender, ChatColor.GRAY + "- " + commandColor + "/discord " + String.join((CharSequence)"/", commandAnnotation.commandNames()));
            MessageUtil.sendMessage(sender, "   " + ChatColor.ITALIC + commandAnnotation.helpMessage());
            if (commandAnnotation.usageExample().equals("")) continue;
            MessageUtil.sendMessage(sender, "   " + ChatColor.GRAY + ChatColor.ITALIC + "ex. /discord " + commandAnnotation.usageExample());
        }
    }
}

