/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.commands;

import github.scarsz.configuralize.Language;
import github.scarsz.configuralize.Provider;
import github.scarsz.configuralize.Source;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.commands.Command;
import github.scarsz.discordsrv.dependencies.commons.io.FileUtils;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.TextComponent;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.event.ClickEvent;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.event.HoverEvent;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.format.NamedTextColor;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.format.TextColor;
import github.scarsz.discordsrv.util.MessageUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandLanguage {
    @Command(commandNames={"language", "setlanguage", "lang", "setlang"}, helpMessage="Changes the language of DiscordSRV to whatever is specified.", permission="discordsrv.language", usageExample="language japanese")
    public static void execute(CommandSender sender, String[] args) throws IOException {
        Language currentLanguage = DiscordSRV.config().getLanguage();
        String currentLanguageName = StringUtils.capitalize(currentLanguage.getName().toLowerCase());
        Language targetLanguage = null;
        block0: for (String arg : args) {
            for (Language language2 : Language.values()) {
                if (!language2.getCode().equalsIgnoreCase(arg) && !language2.getName().equalsIgnoreCase(arg)) continue;
                targetLanguage = language2;
                break block0;
            }
        }
        if (targetLanguage == null) {
            MessageUtil.sendMessage(sender, ChatColor.DARK_AQUA + "DiscordSRV is currently in " + currentLanguageName + ". Change it by giving a language as an argument.");
            return;
        }
        String targetLanguageName = StringUtils.capitalize(targetLanguage.getName().toLowerCase());
        if (!DiscordSRV.config().isLanguageAvailable(targetLanguage)) {
            String available = Arrays.stream(Language.values()).filter(DiscordSRV.config()::isLanguageAvailable).map(language -> StringUtils.capitalize(language.getName().toLowerCase())).collect(Collectors.joining(", "));
            MessageUtil.sendMessage(sender, ChatColor.DARK_AQUA + "DiscordSRV does not have a translation for " + targetLanguageName + ". Supported languages are as follows: " + available + ".");
            return;
        }
        if (Arrays.stream(args).noneMatch(s -> s.equalsIgnoreCase("-confirm"))) {
            TextComponent message = (TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text("This will reset your DiscordSRV configuration files to be in ", (TextColor)NamedTextColor.DARK_AQUA).append(Component.text(targetLanguageName, (TextColor)NamedTextColor.WHITE))).append(Component.text(". Your old config files will be renamed to have ", (TextColor)NamedTextColor.DARK_AQUA))).append(Component.text(currentLanguageName + ".", (TextColor)NamedTextColor.WHITE))).append(Component.text(" on the beginning of the file name. "))).append((Component)((TextComponent)((TextComponent)Component.text("[Confirm" + (sender instanceof Player ? "?" : " by running the command again, adding \" -confirm\" to the end") + "]").color(NamedTextColor.GREEN)).clickEvent(ClickEvent.runCommand("/discord language " + targetLanguage.getCode() + " -confirm"))).hoverEvent(HoverEvent.showText(Component.text("Click to confirm the config change.", (TextColor)NamedTextColor.GREEN))));
            MessageUtil.sendMessage(sender, (Component)message);
        } else {
            DiscordSRV.config().setLanguage(targetLanguage);
            for (Map.Entry<Source, Provider> entry : DiscordSRV.config().getSources().entrySet()) {
                File source = entry.getKey().getFile();
                File target = new File(source.getParentFile(), currentLanguageName + "." + source.getName());
                FileUtils.moveFile(source, target);
                entry.getValue().saveDefaults();
                if (!entry.getKey().getResourceName().equals("config")) continue;
                String file = FileUtils.readFileToString(source, "UTF-8");
                file = file.replace("\nForcedLanguage: none", "\nForcedLanguage: " + targetLanguageName);
                FileUtils.writeStringToFile(source, file, "UTF-8");
            }
            MessageUtil.sendMessage(sender, ChatColor.DARK_AQUA + "DiscordSRV language successfully changed to " + targetLanguageName + ".");
        }
    }
}

