/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.commands;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.commands.Command;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.event.ClickEvent;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.event.HoverEvent;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.format.StyleSetter;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import github.scarsz.discordsrv.objects.managers.AccountLinkManager;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.GamePermissionUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class CommandLink {
    @Command(commandNames={"link"}, helpMessage="Generates a code to link your Minecraft account to your Discord account", permission="discordsrv.link")
    public static void execute(CommandSender sender, String[] args) {
        AccountLinkManager manager = DiscordSRV.getPlugin().getAccountLinkManager();
        if (manager == null) {
            MessageUtil.sendMessage(sender, LangUtil.Message.UNABLE_TO_LINK_ACCOUNTS_RIGHT_NOW.toString());
            return;
        }
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> CommandLink.executeAsync(sender, args, manager));
    }

    private static void executeAsync(CommandSender sender, String[] args, AccountLinkManager manager) {
        if (args.length >= 2) {
            if (!GamePermissionUtil.hasPermission((Permissible)sender, "discordsrv.link.others")) {
                sender.sendMessage(LangUtil.Message.NO_PERMISSION.toString());
                return;
            }
            ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
            String minecraft = (String)arguments.remove(0);
            String discord = String.join((CharSequence)" ", arguments);
            OfflinePlayer offlinePlayer = null;
            try {
                offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(minecraft));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (offlinePlayer == null) {
                offlinePlayer = Bukkit.getOfflinePlayer((String)minecraft);
            }
            if (offlinePlayer == null) {
                MessageUtil.sendMessage(sender, ChatColor.RED + "Minecraft player could not be found");
                return;
            }
            User user = null;
            try {
                user = DiscordUtil.getJda().getUserById(discord);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (user == null) {
                try {
                    user = DiscordUtil.getJda().getUserByTag(discord);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (user == null) {
                MessageUtil.sendMessage(sender, ChatColor.RED + "Discord user could not be found");
                return;
            }
            DiscordSRV.getPlugin().getAccountLinkManager().link(user.getId(), offlinePlayer.getUniqueId());
            MessageUtil.sendMessage(sender, ChatColor.GREEN + "Linked together " + ChatColor.GOLD + offlinePlayer.getName() + ChatColor.GREEN + " and " + ChatColor.GOLD + user.getAsTag());
            return;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + LangUtil.InternalMessage.PLAYER_ONLY_COMMAND.toString());
            return;
        }
        Player player = (Player)sender;
        new ArrayList<Map.Entry<String, UUID>>(manager.getLinkingCodes().entrySet()).stream().filter(entry -> ((UUID)entry.getValue()).equals(player.getUniqueId())).forEach(match -> manager.getLinkingCodes().remove(match.getKey()));
        if (manager.getDiscordId(player.getUniqueId()) != null) {
            MessageUtil.sendMessage(sender, LangUtil.Message.ACCOUNT_ALREADY_LINKED.toString());
        } else {
            String code = manager.generateCode(player.getUniqueId());
            String message = LangUtil.Message.CODE_GENERATED.toString().replace("%code%", code).replace("%botname%", DiscordSRV.getPlugin().getMainGuild().getSelfMember().getEffectiveName());
            message = PlaceholderUtil.replacePlaceholders(message, Bukkit.getOfflinePlayer((UUID)player.getUniqueId()));
            StyleSetter<Component> component = LegacyComponentSerializer.builder().character('&').extractUrls().build().deserialize(message);
            String clickToCopyCode = LangUtil.Message.CLICK_TO_COPY_CODE.toString();
            if (StringUtils.isNotBlank(clickToCopyCode)) {
                component = component.clickEvent(ClickEvent.copyToClipboard(code)).hoverEvent(HoverEvent.showText(LegacyComponentSerializer.legacy('&').deserialize(clickToCopyCode)));
            }
            MessageUtil.sendMessage(sender, (Component)component);
        }
    }
}

