/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.commands;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.commands.Command;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PrettyUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandLinked {
    @Command(commandNames={"linked"}, helpMessage="Checks what Discord user your (or someone else's) MC account is linked to", permission="discordsrv.linked")
    public static void execute(CommandSender sender, String[] args) {
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> CommandLinked.executeAsync(sender, args));
    }

    private static void executeAsync(CommandSender sender, String[] args) {
        if (args.length == 0) {
            boolean hasLinkedAccount;
            if (!(sender instanceof Player)) {
                MessageUtil.sendMessage(sender, LangUtil.Message.LINKED_NOBODY_FOUND.toString().replace("%target%", "CONSOLE"));
                return;
            }
            String linkedId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(((Player)sender).getUniqueId());
            boolean bl = hasLinkedAccount = linkedId != null;
            if (hasLinkedAccount) {
                Member member2 = DiscordUtil.getMemberById(linkedId);
                String name = member2 != null ? member2.getEffectiveName() : "Discord ID " + linkedId;
                MessageUtil.sendMessage(sender, LangUtil.Message.LINKED_SUCCESS.toString().replace("%name%", name));
            } else {
                MessageUtil.sendMessage(sender, LangUtil.Message.LINK_FAIL_NOT_ASSOCIATED_WITH_AN_ACCOUNT.toString());
            }
        } else {
            if (!sender.hasPermission("discordsrv.linked.others")) {
                MessageUtil.sendMessage(sender, LangUtil.Message.NO_PERMISSION.toString());
                return;
            }
            String target = args[0];
            String joinedTarget = String.join((CharSequence)" ", args);
            if (args.length == 1 && target.length() == 32 || target.length() == 36) {
                CommandLinked.notifyInterpret(sender, "UUID");
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(target));
                CommandLinked.notifyPlayer(sender, player);
                CommandLinked.notifyDiscord(sender, DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player.getUniqueId()));
                return;
            }
            if (args.length == 1 && DiscordUtil.getUserById(target) != null || StringUtils.isNumeric(target) && target.length() >= 17 && target.length() <= 20) {
                CommandLinked.notifyInterpret(sender, "Discord ID");
                UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(target);
                CommandLinked.notifyPlayer(sender, uuid != null ? Bukkit.getOfflinePlayer((UUID)uuid) : null);
                CommandLinked.notifyDiscord(sender, target);
                return;
            }
            if (joinedTarget.contains("#") || joinedTarget.length() >= 2 && joinedTarget.length() <= 37) {
                String targetUsername = joinedTarget.contains("#") ? joinedTarget.split("#")[0] : joinedTarget;
                String discriminator = joinedTarget.contains("#") ? joinedTarget.split("#")[1] : "";
                Set matches = DiscordUtil.getJda().getGuilds().stream().flatMap(guild -> guild.getMembers().stream()).filter(member -> member.getUser().getName().equalsIgnoreCase(targetUsername) || member.getNickname() != null && member.getNickname().equalsIgnoreCase(targetUsername)).filter(member -> member.getUser().getDiscriminator().contains(discriminator)).map(Member::getUser).collect(Collectors.toSet());
                if (matches.size() >= 1) {
                    CommandLinked.notifyInterpret(sender, "Discord name");
                    matches.stream().limit(5L).forEach(user -> {
                        UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(user.getId());
                        CommandLinked.notifyPlayer(sender, uuid != null ? Bukkit.getOfflinePlayer((UUID)uuid) : null);
                        CommandLinked.notifyDiscord(sender, user.getId());
                    });
                    int remaining = matches.size() - 5;
                    if (remaining >= 1) {
                        MessageUtil.sendMessage(sender, String.format("%s+%s%d%s more result%s...", ChatColor.AQUA, ChatColor.WHITE, remaining, ChatColor.AQUA, remaining > 1 ? "s" : ""));
                    }
                    return;
                }
            }
            if (args.length == 1 && target.length() >= 3 && target.length() <= 16) {
                OfflinePlayer player = Bukkit.getOnlinePlayers().stream().filter(p -> p.getName().equalsIgnoreCase(target)).findFirst().orElse(null);
                if (player == null) {
                    player = Arrays.stream(Bukkit.getOfflinePlayers()).filter(p -> p.getName() != null && p.getName().equalsIgnoreCase(target)).findFirst().orElse(null);
                }
                if (player == null && (player = Bukkit.getOfflinePlayer((String)target)).getName() == null) {
                    player = null;
                }
                if (player != null) {
                    CommandLinked.notifyInterpret(sender, "Minecraft player");
                    CommandLinked.notifyPlayer(sender, player);
                    CommandLinked.notifyDiscord(sender, DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player.getUniqueId()));
                    return;
                }
            }
            MessageUtil.sendMessage(sender, LangUtil.Message.LINKED_NOBODY_FOUND.toString().replace("%target%", joinedTarget));
        }
    }

    static void notifyInterpret(CommandSender sender, String type) {
        MessageUtil.sendMessage(sender, String.format("%sInterpreted target as %s%s", ChatColor.AQUA, ChatColor.WHITE, type));
    }

    static void notifyPlayer(CommandSender sender, OfflinePlayer player) {
        MessageUtil.sendMessage(sender, String.format("%s-%s Player: %s%s", ChatColor.WHITE, ChatColor.AQUA, ChatColor.WHITE, PrettyUtil.beautifyNickname(player)));
    }

    static void notifyDiscord(CommandSender sender, String discordId) {
        User user = DiscordUtil.getUserById(discordId);
        String discordInfo = (user != null ? " (" + user.getName() + "#" + user.getDiscriminator() + ")" : "") + " " + discordId;
        MessageUtil.sendMessage(sender, String.format("%s-%s Discord: %s%s%s", ChatColor.WHITE, ChatColor.AQUA, ChatColor.WHITE, PrettyUtil.beautify(user), discordInfo));
    }
}

