/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.commands;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.commands.Command;
import github.scarsz.discordsrv.objects.managers.GroupSynchronizationManager;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class CommandResync {
    @Command(commandNames={"resync"}, helpMessage="Resynchronizes all groups & roles", permission="discordsrv.resync")
    public static void execute(CommandSender sender, String[] args) {
        if (!DiscordSRV.getPlugin().isGroupRoleSynchronizationEnabled()) {
            MessageUtil.sendMessage(sender, ChatColor.RED + LangUtil.InternalMessage.RESYNC_WHEN_GROUP_SYNC_DISABLED.toString());
            return;
        }
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> {
            MessageUtil.sendMessage(sender, ChatColor.AQUA + "Full group synchronization triggered.");
            long time = System.currentTimeMillis();
            DiscordSRV.getPlugin().getGroupSynchronizationManager().resyncEveryone(GroupSynchronizationManager.SyncCause.MANUAL);
            time = System.currentTimeMillis() - time;
            int seconds = Math.toIntExact(TimeUnit.MILLISECONDS.toSeconds(time));
            MessageUtil.sendMessage(sender, ChatColor.AQUA + "Full group synchronization finished, taking " + seconds + " seconds.");
        });
    }
}

