/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.commands;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.commands.Command;
import github.scarsz.discordsrv.commands.CommandLinked;
import github.scarsz.discordsrv.dependencies.commons.lang3.StringUtils;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.LangUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.SchedulerUtil;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandUnlink {
    @Command(commandNames={"unlink", "clearlinked"}, helpMessage="Unlinks your Minecraft account from your Discord account", permission="discordsrv.unlink")
    public static void execute(CommandSender sender, String[] args) {
        SchedulerUtil.runTaskAsynchronously((Plugin)DiscordSRV.getPlugin(), () -> CommandUnlink.executeAsync(sender, args));
    }

    private static void executeAsync(CommandSender sender, String[] args) {
        if (args.length == 0) {
            boolean hasLinkedAccount;
            if (!(sender instanceof Player)) {
                MessageUtil.sendMessage(sender, ChatColor.RED + LangUtil.InternalMessage.NO_UNLINK_TARGET_SPECIFIED.toString());
                return;
            }
            Player player = (Player)sender;
            String linkedId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player.getUniqueId());
            boolean bl = hasLinkedAccount = linkedId != null;
            if (hasLinkedAccount) {
                Member member2 = DiscordUtil.getMemberById(linkedId);
                String name = member2 != null ? member2.getEffectiveName() : "Discord ID " + linkedId;
                DiscordSRV.getPlugin().getAccountLinkManager().unlink(player.getUniqueId());
                MessageUtil.sendMessage(sender, LangUtil.Message.UNLINK_SUCCESS.toString().replace("%name%", name));
            } else {
                MessageUtil.sendMessage(sender, LangUtil.Message.LINK_FAIL_NOT_ASSOCIATED_WITH_AN_ACCOUNT.toString());
            }
        } else {
            OfflinePlayer player;
            if (!sender.hasPermission("discordsrv.linked.others")) {
                MessageUtil.sendMessage(sender, LangUtil.Message.NO_PERMISSION.toString());
                return;
            }
            String target = args[0];
            String joinedTarget = String.join((CharSequence)" ", args);
            if (target.length() == 32 || target.length() == 36 && args.length == 1) {
                CommandLinked.notifyInterpret(sender, "UUID");
                OfflinePlayer player2 = Bukkit.getOfflinePlayer((UUID)UUID.fromString(target));
                CommandLinked.notifyPlayer(sender, player2);
                String discordId = DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player2.getUniqueId());
                CommandLinked.notifyDiscord(sender, discordId);
                if (discordId != null) {
                    DiscordSRV.getPlugin().getAccountLinkManager().unlink(discordId);
                    CommandUnlink.notifyUnlinked(sender);
                }
                return;
            }
            if (args.length == 1 && DiscordUtil.getUserById(target) != null || StringUtils.isNumeric(target) && target.length() >= 17 && target.length() <= 20) {
                CommandLinked.notifyInterpret(sender, "Discord ID");
                UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(target);
                CommandLinked.notifyPlayer(sender, uuid != null ? Bukkit.getOfflinePlayer((UUID)uuid) : null);
                CommandLinked.notifyDiscord(sender, target);
                if (uuid != null) {
                    DiscordSRV.getPlugin().getAccountLinkManager().unlink(uuid);
                    CommandUnlink.notifyUnlinked(sender);
                }
                return;
            }
            if (args.length == 1 && target.length() >= 3 && target.length() <= 16 && (player = (OfflinePlayer)Arrays.stream(Bukkit.getOfflinePlayers()).filter(OfflinePlayer::hasPlayedBefore).filter(p -> p.getName() != null && p.getName().equalsIgnoreCase(target)).findFirst().orElse(null)) != null) {
                CommandLinked.notifyInterpret(sender, "Minecraft player");
                CommandLinked.notifyPlayer(sender, player);
                CommandLinked.notifyDiscord(sender, DiscordSRV.getPlugin().getAccountLinkManager().getDiscordId(player.getUniqueId()));
                DiscordSRV.getPlugin().getAccountLinkManager().unlink(player.getUniqueId());
                CommandUnlink.notifyUnlinked(sender);
                return;
            }
            if (joinedTarget.contains("#") || joinedTarget.length() >= 2 && joinedTarget.length() <= 37) {
                String targetUsername = joinedTarget.contains("#") ? joinedTarget.split("#")[0] : joinedTarget;
                String discriminator = joinedTarget.contains("#") ? joinedTarget.split("#")[1] : "";
                Set matches = DiscordSRV.getPlugin().getMainGuild().getMembers().stream().filter(member -> member.getUser().getName().equalsIgnoreCase(targetUsername) || member.getNickname() != null && member.getNickname().equalsIgnoreCase(targetUsername)).filter(member -> member.getUser().getDiscriminator().contains(discriminator)).map(Member::getUser).collect(Collectors.toSet());
                if (matches.size() != 0) {
                    CommandLinked.notifyInterpret(sender, "Discord name");
                    if (matches.size() == 1) {
                        User user2 = (User)matches.iterator().next();
                        CommandLinked.notifyDiscord(sender, user2.getId());
                        UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(user2.getId());
                        if (uuid != null) {
                            CommandLinked.notifyPlayer(sender, Bukkit.getOfflinePlayer((UUID)uuid));
                            DiscordSRV.getPlugin().getAccountLinkManager().unlink(user2.getId());
                            CommandUnlink.notifyUnlinked(sender);
                        } else {
                            CommandLinked.notifyPlayer(sender, null);
                        }
                    } else {
                        matches.stream().limit(5L).forEach(user -> {
                            UUID uuid = DiscordSRV.getPlugin().getAccountLinkManager().getUuid(user.getId());
                            CommandLinked.notifyPlayer(sender, uuid != null ? Bukkit.getOfflinePlayer((UUID)uuid) : null);
                            CommandLinked.notifyDiscord(sender, user.getId());
                        });
                        int remaining = matches.size() - 5;
                        if (remaining >= 1) {
                            MessageUtil.sendMessage(sender, String.format("%s+%s%d%s more result%s...", ChatColor.AQUA, ChatColor.WHITE, remaining, ChatColor.AQUA, remaining > 1 ? "s" : ""));
                        }
                        MessageUtil.sendMessage(sender, ChatColor.AQUA + "Be more specific.");
                    }
                    return;
                }
            }
            MessageUtil.sendMessage(sender, LangUtil.Message.LINKED_NOBODY_FOUND.toString().replace("%target%", joinedTarget));
        }
    }

    private static void notifyUnlinked(CommandSender sender) {
        MessageUtil.sendMessage(sender, ChatColor.WHITE + "- " + ChatColor.AQUA + " Unlinked \u2713");
    }
}

