/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.alexh.weak;

import github.scarsz.discordsrv.dependencies.alexh.weak.Dynamic;
import java.util.Iterator;
import java.util.stream.Stream;

class BreadthChildIterator
implements Iterator<Dynamic> {
    private final Dynamic root;
    private int depth;
    private Iterator<Dynamic> current;

    BreadthChildIterator(Dynamic root) {
        this.root = root;
        this.depth = 1;
        this.current = root.children().iterator();
    }

    private Stream<Dynamic> nextDepth() {
        Stream<Dynamic> childrenAtNextDepth = this.root.children();
        for (int nextDepth = 1; nextDepth <= this.depth; ++nextDepth) {
            childrenAtNextDepth = childrenAtNextDepth.flatMap(Dynamic::children);
        }
        return childrenAtNextDepth;
    }

    private boolean moveDepthIfAvailable() {
        Iterator nextDepth = this.nextDepth().iterator();
        if (nextDepth.hasNext()) {
            this.current = nextDepth;
            ++this.depth;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.current.hasNext() || this.moveDepthIfAvailable();
    }

    @Override
    public Dynamic next() {
        if (!this.current.hasNext()) {
            this.moveDepthIfAvailable();
        }
        return this.current.next();
    }
}

