/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.alexh.weak;

import github.scarsz.discordsrv.dependencies.alexh.Unchecker;
import github.scarsz.discordsrv.dependencies.alexh.weak.AbstractDynamic;
import github.scarsz.discordsrv.dependencies.alexh.weak.ChildAbsence;
import github.scarsz.discordsrv.dependencies.alexh.weak.Describer;
import github.scarsz.discordsrv.dependencies.alexh.weak.Dynamic;
import github.scarsz.discordsrv.dependencies.alexh.weak.DynamicChild;
import github.scarsz.discordsrv.dependencies.alexh.weak.ParentAbsence;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class XmlDynamic
extends AbstractDynamic<Node>
implements Describer {
    private static final String FALLBACK_TO_STRING = "Xml[unable to serialize]";
    private static final String NONE_NAMESPACE = "none";
    private static final String NS_INDICATOR = "::";

    private static Stream<Node> streamChildNodes(Node node) {
        int children = node.getChildNodes().getLength();
        Node firstChild = node.getFirstChild();
        if (firstChild == null) {
            return Stream.empty();
        }
        return Stream.iterate(firstChild, prev -> prev != null ? prev.getNextSibling() : null).limit(children).filter(n -> n != null);
    }

    private static Stream<Node> streamAttributes(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return Stream.empty();
        }
        return IntStream.range(0, attributes.getLength()).mapToObj(attributes::item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node inputSourceToNode(InputSource xml) {
        XPathExpression all = Unchecker.uncheckedGet(() -> XPathFactory.newInstance().newXPath().compile("//*"));
        Class<XPathExpression> clazz = XPathExpression.class;
        synchronized (XPathExpression.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Unchecker.uncheckedGet(() -> (Node)all.evaluate(xml, XPathConstants.NODE));
        }
    }

    public static Predicate<? super Dynamic> hasElementName(String elementName) {
        String[] nsKey = elementName.split(NS_INDICATOR);
        return element -> {
            String key;
            if (!(element instanceof XmlDynamic)) {
                return false;
            }
            String simpleName = elementName;
            if (nsKey.length == 2) {
                String namespace = nsKey[0];
                String elNamespace = ((Node)((XmlDynamic)element).inner).getNamespaceURI();
                if (NONE_NAMESPACE.equals(namespace) ? elNamespace != null : !namespace.equals(elNamespace)) {
                    return false;
                }
                simpleName = nsKey[1];
            }
            if ((key = element.key().asString()).endsWith("]")) {
                key = key.substring(0, key.lastIndexOf("["));
            }
            return key.equalsIgnoreCase(simpleName);
        };
    }

    public XmlDynamic(Node inner) {
        super(inner);
    }

    public XmlDynamic(InputSource xml) {
        this(XmlDynamic.inputSourceToNode(xml));
    }

    public XmlDynamic(Reader xml) {
        this(new InputSource(xml));
    }

    public XmlDynamic(String xml) {
        this(new StringReader(xml));
    }

    @Override
    public boolean is(Class<?> type) {
        return String.class.equals(type);
    }

    @Override
    public Dynamic get(Object keyObject) {
        String keyToString = keyObject.toString();
        if (keyToString.contains("|")) {
            return this.get(keyToString, "|");
        }
        if (this.children().allMatch(o -> false)) {
            if (this.asString().isEmpty()) {
                return new ParentAbsence.Empty<XmlDynamic>(this, keyObject);
            }
            return new ParentAbsence.Barren<XmlDynamic>(this, keyObject);
        }
        String key = keyToString.endsWith("[0]") ? keyToString.substring(0, keyToString.length() - 3) : keyToString;
        String[] nsKey = key.split(NS_INDICATOR);
        if (nsKey.length == 2) {
            return this.getWithNamespace(nsKey[0], nsKey[1]);
        }
        Optional<Dynamic> match = key.isEmpty() ? Optional.empty() : (key.startsWith("@") ? this.attributes().filter(attr -> ((Child)attr).key.equals(key)).findAny() : (key.endsWith("]") ? this.elements().filter(el -> ((Child)el).key.equals(key)).findAny() : Stream.concat(this.elements().filter(el -> ((Child)el).key.equals(key)), this.attributes().filter(attr -> ((Child)attr).key.equals("@" + key))).findFirst()));
        return match.map(Dynamic.class::cast).orElse(new ChildAbsence.Missing<XmlDynamic>(this, keyObject));
    }

    protected Dynamic getWithNamespace(String namespace, String key) {
        Predicate<Node> nodeInNamespace = NONE_NAMESPACE.equals(namespace) ? node -> node.getNamespaceURI() == null : node -> namespace.equals(node.getNamespaceURI());
        Optional<Dynamic> match = key.isEmpty() ? Optional.empty() : (key.startsWith("@") ? this.attributesWith(nodeInNamespace).filter(attr -> ((Child)attr).key.equals(key)).findAny() : (key.endsWith("]") ? this.elementsWith(nodeInNamespace).filter(el -> ((Child)el).key.equals(key)).findAny() : Stream.concat(this.elementsWith(nodeInNamespace).filter(el -> ((Child)el).key.equals(key)), this.attributesWith(nodeInNamespace).filter(attr -> ((Child)attr).key.equals("@" + key))).findFirst()));
        return match.map(Dynamic.class::cast).orElse(new ChildAbsence.Missing<XmlDynamic>(this, (Object)(namespace + NS_INDICATOR + key)));
    }

    protected Stream<Child> attributes() {
        return this.attributesWith(n -> true);
    }

    protected Stream<Child> attributesWith(Predicate<Node> predicate) {
        return Stream.empty();
    }

    protected Stream<Child> elements() {
        return this.elementsWith(n -> true);
    }

    protected Stream<Child> elementsWith(Predicate<Node> predicate) {
        return Stream.of(this.inner).filter(predicate).map(n -> this.childElement((Node)n, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<Dynamic> children() {
        Document document = ((Node)this.inner).getOwnerDocument();
        synchronized (document) {
            return Stream.concat(this.elements(), this.attributes());
        }
    }

    @Override
    protected Object keyLiteral() {
        return "root";
    }

    @Override
    public String describe() {
        if (this.isString() && this.asString().isEmpty()) {
            return "Empty-Xml";
        }
        List<String> keys = Stream.concat(this.elements(), this.attributes()).map(child -> ((Child)child).key).collect(Collectors.toList());
        HashMap<String, Integer> keyLastIndex = new HashMap<String, Integer>();
        keys.forEach(key -> {
            if (key.endsWith("]")) {
                char c;
                StringBuilder index = new StringBuilder();
                for (int i = key.length() - 2; i != -1 && (c = key.charAt(i)) != '['; --i) {
                    index.append(c);
                }
                if (index.length() != 0) {
                    keyLastIndex.put(key.substring(0, key.indexOf("[")), Integer.valueOf(index.toString()));
                }
            }
        });
        keyLastIndex.forEach((multiKey, maxIndex) -> {
            keys.removeIf(key -> key.equals(multiKey) || key.endsWith("]") && key.substring(0, key.indexOf("[")).equals(multiKey));
            keys.add(multiKey + "[0.." + maxIndex + "]");
        });
        return keys.isEmpty() ? "Xml" : "Xml" + keys.toString();
    }

    Child childElement(Node inner, int index) {
        return new Child(inner, this, index == 0 ? inner.getLocalName() : inner.getLocalName() + '[' + index + ']');
    }

    @Override
    public int hashCode() {
        String toString = this.fullXml();
        return FALLBACK_TO_STRING.equals(toString) ? super.hashCode() : toString.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        String otherAsString = ((XmlDynamic)o).fullXml();
        return !FALLBACK_TO_STRING.equals(otherAsString) && otherAsString.equals(this.fullXml());
    }

    protected LSSerializer serializer() {
        LSSerializer serializer = ((DOMImplementationLS)((Node)this.inner).getOwnerDocument().getImplementation().getFeature("LS", "3.0")).createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        return serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String asObject() {
        Document document = ((Node)this.inner).getOwnerDocument();
        synchronized (document) {
            return this.serializer().writeToString((Node)this.inner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fullXml() {
        try {
            Document document = ((Node)this.inner).getOwnerDocument();
            synchronized (document) {
                return this.serializer().writeToString((Node)this.inner);
            }
        }
        catch (RuntimeException ex) {
            return FALLBACK_TO_STRING;
        }
    }

    public String toString() {
        return this.keyLiteral() + ":" + this.describe();
    }

    static class Child
    extends XmlDynamic
    implements DynamicChild {
        private final Dynamic parent;
        private final String key;

        Child(Node inner, Dynamic parent, String key) {
            super(inner);
            this.parent = parent;
            this.key = Objects.requireNonNull(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String asObject() {
            Document document = ((Node)this.inner).getOwnerDocument();
            synchronized (document) {
                return Optional.ofNullable(((Node)this.inner).getFirstChild()).map(Node::getNodeValue).orElseGet(() -> this.elements().map(XmlDynamic::fullXml).map(String::trim).reduce((s1, s2) -> s1 + s2).orElse(""));
            }
        }

        @Override
        protected Stream<Child> attributesWith(Predicate<Node> predicate) {
            HashMap keyLastIndex = new HashMap();
            return XmlDynamic.streamAttributes((Node)this.inner).filter(predicate).map(attr -> {
                Integer index = Optional.ofNullable(keyLastIndex.get(attr.getLocalName())).map(i -> i + 1).orElse(0);
                keyLastIndex.put(attr.getLocalName(), index);
                return this.childAttribute((Node)attr, index);
            });
        }

        @Override
        protected Stream<Child> elementsWith(Predicate<Node> predicate) {
            HashMap keyLastIndex = new HashMap();
            return XmlDynamic.streamChildNodes((Node)this.inner).filter(node -> node.getLocalName() != null).filter(predicate).map(node -> {
                Integer index = Optional.ofNullable(keyLastIndex.get(node.getLocalName())).map(i -> i + 1).orElse(0);
                keyLastIndex.put(node.getLocalName(), index);
                return this.childElement((Node)node, index);
            });
        }

        @Override
        public Dynamic parent() {
            return this.parent;
        }

        @Override
        public Object keyLiteral() {
            return this.key;
        }

        Child childAttribute(Node inner, int index) {
            String name = "@" + inner.getLocalName();
            return new Child(inner, this, index == 0 ? name : name + '[' + index + ']');
        }
    }
}

