/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.google.common.collect;

import github.scarsz.discordsrv.dependencies.google.common.annotations.GwtCompatible;
import github.scarsz.discordsrv.dependencies.google.common.base.Preconditions;
import github.scarsz.discordsrv.dependencies.google.common.collect.AbstractIterator;
import github.scarsz.discordsrv.dependencies.google.common.collect.ElementTypesAreNonnullByDefault;
import java.util.Queue;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    public T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

