/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jackson.databind.ser.std;

import github.scarsz.discordsrv.dependencies.jackson.core.JsonGenerator;
import github.scarsz.discordsrv.dependencies.jackson.databind.JavaType;
import github.scarsz.discordsrv.dependencies.jackson.databind.JsonMappingException;
import github.scarsz.discordsrv.dependencies.jackson.databind.SerializerProvider;
import github.scarsz.discordsrv.dependencies.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import github.scarsz.discordsrv.dependencies.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import github.scarsz.discordsrv.dependencies.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import github.scarsz.discordsrv.dependencies.jackson.databind.ser.std.StdScalarSerializer;
import github.scarsz.discordsrv.dependencies.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset(), bbuf.limit());
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

