/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jackson.databind.ser.std;

import github.scarsz.discordsrv.dependencies.jackson.core.JsonGenerator;
import github.scarsz.discordsrv.dependencies.jackson.core.JsonToken;
import github.scarsz.discordsrv.dependencies.jackson.core.type.WritableTypeId;
import github.scarsz.discordsrv.dependencies.jackson.databind.JavaType;
import github.scarsz.discordsrv.dependencies.jackson.databind.JsonMappingException;
import github.scarsz.discordsrv.dependencies.jackson.databind.JsonNode;
import github.scarsz.discordsrv.dependencies.jackson.databind.SerializerProvider;
import github.scarsz.discordsrv.dependencies.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import github.scarsz.discordsrv.dependencies.jackson.databind.jsontype.TypeSerializer;
import github.scarsz.discordsrv.dependencies.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

