/*
 * Decompiled with CFR 0.152.
 */
package github.scarsz.discordsrv.dependencies.jackson.databind.ser.std;

import github.scarsz.discordsrv.dependencies.jackson.core.JsonGenerator;
import github.scarsz.discordsrv.dependencies.jackson.databind.JavaType;
import github.scarsz.discordsrv.dependencies.jackson.databind.JsonMappingException;
import github.scarsz.discordsrv.dependencies.jackson.databind.JsonNode;
import github.scarsz.discordsrv.dependencies.jackson.databind.SerializerProvider;
import github.scarsz.discordsrv.dependencies.jackson.databind.annotation.JacksonStdImpl;
import github.scarsz.discordsrv.dependencies.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import github.scarsz.discordsrv.dependencies.jackson.databind.jsontype.TypeSerializer;
import github.scarsz.discordsrv.dependencies.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public final class StringSerializer
extends StdScalarSerializer<Object> {
    private static final long serialVersionUID = 1L;

    public StringSerializer() {
        super(String.class, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        String str = (String)value;
        return str.length() == 0;
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString((String)value);
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        gen.writeString((String)value);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

